/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.google.protobuf.ByteString;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class MapConverter {
    public static void convertMapTensors(GrowableByteBuffer buffer, Map<String, Object> map, Consumer<SearchProtocol.TensorProperty.Builder> inserter) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Tensor)) continue;
            Tensor tensor = (Tensor)value;
            buffer.clear();
            TypedBinaryFormat.encode((Tensor)tensor, (GrowableByteBuffer)buffer);
            inserter.accept(SearchProtocol.TensorProperty.newBuilder().setName(entry.getKey()).setValue(ByteString.copyFrom((ByteBuffer)buffer.getByteBuffer().flip())));
        }
    }

    public static void convertMapPrimitives(Map<String, Object> map, Consumer<SearchProtocol.StringProperty.Builder> inserter) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Tensor) continue;
            inserter.accept(SearchProtocol.StringProperty.newBuilder().setName(entry.getKey()).addValues(value.toString()));
        }
    }

    public static void convertStringMultiMap(Map<String, List<String>> map, Consumer<SearchProtocol.StringProperty.Builder> inserter) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> values = entry.getValue();
            if (values == null) continue;
            inserter.accept(SearchProtocol.StringProperty.newBuilder().setName(entry.getKey()).addAllValues(values));
        }
    }

    public static void convertMultiMap(GrowableByteBuffer buffer, Map<String, List<Object>> map, Consumer<SearchProtocol.StringProperty.Builder> stringInserter, Consumer<SearchProtocol.TensorProperty.Builder> tensorInserter) {
        for (Map.Entry<String, List<Object>> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            String key = entry.getKey();
            ArrayList<String> stringValues = new ArrayList<String>(entry.getValue().size());
            for (Object value : entry.getValue()) {
                if (value == null) continue;
                if (value instanceof Tensor) {
                    Tensor tensor = (Tensor)value;
                    buffer.clear();
                    TypedBinaryFormat.encode((Tensor)tensor, (GrowableByteBuffer)buffer);
                    tensorInserter.accept(SearchProtocol.TensorProperty.newBuilder().setName(key).setValue(ByteString.copyFrom((ByteBuffer)buffer.getByteBuffer().flip())));
                    continue;
                }
                stringValues.add(value.toString());
            }
            if (stringValues.isEmpty()) continue;
            stringInserter.accept(SearchProtocol.StringProperty.newBuilder().setName(key).addAllValues(stringValues));
        }
    }
}

