/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.language.Language;
import com.yahoo.language.process.LinguisticsParameters;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.TokenType;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.parser.AbstractParser;
import com.yahoo.search.query.parser.Parsable;
import com.yahoo.search.query.parser.ParserEnvironment;
import java.util.ArrayList;

public final class LinguisticsParser
extends AbstractParser {
    public LinguisticsParser(ParserEnvironment environment) {
        super(environment);
    }

    @Override
    Item parse(String queryToParse, String filterToParse, Language parsingLanguage, IndexFacts.Session indexFacts, String defaultIndex, Parsable parsable) {
        LinguisticsParameters parameters = new LinguisticsParameters(parsingLanguage, StemMode.BEST, true, true);
        CompositeItem parent = this.newComposite();
        for (Token token : this.environment.getLinguistics().getTokenizer().tokenize(queryToParse, parameters)) {
            if (!token.getType().isIndexable()) continue;
            parent.addItem(this.toItem(token, defaultIndex));
        }
        return parent;
    }

    @Override
    protected Item parseItems() {
        throw new RuntimeException();
    }

    private Item toItem(Token token, String defaultIndex) {
        TermItem item;
        if (token.getType() == TokenType.NUMERIC) {
            item = new IntItem(token.getTokenString());
        } else if (token.getNumStems() == 1) {
            WordItem word = new WordItem(token.getTokenString());
            word.setStemmed(true);
            word.setNormalizable(false);
            word.setLowercased(true);
            item = word;
        } else {
            ArrayList<WordAlternativesItem.Alternative> alternatives = new ArrayList<WordAlternativesItem.Alternative>();
            for (int i = 0; i < token.getNumStems(); ++i) {
                alternatives.add(new WordAlternativesItem.Alternative(token.getStem(i), 1.0));
            }
            item = new WordAlternativesItem(defaultIndex, true, new Substring(token.getOrig()), alternatives);
            item.setNormalizable(false);
            item.setLowercased(true);
        }
        item.setIndexName(defaultIndex);
        return item;
    }
}

