/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ListMerger {
    public static <T extends Comparable<? super T>> void mergeLinkedLists(List<T> to, List<T> from, int maxEntryCount) {
        int entryCount = 0;
        ListIterator<T> i = to.listIterator();
        while (!from.isEmpty()) {
            Comparable fromElement = (Comparable)from.remove(0);
            while (i.hasNext()) {
                Comparable toElement = (Comparable)i.next();
                if (toElement.compareTo(fromElement) > 0) {
                    i.previous();
                    break;
                }
                if (++entryCount < maxEntryCount) continue;
                break;
            }
            if (entryCount >= maxEntryCount) break;
            i.add(fromElement);
            if (++entryCount < maxEntryCount) continue;
            break;
        }
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public static <T extends Comparable<? super T>> List<T> mergeIntoArrayList(List<T> l1, List<T> l2, int maxEntryCount) {
        ArrayList<Comparable> mergedList;
        block11: {
            Comparable e2;
            Comparable e1;
            ListIterator<T> i2;
            block10: {
                mergedList = new ArrayList<Comparable>();
                ListIterator<T> i1 = l1.listIterator();
                i2 = l2.listIterator();
                e1 = null;
                if (i1.hasNext()) {
                    e1 = (Comparable)i1.next();
                }
                e2 = null;
                if (i2.hasNext()) {
                    e2 = (Comparable)i2.next();
                }
                while (e1 != null && e2 != null && mergedList.size() < maxEntryCount) {
                    if (e1.compareTo(e2) <= 0) {
                        mergedList.add(e1);
                        if (i1.hasNext()) {
                            e1 = (Comparable)i1.next();
                            continue;
                        }
                        e1 = null;
                        continue;
                    }
                    mergedList.add(e2);
                    if (i2.hasNext()) {
                        e2 = (Comparable)i2.next();
                        continue;
                    }
                    e2 = null;
                }
                if (e2 != null) break block10;
                while (e1 != null && mergedList.size() < maxEntryCount) {
                    mergedList.add(e1);
                    if (i1.hasNext()) {
                        e1 = (Comparable)i1.next();
                        continue;
                    }
                    e1 = null;
                }
                break block11;
            }
            if (e1 != null) break block11;
            while (e2 != null && mergedList.size() < maxEntryCount) {
                mergedList.add(e2);
                if (i2.hasNext()) {
                    e2 = (Comparable)i2.next();
                    continue;
                }
                e2 = null;
            }
        }
        return mergedList;
    }

    public static <T extends Comparable<? super T>> List<T> mergeIntoArrayList(List<T> l1, List<T> l2) {
        return ListMerger.mergeIntoArrayList(l1, l2, Integer.MAX_VALUE);
    }
}

