// Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
package com.yahoo.vespa.streamingvisitors;

import com.yahoo.document.select.parser.ParseException;
import com.yahoo.messagebus.Trace;
import com.yahoo.prelude.fastsearch.PartialSummaryHandler;
import com.yahoo.prelude.fastsearch.TimeoutException;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.vdslib.DocumentSummary;
import com.yahoo.vdslib.SearchResult;
import com.yahoo.vdslib.VisitorStatistics;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Visitor for performing searches and accessing results.
 *
 * @author Ulf Carlin
 */
interface Visitor {

    record Context(String searchCluster,
                   String schema,
                   int traceLevelOverride,
                   PartialSummaryHandler partialSummaryHandler)
    {
        Context(String searchCluster, String schema) {
            this(searchCluster, schema, 0);
        }
        Context(String searchCluster, String schema, int traceLevelOverride) {
            this(searchCluster, schema, traceLevelOverride, null);
        }
    }

    void doSearch() throws InterruptedException, ParseException, TimeoutException;

    VisitorStatistics getStatistics();

    List<SearchResult.Hit> getHits();

    Map<String, DocumentSummary.Summary> getSummaryMap();

    int getTotalHitCount();

    List<Grouping> getGroupings();

    Set<String> getErrors();

    Trace getTrace();

}
