// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.query.rewrite;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of rewrites
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class RewritesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "b36521e379f2b10f95a6684e40489ea4";
  public final static String CONFIG_DEF_NAME = "rewrites";
  public final static String CONFIG_DEF_NAMESPACE = "search.query.rewrite";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.query.rewrite",
    "fsaDict[].name string",
    "fsaDict[].path file"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<FsaDict.Builder> fsaDict = new ArrayList<>();

    public Builder() { }

    public Builder(RewritesConfig config) {
      for (FsaDict f : config.fsaDict()) {
        fsaDict(new FsaDict.Builder(f));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.fsaDict.isEmpty())
        fsaDict.addAll(__superior.fsaDict);
      return this;
    }

    /**
     * Add the given builder to this builder's list of FsaDict builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder fsaDict(FsaDict.Builder __builder) {
      fsaDict.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder fsaDict(java.util.function.Consumer<FsaDict.Builder> __func) {
      FsaDict.Builder __inner = new FsaDict.Builder();
      __func.accept(__inner);
      fsaDict.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of FsaDict builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder fsaDict(List<FsaDict.Builder> __builders) {
      fsaDict = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public RewritesConfig build() {
      return new RewritesConfig(this);
    }

  }

  private final InnerNodeVector<FsaDict> fsaDict;

  public RewritesConfig(Builder builder) {
    this(builder, true);
  }

  private RewritesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "rewrites must be initialized: " + builder.__uninitialized);

    fsaDict = FsaDict.createVector(builder.fsaDict);
  }

  /**
   * @return rewrites.fsaDict[]
   */
  public List<FsaDict> fsaDict() {
    return fsaDict;
  }

  /**
   * @param i the index of the value to return
   * @return rewrites.fsaDict[]
   */
  public FsaDict fsaDict(int i) {
    return fsaDict.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(RewritesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("rewrites");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents rewrites.fsaDict[]
   */
  public final static class FsaDict extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "path"
        ));

      private String name = null;
      private String path = null;

      public Builder() { }

      public Builder(FsaDict config) {
        name(config.name());
        path(config.path().value());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.path != null)
          path(__superior.path);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder path(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        path = __value;
        __uninitialized.remove("path");
        return this;
      }


      public FsaDict build() {
        return new FsaDict(this);
      }

    }

    private final StringNode name;
    private final FileNode path;

    public FsaDict(Builder builder) {
      this(builder, true);
    }

    private FsaDict(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "rewrites.fsaDict[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      path = (builder.path == null) ?
          new FileNode() : new FileNode(builder.path);
    }

    /**
     * @return rewrites.fsaDict[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return rewrites.fsaDict[].path
     */
    public FileReference path() {
      return path.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(FsaDict newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("fsaDict");
      return changes;
    }

    private static InnerNodeVector<FsaDict> createVector(List<Builder> builders) {
        List<FsaDict> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new FsaDict(b));
        }
        return new InnerNodeVector<FsaDict>(elems);
    }
  }

}
