// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.pagetemplates;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of resolvers
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ResolversConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "7008ab14f4e03ab9ab61e8e78f395927";
  public final static String CONFIG_DEF_NAME = "resolvers";
  public final static String CONFIG_DEF_NAMESPACE = "search.pagetemplates";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.pagetemplates",
    "component[].id string",
    "component[].configId reference default=\":parent:\"",
    "component[].classId string default=\"\"",
    "component[].bundle string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Component.Builder> component = new ArrayList<>();

    public Builder() { }

    public Builder(ResolversConfig config) {
      for (Component c : config.component()) {
        component(new Component.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.component.isEmpty())
        component.addAll(__superior.component);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Component builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder component(Component.Builder __builder) {
      component.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder component(java.util.function.Consumer<Component.Builder> __func) {
      Component.Builder __inner = new Component.Builder();
      __func.accept(__inner);
      component.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Component builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder component(List<Component.Builder> __builders) {
      component = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ResolversConfig build() {
      return new ResolversConfig(this);
    }

  }

  private final InnerNodeVector<Component> component;

  public ResolversConfig(Builder builder) {
    this(builder, true);
  }

  private ResolversConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "resolvers must be initialized: " + builder.__uninitialized);

    component = Component.createVector(builder.component);
  }

  /**
   * @return resolvers.component[]
   */
  public List<Component> component() {
    return component;
  }

  /**
   * @param i the index of the value to return
   * @return resolvers.component[]
   */
  public Component component(int i) {
    return component.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ResolversConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("resolvers");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents resolvers.component[]
   */
  public final static class Component extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id"
        ));

      private String id = null;
      private String configId = null;
      private String classId = null;
      private String bundle = null;

      public Builder() { }

      public Builder(Component config) {
        id(config.id());
        configId(config.configId());
        classId(config.classId());
        bundle(config.bundle());
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.configId != null)
          configId(__superior.configId);
        if (__superior.classId != null)
          classId(__superior.classId);
        if (__superior.bundle != null)
          bundle(__superior.bundle);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder configId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        configId = __value;
        return this;
      }


      public Builder classId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        classId = __value;
        return this;
      }


      public Builder bundle(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        bundle = __value;
        return this;
      }


      public Component build() {
        return new Component(this);
      }

    }

    // A list of resolver components used by com.yahoo.search.PageTemplateSearcher
    // A component
    private final StringNode id;
    // The component id used by this component to subscribe to its configs (if any)
    private final ReferenceNode configId;
    // The id of the class to instantiate for this component.
    private final StringNode classId;
    // The symbolic name of the Osgi bundle this component is located in.
    // Assumed to be the same as the classid if not set.
    private final StringNode bundle;

    public Component(Builder builder) {
      this(builder, true);
    }

    private Component(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "resolvers.component[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      configId = (builder.configId == null) ?
          new ReferenceNode(":parent:") : new ReferenceNode(builder.configId);
      classId = (builder.classId == null) ?
          new StringNode("") : new StringNode(builder.classId);
      bundle = (builder.bundle == null) ?
          new StringNode("") : new StringNode(builder.bundle);
    }

    /**
     * @return resolvers.component[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return resolvers.component[].configId
     */
    public String configId() {
      return configId.value();
    }

    /**
     * @return resolvers.component[].classId
     */
    public String classId() {
      return classId.value();
    }

    /**
     * @return resolvers.component[].bundle
     */
    public String bundle() {
      return bundle.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Component newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("component");
      return changes;
    }

    private static InnerNodeVector<Component> createVector(List<Builder> builders) {
        List<Component> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Component(b));
        }
        return new InnerNodeVector<Component>(elems);
    }
  }

}
