// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.federation;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of searchchain-forward
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class SearchchainForwardConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "06ed3dc24aa5e2541d120ed83aeb700a";
  public final static String CONFIG_DEF_NAME = "searchchain-forward";
  public final static String CONFIG_DEF_NAMESPACE = "search.federation";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.federation",
    "target string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "target"
      ));

    private String target = null;

    public Builder() { }

    public Builder(SearchchainForwardConfig config) {
      target(config.target());
    }

    private Builder override(Builder __superior) {
      if (__superior.target != null)
        target(__superior.target);
      return this;
    }

    public Builder target(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      target = __value;
      __uninitialized.remove("target");
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SearchchainForwardConfig build() {
      return new SearchchainForwardConfig(this);
    }

  }

  // A searcher forwarding the incoming query to a single search chain and
  // returning the result.
  // The component specification of the search chain to forward requests to.
  private final StringNode target;

  public SearchchainForwardConfig(Builder builder) {
    this(builder, true);
  }

  private SearchchainForwardConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "searchchain-forward must be initialized: " + builder.__uninitialized);

    target = (builder.target == null) ?
        new StringNode() : new StringNode(builder.target);
  }

  /**
   * @return searchchain-forward.target
   */
  public String target() {
    return target.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SearchchainForwardConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("searchchain-forward");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
