// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.federation;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of provider
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ProviderConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "a5a414cdb85d5f5bfb789d8742386919";
  public final static String CONFIG_DEF_NAME = "provider";
  public final static String CONFIG_DEF_NAMESPACE = "search.federation";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.federation",
    "node[].host string",
    "node[].port int",
    "path string default=\"\"",
    "maxConnections int default=10000",
    "maxConnectionPerRoute int default=10000",
    "socketBufferBytes int default=8192",
    "retries int default=1",
    "readTimeout double default=-1.0",
    "connectionTimeout double default=-1.0",
    "connectionPoolTimeout double default=-1.0",
    "yca.host string default=\"yca.host must be set explicitly\"",
    "yca.port int default=3128",
    "yca.useProxy bool default=false",
    "yca.applicationId string default=\"\"",
    "yca.ttl int default=0",
    "yca.retry int default=0",
    "queryType enum { LEGACY, PROGRAMMATIC, YQL, SELECT } default=LEGACY",
    "pingOption enum { DISABLE, NORMAL, YCA } default=NORMAL",
    "followRedirects bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Node.Builder> node = new ArrayList<>();
    private String path = null;
    private Integer maxConnections = null;
    private Integer maxConnectionPerRoute = null;
    private Integer socketBufferBytes = null;
    private Integer retries = null;
    private Double readTimeout = null;
    private Double connectionTimeout = null;
    private Double connectionPoolTimeout = null;
    public Yca.Builder yca = new Yca.Builder();
    private QueryType.Enum queryType = null;
    private PingOption.Enum pingOption = null;
    private Boolean followRedirects = null;

    public Builder() { }

    public Builder(ProviderConfig config) {
      for (Node n : config.node()) {
        node(new Node.Builder(n));
      }
      path(config.path());
      maxConnections(config.maxConnections());
      maxConnectionPerRoute(config.maxConnectionPerRoute());
      socketBufferBytes(config.socketBufferBytes());
      retries(config.retries());
      readTimeout(config.readTimeout());
      connectionTimeout(config.connectionTimeout());
      connectionPoolTimeout(config.connectionPoolTimeout());
      yca(new Yca.Builder(config.yca()));
      queryType(config.queryType());
      pingOption(config.pingOption());
      followRedirects(config.followRedirects());
    }

    private Builder override(Builder __superior) {
      if (!__superior.node.isEmpty())
        node.addAll(__superior.node);
      if (__superior.path != null)
        path(__superior.path);
      if (__superior.maxConnections != null)
        maxConnections(__superior.maxConnections);
      if (__superior.maxConnectionPerRoute != null)
        maxConnectionPerRoute(__superior.maxConnectionPerRoute);
      if (__superior.socketBufferBytes != null)
        socketBufferBytes(__superior.socketBufferBytes);
      if (__superior.retries != null)
        retries(__superior.retries);
      if (__superior.readTimeout != null)
        readTimeout(__superior.readTimeout);
      if (__superior.connectionTimeout != null)
        connectionTimeout(__superior.connectionTimeout);
      if (__superior.connectionPoolTimeout != null)
        connectionPoolTimeout(__superior.connectionPoolTimeout);
      yca(yca.override(__superior.yca));
      if (__superior.queryType != null)
        queryType(__superior.queryType);
      if (__superior.pingOption != null)
        pingOption(__superior.pingOption);
      if (__superior.followRedirects != null)
        followRedirects(__superior.followRedirects);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Node builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder node(Node.Builder __builder) {
      node.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder node(java.util.function.Consumer<Node.Builder> __func) {
      Node.Builder __inner = new Node.Builder();
      __func.accept(__inner);
      node.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Node builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder node(List<Node.Builder> __builders) {
      node = __builders;
      return this;
    }

    public Builder path(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      path = __value;
      return this;
    }


    public Builder maxConnections(int __value) {
      maxConnections = __value;
      return this;
    }

    private Builder maxConnections(String __value) {
      return maxConnections(Integer.valueOf(__value));
    }

    public Builder maxConnectionPerRoute(int __value) {
      maxConnectionPerRoute = __value;
      return this;
    }

    private Builder maxConnectionPerRoute(String __value) {
      return maxConnectionPerRoute(Integer.valueOf(__value));
    }

    public Builder socketBufferBytes(int __value) {
      socketBufferBytes = __value;
      return this;
    }

    private Builder socketBufferBytes(String __value) {
      return socketBufferBytes(Integer.valueOf(__value));
    }

    public Builder retries(int __value) {
      retries = __value;
      return this;
    }

    private Builder retries(String __value) {
      return retries(Integer.valueOf(__value));
    }

    public Builder readTimeout(double __value) {
      readTimeout = __value;
      return this;
    }

    private Builder readTimeout(String __value) {
      return readTimeout(Double.valueOf(__value));
    }

    public Builder connectionTimeout(double __value) {
      connectionTimeout = __value;
      return this;
    }

    private Builder connectionTimeout(String __value) {
      return connectionTimeout(Double.valueOf(__value));
    }

    public Builder connectionPoolTimeout(double __value) {
      connectionPoolTimeout = __value;
      return this;
    }

    private Builder connectionPoolTimeout(String __value) {
      return connectionPoolTimeout(Double.valueOf(__value));
    }

    public Builder yca(Yca.Builder __builder) {
      yca = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder yca(java.util.function.Consumer<Yca.Builder> __func) {
      Yca.Builder __inner = new Yca.Builder();
      __func.accept(__inner);
      yca = __inner;
      return this;
    }

    public Builder queryType(QueryType.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      queryType = __value;
      return this;
    }

    private Builder queryType(String __value) {
      return queryType(QueryType.Enum.valueOf(__value));
    }

    public Builder pingOption(PingOption.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      pingOption = __value;
      return this;
    }

    private Builder pingOption(String __value) {
      return pingOption(PingOption.Enum.valueOf(__value));
    }

    public Builder followRedirects(boolean __value) {
      followRedirects = __value;
      return this;
    }

    private Builder followRedirects(String __value) {
      return followRedirects(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ProviderConfig build() {
      return new ProviderConfig(this);
    }

  }

  private final InnerNodeVector<Node> node;
  private final StringNode path;
  private final IntegerNode maxConnections;
  private final IntegerNode maxConnectionPerRoute;
  private final IntegerNode socketBufferBytes;
  private final IntegerNode retries;
  // Timeout for blocking IO calls in HTTP client.
  // Unit is seconds, default value is
  // in com.yahoo.search.federation.http.HTTPParameters.
  private final DoubleNode readTimeout;
  // The timeout until a connection is etablished.
  // Unit is seconds, default value is
  // in com.yahoo.search.federation.http.HTTPParameters.
  private final DoubleNode connectionTimeout;
  // Timeout when retrieving a connection from the connection manager.
  // Unit is seconds, default value is
  // in com.yahoo.search.federation.http.HTTPParameters.
  private final DoubleNode connectionPoolTimeout;
  private final Yca yca;
  // The form of the serialized query.
  private final QueryType queryType;
  // How to do pinging against a backend.
  private final PingOption pingOption;
  private final BooleanNode followRedirects;

  public ProviderConfig(Builder builder) {
    this(builder, true);
  }

  private ProviderConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "provider must be initialized: " + builder.__uninitialized);

    node = Node.createVector(builder.node);
    path = (builder.path == null) ?
        new StringNode("") : new StringNode(builder.path);
    maxConnections = (builder.maxConnections == null) ?
        new IntegerNode(10000) : new IntegerNode(builder.maxConnections);
    maxConnectionPerRoute = (builder.maxConnectionPerRoute == null) ?
        new IntegerNode(10000) : new IntegerNode(builder.maxConnectionPerRoute);
    socketBufferBytes = (builder.socketBufferBytes == null) ?
        new IntegerNode(8192) : new IntegerNode(builder.socketBufferBytes);
    retries = (builder.retries == null) ?
        new IntegerNode(1) : new IntegerNode(builder.retries);
    readTimeout = (builder.readTimeout == null) ?
        new DoubleNode(-1.0D) : new DoubleNode(builder.readTimeout);
    connectionTimeout = (builder.connectionTimeout == null) ?
        new DoubleNode(-1.0D) : new DoubleNode(builder.connectionTimeout);
    connectionPoolTimeout = (builder.connectionPoolTimeout == null) ?
        new DoubleNode(-1.0D) : new DoubleNode(builder.connectionPoolTimeout);
    yca = new Yca(builder.yca, throwIfUninitialized);
    queryType = (builder.queryType == null) ?
        new QueryType(QueryType.LEGACY) : new QueryType(builder.queryType);
    pingOption = (builder.pingOption == null) ?
        new PingOption(PingOption.NORMAL) : new PingOption(builder.pingOption);
    followRedirects = (builder.followRedirects == null) ?
        new BooleanNode(true) : new BooleanNode(builder.followRedirects);
  }

  /**
   * @return provider.node[]
   */
  public List<Node> node() {
    return node;
  }

  /**
   * @param i the index of the value to return
   * @return provider.node[]
   */
  public Node node(int i) {
    return node.get(i);
  }

  /**
   * @return provider.path
   */
  public String path() {
    return path.value();
  }

  /**
   * @return provider.maxConnections
   */
  public int maxConnections() {
    return maxConnections.value();
  }

  /**
   * @return provider.maxConnectionPerRoute
   */
  public int maxConnectionPerRoute() {
    return maxConnectionPerRoute.value();
  }

  /**
   * @return provider.socketBufferBytes
   */
  public int socketBufferBytes() {
    return socketBufferBytes.value();
  }

  /**
   * @return provider.retries
   */
  public int retries() {
    return retries.value();
  }

  /**
   * @return provider.readTimeout
   */
  public double readTimeout() {
    return readTimeout.value();
  }

  /**
   * @return provider.connectionTimeout
   */
  public double connectionTimeout() {
    return connectionTimeout.value();
  }

  /**
   * @return provider.connectionPoolTimeout
   */
  public double connectionPoolTimeout() {
    return connectionPoolTimeout.value();
  }

  /**
   * @return provider.yca
   */
  public Yca yca() {
    return yca;
  }

  /**
   * @return provider.queryType
   */
  public QueryType.Enum queryType() {
    return queryType.value();
  }

  /**
   * @return provider.pingOption
   */
  public PingOption.Enum pingOption() {
    return pingOption.value();
  }

  /**
   * @return provider.followRedirects
   */
  public boolean followRedirects() {
    return followRedirects.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ProviderConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("provider");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents provider.node[]
   */
  public final static class Node extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "host",
        "port"
        ));

      private String host = null;
      private Integer port = null;

      public Builder() { }

      public Builder(Node config) {
        host(config.host());
        port(config.port());
      }

      private Builder override(Builder __superior) {
        if (__superior.host != null)
          host(__superior.host);
        if (__superior.port != null)
          port(__superior.port);
        return this;
      }

      public Builder host(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        host = __value;
        __uninitialized.remove("host");
        return this;
      }


      public Builder port(int __value) {
        port = __value;
        __uninitialized.remove("port");
        return this;
      }

      private Builder port(String __value) {
        return port(Integer.valueOf(__value));
      }

      public Node build() {
        return new Node(this);
      }

    }

    private final StringNode host;
    private final IntegerNode port;

    public Node(Builder builder) {
      this(builder, true);
    }

    private Node(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "provider.node[] must be initialized: " + builder.__uninitialized);

      host = (builder.host == null) ?
          new StringNode() : new StringNode(builder.host);
      port = (builder.port == null) ?
          new IntegerNode() : new IntegerNode(builder.port);
    }

    /**
     * @return provider.node[].host
     */
    public String host() {
      return host.value();
    }

    /**
     * @return provider.node[].port
     */
    public int port() {
      return port.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Node newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("node");
      return changes;
    }

    private static InnerNodeVector<Node> createVector(List<Builder> builders) {
        List<Node> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Node(b));
        }
        return new InnerNodeVector<Node>(elems);
    }
  }

  /**
   * This class represents provider.yca
   */
  public final static class Yca extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String host = null;
      private Integer port = null;
      private Boolean useProxy = null;
      private String applicationId = null;
      private Integer ttl = null;
      private Integer retry = null;

      public Builder() { }

      public Builder(Yca config) {
        host(config.host());
        port(config.port());
        useProxy(config.useProxy());
        applicationId(config.applicationId());
        ttl(config.ttl());
        retry(config.retry());
      }

      private Builder override(Builder __superior) {
        if (__superior.host != null)
          host(__superior.host);
        if (__superior.port != null)
          port(__superior.port);
        if (__superior.useProxy != null)
          useProxy(__superior.useProxy);
        if (__superior.applicationId != null)
          applicationId(__superior.applicationId);
        if (__superior.ttl != null)
          ttl(__superior.ttl);
        if (__superior.retry != null)
          retry(__superior.retry);
        return this;
      }

      public Builder host(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        host = __value;
        return this;
      }


      public Builder port(int __value) {
        port = __value;
        return this;
      }

      private Builder port(String __value) {
        return port(Integer.valueOf(__value));
      }

      public Builder useProxy(boolean __value) {
        useProxy = __value;
        return this;
      }

      private Builder useProxy(String __value) {
        return useProxy(Boolean.valueOf(__value));
      }

      public Builder applicationId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        applicationId = __value;
        return this;
      }


      public Builder ttl(int __value) {
        ttl = __value;
        return this;
      }

      private Builder ttl(String __value) {
        return ttl(Integer.valueOf(__value));
      }

      public Builder retry(int __value) {
        retry = __value;
        return this;
      }

      private Builder retry(String __value) {
        return retry(Integer.valueOf(__value));
      }

      public Yca build() {
        return new Yca(this);
      }

    }

    // Certificate store proxy host
    private final StringNode host;
    // Certificate store proxy port
    private final IntegerNode port;
    // Whether a proxy is needed (i.e. should the proxy settings be used)
    private final BooleanNode useProxy;
    private final StringNode applicationId;
    // TTL to use in the certificate cache. 0 means use default cache behavior.
    // Unit is seconds.
    private final IntegerNode ttl;
    // How often to retry direct cert DB access if no certificate is found,
    // i.e. the cache TTL for null entries. Unit is seconds.
    private final IntegerNode retry;

    public Yca(Builder builder) {
      this(builder, true);
    }

    private Yca(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "provider.yca must be initialized: " + builder.__uninitialized);

      host = (builder.host == null) ?
          new StringNode("yca.host must be set explicitly") : new StringNode(builder.host);
      port = (builder.port == null) ?
          new IntegerNode(3128) : new IntegerNode(builder.port);
      useProxy = (builder.useProxy == null) ?
          new BooleanNode(false) : new BooleanNode(builder.useProxy);
      applicationId = (builder.applicationId == null) ?
          new StringNode("") : new StringNode(builder.applicationId);
      ttl = (builder.ttl == null) ?
          new IntegerNode(0) : new IntegerNode(builder.ttl);
      retry = (builder.retry == null) ?
          new IntegerNode(0) : new IntegerNode(builder.retry);
    }

    /**
     * @return provider.yca.host
     */
    public String host() {
      return host.value();
    }

    /**
     * @return provider.yca.port
     */
    public int port() {
      return port.value();
    }

    /**
     * @return provider.yca.useProxy
     */
    public boolean useProxy() {
      return useProxy.value();
    }

    /**
     * @return provider.yca.applicationId
     */
    public String applicationId() {
      return applicationId.value();
    }

    /**
     * @return provider.yca.ttl
     */
    public int ttl() {
      return ttl.value();
    }

    /**
     * @return provider.yca.retry
     */
    public int retry() {
      return retry.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Yca newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("yca");
      return changes;
    }
  }

  /**
   * This class represents provider.queryType
   * 
   * The form of the serialized query.
   */
  public final static class QueryType extends EnumNode<QueryType.Enum> {

    public QueryType(){
      this.value = null;
    }

    public QueryType(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {LEGACY, PROGRAMMATIC, YQL, SELECT}
    public final static Enum LEGACY = Enum.LEGACY;
    public final static Enum PROGRAMMATIC = Enum.PROGRAMMATIC;
    public final static Enum YQL = Enum.YQL;
    public final static Enum SELECT = Enum.SELECT;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents provider.pingOption
   * 
   * How to do pinging against a backend.
   */
  public final static class PingOption extends EnumNode<PingOption.Enum> {

    public PingOption(){
      this.value = null;
    }

    public PingOption(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {DISABLE, NORMAL, YCA}
    public final static Enum DISABLE = Enum.DISABLE;
    public final static Enum NORMAL = Enum.NORMAL;
    public final static Enum YCA = Enum.YCA;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
