// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.prelude.searcher;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of qr-quotetable
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class QrQuotetableConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "3eea072d690b5ce477fff9e48d750ad0";
  public final static String CONFIG_DEF_NAME = "qr-quotetable";
  public final static String CONFIG_DEF_NAMESPACE = "prelude.searcher";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=prelude.searcher",
    "character[].ordinal int",
    "character[].quoting string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Character.Builder> character = new ArrayList<>();

    public Builder() { }

    public Builder(QrQuotetableConfig config) {
      for (Character c : config.character()) {
        character(new Character.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.character.isEmpty())
        character.addAll(__superior.character);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Character builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder character(Character.Builder __builder) {
      character.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder character(java.util.function.Consumer<Character.Builder> __func) {
      Character.Builder __inner = new Character.Builder();
      __func.accept(__inner);
      character.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Character builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder character(List<Character.Builder> __builders) {
      character = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public QrQuotetableConfig build() {
      return new QrQuotetableConfig(this);
    }

  }

  private final InnerNodeVector<Character> character;

  public QrQuotetableConfig(Builder builder) {
    this(builder, true);
  }

  private QrQuotetableConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "qr-quotetable must be initialized: " + builder.__uninitialized);

    character = Character.createVector(builder.character);
  }

  /**
   * @return qr-quotetable.character[]
   */
  public List<Character> character() {
    return character;
  }

  /**
   * @param i the index of the value to return
   * @return qr-quotetable.character[]
   */
  public Character character(int i) {
    return character.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(QrQuotetableConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("qr-quotetable");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents qr-quotetable.character[]
   */
  public final static class Character extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "ordinal",
        "quoting"
        ));

      private Integer ordinal = null;
      private String quoting = null;

      public Builder() { }

      public Builder(Character config) {
        ordinal(config.ordinal());
        quoting(config.quoting());
      }

      private Builder override(Builder __superior) {
        if (__superior.ordinal != null)
          ordinal(__superior.ordinal);
        if (__superior.quoting != null)
          quoting(__superior.quoting);
        return this;
      }

      public Builder ordinal(int __value) {
        ordinal = __value;
        __uninitialized.remove("ordinal");
        return this;
      }

      private Builder ordinal(String __value) {
        return ordinal(Integer.valueOf(__value));
      }

      public Builder quoting(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        quoting = __value;
        __uninitialized.remove("quoting");
        return this;
      }


      public Character build() {
        return new Character(this);
      }

    }

    // The ordinal number of the character to quote in UNICODE.
    private final IntegerNode ordinal;
    // The string to translate a character to.
    private final StringNode quoting;

    public Character(Builder builder) {
      this(builder, true);
    }

    private Character(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-quotetable.character[] must be initialized: " + builder.__uninitialized);

      ordinal = (builder.ordinal == null) ?
          new IntegerNode() : new IntegerNode(builder.ordinal);
      quoting = (builder.quoting == null) ?
          new StringNode() : new StringNode(builder.quoting);
    }

    /**
     * @return qr-quotetable.character[].ordinal
     */
    public int ordinal() {
      return ordinal.value();
    }

    /**
     * @return qr-quotetable.character[].quoting
     */
    public String quoting() {
      return quoting.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Character newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("character");
      return changes;
    }

    private static InnerNodeVector<Character> createVector(List<Builder> builders) {
        List<Character> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Character(b));
        }
        return new InnerNodeVector<Character>(elems);
    }
  }

}
