// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.prelude.fastsearch;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of documentdb-info
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DocumentdbInfoConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "f48a3fd78557ceb655aa3f9efef9db6a";
  public final static String CONFIG_DEF_NAME = "documentdb-info";
  public final static String CONFIG_DEF_NAMESPACE = "prelude.fastsearch";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=prelude.fastsearch",
    "documentdb[].name string",
    "documentdb[].mode enum {INDEX, STREAMING, STORE_ONLY} default=STORE_ONLY"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Documentdb.Builder> documentdb = new ArrayList<>();

    public Builder() { }

    public Builder(DocumentdbInfoConfig config) {
      for (Documentdb d : config.documentdb()) {
        documentdb(new Documentdb.Builder(d));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.documentdb.isEmpty())
        documentdb.addAll(__superior.documentdb);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Documentdb builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder documentdb(Documentdb.Builder __builder) {
      documentdb.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder documentdb(java.util.function.Consumer<Documentdb.Builder> __func) {
      Documentdb.Builder __inner = new Documentdb.Builder();
      __func.accept(__inner);
      documentdb.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Documentdb builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder documentdb(List<Documentdb.Builder> __builders) {
      documentdb = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DocumentdbInfoConfig build() {
      return new DocumentdbInfoConfig(this);
    }

  }

  private final InnerNodeVector<Documentdb> documentdb;

  public DocumentdbInfoConfig(Builder builder) {
    this(builder, true);
  }

  private DocumentdbInfoConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "documentdb-info must be initialized: " + builder.__uninitialized);

    documentdb = Documentdb.createVector(builder.documentdb);
  }

  /**
   * @return documentdb-info.documentdb[]
   */
  public List<Documentdb> documentdb() {
    return documentdb;
  }

  /**
   * @param i the index of the value to return
   * @return documentdb-info.documentdb[]
   */
  public Documentdb documentdb(int i) {
    return documentdb.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DocumentdbInfoConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("documentdb-info");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents documentdb-info.documentdb[]
   */
  public final static class Documentdb extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      private Mode.Enum mode = null;

      public Builder() { }

      public Builder(Documentdb config) {
        name(config.name());
        mode(config.mode());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.mode != null)
          mode(__superior.mode);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder mode(Mode.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        mode = __value;
        return this;
      }

      private Builder mode(String __value) {
        return mode(Mode.Enum.valueOf(__value));
      }

      public Documentdb build() {
        return new Documentdb(this);
      }

    }

    // Contains the names of the schams present in a particular content cluster,
    // where the cluster in question is determined by the config id used to subscribe to this.
    // The name of the schema/document database
    private final StringNode name;
    private final Mode mode;

    public Documentdb(Builder builder) {
      this(builder, true);
    }

    private Documentdb(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "documentdb-info.documentdb[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      mode = (builder.mode == null) ?
          new Mode(Mode.STORE_ONLY) : new Mode(builder.mode);
    }

    /**
     * @return documentdb-info.documentdb[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return documentdb-info.documentdb[].mode
     */
    public Mode.Enum mode() {
      return mode.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Documentdb newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("documentdb");
      return changes;
    }

    private static InnerNodeVector<Documentdb> createVector(List<Builder> builders) {
        List<Documentdb> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Documentdb(b));
        }
        return new InnerNodeVector<Documentdb>(elems);
    }

    /**
     * This class represents documentdb-info.documentdb[].mode
     */
    public final static class Mode extends EnumNode<Mode.Enum> {

      public Mode(){
        this.value = null;
      }

      public Mode(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {INDEX, STREAMING, STORE_ONLY}
      public final static Enum INDEX = Enum.INDEX;
      public final static Enum STREAMING = Enum.STREAMING;
      public final static Enum STORE_ONLY = Enum.STORE_ONLY;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

}
