// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.prelude.cluster;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of qr-monitor
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class QrMonitorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "1734f7616335b69e0656d2c88d0d3e10";
  public final static String CONFIG_DEF_NAME = "qr-monitor";
  public final static String CONFIG_DEF_NAMESPACE = "prelude.cluster";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=prelude.cluster",
    "requesttimeout int default=5000"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer requesttimeout = null;

    public Builder() { }

    public Builder(QrMonitorConfig config) {
      requesttimeout(config.requesttimeout());
    }

    private Builder override(Builder __superior) {
      if (__superior.requesttimeout != null)
        requesttimeout(__superior.requesttimeout);
      return this;
    }

    public Builder requesttimeout(int __value) {
      requesttimeout = __value;
      return this;
    }

    private Builder requesttimeout(String __value) {
      return requesttimeout(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public QrMonitorConfig build() {
      return new QrMonitorConfig(this);
    }

  }

  // The number of milliseconds to attempt to complete a request before
  // giving up, including nodetimeout.
  private final IntegerNode requesttimeout;

  public QrMonitorConfig(Builder builder) {
    this(builder, true);
  }

  private QrMonitorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "qr-monitor must be initialized: " + builder.__uninitialized);

    requesttimeout = (builder.requesttimeout == null) ?
        new IntegerNode(5000) : new IntegerNode(builder.requesttimeout);
  }

  /**
   * @return qr-monitor.requesttimeout
   */
  public int requesttimeout() {
    return requesttimeout.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(QrMonitorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("qr-monitor");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
