/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class SchemaInfoConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "a28f8cd394b0692601cd7cefab46e421";
    public static final String CONFIG_DEF_NAME = "schema-info";
    public static final String CONFIG_DEF_NAMESPACE = "search.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.config", "schema[].name string", "schema[].field[].name string", "schema[].field[].type string", "schema[].field[].alias[] string", "schema[].field[].attribute bool", "schema[].field[].index bool", "schema[].field[].bitPacked bool", "schema[].fieldset[].name string", "schema[].fieldset[].field[] string", "schema[].summaryclass[].name string", "schema[].summaryclass[].fields[].name string", "schema[].summaryclass[].fields[].type string", "schema[].summaryclass[].fields[].dynamic bool default=false", "schema[].rankprofile[].name string", "schema[].rankprofile[].hasSummaryFeatures bool default=true", "schema[].rankprofile[].hasRankFeatures bool default=true", "schema[].rankprofile[].significance.useModel bool default=false", "schema[].rankprofile[].input[].name string", "schema[].rankprofile[].input[].type string"};
    private final InnerNodeVector<Schema> schema;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SchemaInfoConfig(Builder builder) {
        this(builder, true);
    }

    private SchemaInfoConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for schema-info must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.schema = Schema.createVector(builder.schema);
    }

    public List<Schema> schema() {
        return this.schema;
    }

    public Schema schema(int i) {
        return (Schema)((Object)this.schema.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SchemaInfoConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Schema.Builder> schema = new ArrayList<Schema.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SchemaInfoConfig config) {
            for (Schema s : config.schema()) {
                this.schema(new Schema.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.schema.isEmpty()) {
                this.schema.addAll(__superior.schema);
            }
            return this;
        }

        public Builder schema(Schema.Builder __builder) {
            this.schema.add(__builder);
            return this;
        }

        public Builder schema(Consumer<Schema.Builder> __func) {
            Schema.Builder __inner = new Schema.Builder();
            __func.accept(__inner);
            this.schema.add(__inner);
            return this;
        }

        public Builder schema(List<Schema.Builder> __builders) {
            this.schema = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SchemaInfoConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SchemaInfoConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SchemaInfoConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SchemaInfoConfig build() {
            return new SchemaInfoConfig(this);
        }
    }

    public static final class Schema
    extends InnerNode {
        private final StringNode name;
        private final InnerNodeVector<Field> field;
        private final InnerNodeVector<Fieldset> fieldset;
        private final InnerNodeVector<Summaryclass> summaryclass;
        private final InnerNodeVector<Rankprofile> rankprofile;

        public Schema(Builder builder) {
            this(builder, true);
        }

        private Schema(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for schema-info.schema[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.field = Field.createVector(builder.field);
            this.fieldset = Fieldset.createVector(builder.fieldset);
            this.summaryclass = Summaryclass.createVector(builder.summaryclass);
            this.rankprofile = Rankprofile.createVector(builder.rankprofile);
        }

        public String name() {
            return this.name.value();
        }

        public List<Field> field() {
            return this.field;
        }

        public Field field(int i) {
            return (Field)((Object)this.field.get(i));
        }

        public List<Fieldset> fieldset() {
            return this.fieldset;
        }

        public Fieldset fieldset(int i) {
            return (Fieldset)((Object)this.fieldset.get(i));
        }

        public List<Summaryclass> summaryclass() {
            return this.summaryclass;
        }

        public Summaryclass summaryclass(int i) {
            return (Summaryclass)((Object)this.summaryclass.get(i));
        }

        public List<Rankprofile> rankprofile() {
            return this.rankprofile;
        }

        public Rankprofile rankprofile(int i) {
            return (Rankprofile)((Object)this.rankprofile.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Schema newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("schema");
            return changes;
        }

        private static InnerNodeVector<Schema> createVector(List<Builder> builders) {
            ArrayList<Schema> elems = new ArrayList<Schema>();
            for (Builder b : builders) {
                elems.add(new Schema(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
            private String name = null;
            public List<Field.Builder> field = new ArrayList<Field.Builder>();
            public List<Fieldset.Builder> fieldset = new ArrayList<Fieldset.Builder>();
            public List<Summaryclass.Builder> summaryclass = new ArrayList<Summaryclass.Builder>();
            public List<Rankprofile.Builder> rankprofile = new ArrayList<Rankprofile.Builder>();

            public Builder() {
            }

            public Builder(Schema config) {
                this.name(config.name());
                for (Field field : config.field()) {
                    this.field(new Field.Builder(field));
                }
                for (Fieldset fieldset : config.fieldset()) {
                    this.fieldset(new Fieldset.Builder(fieldset));
                }
                for (Summaryclass summaryclass : config.summaryclass()) {
                    this.summaryclass(new Summaryclass.Builder(summaryclass));
                }
                for (Rankprofile rankprofile : config.rankprofile()) {
                    this.rankprofile(new Rankprofile.Builder(rankprofile));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.field.isEmpty()) {
                    this.field.addAll(__superior.field);
                }
                if (!__superior.fieldset.isEmpty()) {
                    this.fieldset.addAll(__superior.fieldset);
                }
                if (!__superior.summaryclass.isEmpty()) {
                    this.summaryclass.addAll(__superior.summaryclass);
                }
                if (!__superior.rankprofile.isEmpty()) {
                    this.rankprofile.addAll(__superior.rankprofile);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder field(Field.Builder __builder) {
                this.field.add(__builder);
                return this;
            }

            public Builder field(Consumer<Field.Builder> __func) {
                Field.Builder __inner = new Field.Builder();
                __func.accept(__inner);
                this.field.add(__inner);
                return this;
            }

            public Builder field(List<Field.Builder> __builders) {
                this.field = __builders;
                return this;
            }

            public Builder fieldset(Fieldset.Builder __builder) {
                this.fieldset.add(__builder);
                return this;
            }

            public Builder fieldset(Consumer<Fieldset.Builder> __func) {
                Fieldset.Builder __inner = new Fieldset.Builder();
                __func.accept(__inner);
                this.fieldset.add(__inner);
                return this;
            }

            public Builder fieldset(List<Fieldset.Builder> __builders) {
                this.fieldset = __builders;
                return this;
            }

            public Builder summaryclass(Summaryclass.Builder __builder) {
                this.summaryclass.add(__builder);
                return this;
            }

            public Builder summaryclass(Consumer<Summaryclass.Builder> __func) {
                Summaryclass.Builder __inner = new Summaryclass.Builder();
                __func.accept(__inner);
                this.summaryclass.add(__inner);
                return this;
            }

            public Builder summaryclass(List<Summaryclass.Builder> __builders) {
                this.summaryclass = __builders;
                return this;
            }

            public Builder rankprofile(Rankprofile.Builder __builder) {
                this.rankprofile.add(__builder);
                return this;
            }

            public Builder rankprofile(Consumer<Rankprofile.Builder> __func) {
                Rankprofile.Builder __inner = new Rankprofile.Builder();
                __func.accept(__inner);
                this.rankprofile.add(__inner);
                return this;
            }

            public Builder rankprofile(List<Rankprofile.Builder> __builders) {
                this.rankprofile = __builders;
                return this;
            }

            public Schema build() {
                return new Schema(this);
            }
        }

        public static final class Field
        extends InnerNode {
            private final StringNode name;
            private final StringNode type;
            private final LeafNodeVector<String, StringNode> alias;
            private final BooleanNode attribute;
            private final BooleanNode index;
            private final BooleanNode bitPacked;

            public Field(Builder builder) {
                this(builder, true);
            }

            private Field(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for schema-info.schema[].field[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.type = builder.type == null ? new StringNode() : new StringNode(builder.type);
                this.alias = new LeafNodeVector(builder.alias, (LeafNode)new StringNode());
                this.attribute = builder.attribute == null ? new BooleanNode() : new BooleanNode(builder.attribute.booleanValue());
                this.index = builder.index == null ? new BooleanNode() : new BooleanNode(builder.index.booleanValue());
                this.bitPacked = builder.bitPacked == null ? new BooleanNode() : new BooleanNode(builder.bitPacked.booleanValue());
            }

            public String name() {
                return this.name.value();
            }

            public String type() {
                return this.type.value();
            }

            public List<String> alias() {
                return this.alias.asList();
            }

            public String alias(int i) {
                return ((StringNode)this.alias.get(i)).value();
            }

            public boolean attribute() {
                return this.attribute.value();
            }

            public boolean index() {
                return this.index.value();
            }

            public boolean bitPacked() {
                return this.bitPacked.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
                return changes;
            }

            private static InnerNodeVector<Field> createVector(List<Builder> builders) {
                ArrayList<Field> elems = new ArrayList<Field>();
                for (Builder b : builders) {
                    elems.add(new Field(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name", "type", "attribute", "index", "bitPacked"));
                private String name = null;
                private String type = null;
                public List<String> alias = new ArrayList<String>();
                private Boolean attribute = null;
                private Boolean index = null;
                private Boolean bitPacked = null;

                public Builder() {
                }

                public Builder(Field config) {
                    this.name(config.name());
                    this.type(config.type());
                    this.alias(config.alias());
                    this.attribute(config.attribute());
                    this.index(config.index());
                    this.bitPacked(config.bitPacked());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.type != null) {
                        this.type(__superior.type);
                    }
                    if (!__superior.alias.isEmpty()) {
                        this.alias.addAll(__superior.alias);
                    }
                    if (__superior.attribute != null) {
                        this.attribute(__superior.attribute);
                    }
                    if (__superior.index != null) {
                        this.index(__superior.index);
                    }
                    if (__superior.bitPacked != null) {
                        this.bitPacked(__superior.bitPacked);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder type(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.type = __value;
                    this.__uninitialized.remove("type");
                    return this;
                }

                public Builder alias(String __value) {
                    this.alias.add(__value);
                    return this;
                }

                public Builder alias(Collection<String> __values) {
                    this.alias.addAll(__values);
                    return this;
                }

                public Builder attribute(boolean __value) {
                    this.attribute = __value;
                    this.__uninitialized.remove("attribute");
                    return this;
                }

                private Builder attribute(String __value) {
                    return this.attribute(Boolean.valueOf(__value));
                }

                public Builder index(boolean __value) {
                    this.index = __value;
                    this.__uninitialized.remove("index");
                    return this;
                }

                private Builder index(String __value) {
                    return this.index(Boolean.valueOf(__value));
                }

                public Builder bitPacked(boolean __value) {
                    this.bitPacked = __value;
                    this.__uninitialized.remove("bitPacked");
                    return this;
                }

                private Builder bitPacked(String __value) {
                    return this.bitPacked(Boolean.valueOf(__value));
                }

                public Field build() {
                    return new Field(this);
                }
            }
        }

        public static final class Fieldset
        extends InnerNode {
            private final StringNode name;
            private final LeafNodeVector<String, StringNode> field;

            public Fieldset(Builder builder) {
                this(builder, true);
            }

            private Fieldset(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for schema-info.schema[].fieldset[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.field = new LeafNodeVector(builder.field, (LeafNode)new StringNode());
            }

            public String name() {
                return this.name.value();
            }

            public List<String> field() {
                return this.field.asList();
            }

            public String field(int i) {
                return ((StringNode)this.field.get(i)).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Fieldset newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldset");
                return changes;
            }

            private static InnerNodeVector<Fieldset> createVector(List<Builder> builders) {
                ArrayList<Fieldset> elems = new ArrayList<Fieldset>();
                for (Builder b : builders) {
                    elems.add(new Fieldset(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;
                public List<String> field = new ArrayList<String>();

                public Builder() {
                }

                public Builder(Fieldset config) {
                    this.name(config.name());
                    this.field(config.field());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (!__superior.field.isEmpty()) {
                        this.field.addAll(__superior.field);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder field(String __value) {
                    this.field.add(__value);
                    return this;
                }

                public Builder field(Collection<String> __values) {
                    this.field.addAll(__values);
                    return this;
                }

                public Fieldset build() {
                    return new Fieldset(this);
                }
            }
        }

        public static final class Summaryclass
        extends InnerNode {
            private final StringNode name;
            private final InnerNodeVector<Fields> fields;

            public Summaryclass(Builder builder) {
                this(builder, true);
            }

            private Summaryclass(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for schema-info.schema[].summaryclass[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.fields = Fields.createVector(builder.fields);
            }

            public String name() {
                return this.name.value();
            }

            public List<Fields> fields() {
                return this.fields;
            }

            public Fields fields(int i) {
                return (Fields)((Object)this.fields.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Summaryclass newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("summaryclass");
                return changes;
            }

            private static InnerNodeVector<Summaryclass> createVector(List<Builder> builders) {
                ArrayList<Summaryclass> elems = new ArrayList<Summaryclass>();
                for (Builder b : builders) {
                    elems.add(new Summaryclass(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;
                public List<Fields.Builder> fields = new ArrayList<Fields.Builder>();

                public Builder() {
                }

                public Builder(Summaryclass config) {
                    this.name(config.name());
                    for (Fields f : config.fields()) {
                        this.fields(new Fields.Builder(f));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (!__superior.fields.isEmpty()) {
                        this.fields.addAll(__superior.fields);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder fields(Fields.Builder __builder) {
                    this.fields.add(__builder);
                    return this;
                }

                public Builder fields(Consumer<Fields.Builder> __func) {
                    Fields.Builder __inner = new Fields.Builder();
                    __func.accept(__inner);
                    this.fields.add(__inner);
                    return this;
                }

                public Builder fields(List<Fields.Builder> __builders) {
                    this.fields = __builders;
                    return this;
                }

                public Summaryclass build() {
                    return new Summaryclass(this);
                }
            }

            public static final class Fields
            extends InnerNode {
                private final StringNode name;
                private final StringNode type;
                private final BooleanNode dynamic;

                public Fields(Builder builder) {
                    this(builder, true);
                }

                private Fields(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for schema-info.schema[].summaryclass[].fields[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.type = builder.type == null ? new StringNode() : new StringNode(builder.type);
                    this.dynamic = builder.dynamic == null ? new BooleanNode(false) : new BooleanNode(builder.dynamic.booleanValue());
                }

                public String name() {
                    return this.name.value();
                }

                public String type() {
                    return this.type.value();
                }

                public boolean dynamic() {
                    return this.dynamic.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Fields newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("fields");
                    return changes;
                }

                private static InnerNodeVector<Fields> createVector(List<Builder> builders) {
                    ArrayList<Fields> elems = new ArrayList<Fields>();
                    for (Builder b : builders) {
                        elems.add(new Fields(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("name", "type"));
                    private String name = null;
                    private String type = null;
                    private Boolean dynamic = null;

                    public Builder() {
                    }

                    public Builder(Fields config) {
                        this.name(config.name());
                        this.type(config.type());
                        this.dynamic(config.dynamic());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.type != null) {
                            this.type(__superior.type);
                        }
                        if (__superior.dynamic != null) {
                            this.dynamic(__superior.dynamic);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder type(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.type = __value;
                        this.__uninitialized.remove("type");
                        return this;
                    }

                    public Builder dynamic(boolean __value) {
                        this.dynamic = __value;
                        return this;
                    }

                    private Builder dynamic(String __value) {
                        return this.dynamic(Boolean.valueOf(__value));
                    }

                    public Fields build() {
                        return new Fields(this);
                    }
                }
            }
        }

        public static final class Rankprofile
        extends InnerNode {
            private final StringNode name;
            private final BooleanNode hasSummaryFeatures;
            private final BooleanNode hasRankFeatures;
            private final Significance significance;
            private final InnerNodeVector<Input> input;

            public Rankprofile(Builder builder) {
                this(builder, true);
            }

            private Rankprofile(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for schema-info.schema[].rankprofile[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.hasSummaryFeatures = builder.hasSummaryFeatures == null ? new BooleanNode(true) : new BooleanNode(builder.hasSummaryFeatures.booleanValue());
                this.hasRankFeatures = builder.hasRankFeatures == null ? new BooleanNode(true) : new BooleanNode(builder.hasRankFeatures.booleanValue());
                this.significance = new Significance(builder.significance, throwIfUninitialized);
                this.input = Input.createVector(builder.input);
            }

            public String name() {
                return this.name.value();
            }

            public boolean hasSummaryFeatures() {
                return this.hasSummaryFeatures.value();
            }

            public boolean hasRankFeatures() {
                return this.hasRankFeatures.value();
            }

            public Significance significance() {
                return this.significance;
            }

            public List<Input> input() {
                return this.input;
            }

            public Input input(int i) {
                return (Input)((Object)this.input.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Rankprofile newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("rankprofile");
                return changes;
            }

            private static InnerNodeVector<Rankprofile> createVector(List<Builder> builders) {
                ArrayList<Rankprofile> elems = new ArrayList<Rankprofile>();
                for (Builder b : builders) {
                    elems.add(new Rankprofile(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;
                private Boolean hasSummaryFeatures = null;
                private Boolean hasRankFeatures = null;
                public Significance.Builder significance = new Significance.Builder();
                public List<Input.Builder> input = new ArrayList<Input.Builder>();

                public Builder() {
                }

                public Builder(Rankprofile config) {
                    this.name(config.name());
                    this.hasSummaryFeatures(config.hasSummaryFeatures());
                    this.hasRankFeatures(config.hasRankFeatures());
                    this.significance(new Significance.Builder(config.significance()));
                    for (Input i : config.input()) {
                        this.input(new Input.Builder(i));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.hasSummaryFeatures != null) {
                        this.hasSummaryFeatures(__superior.hasSummaryFeatures);
                    }
                    if (__superior.hasRankFeatures != null) {
                        this.hasRankFeatures(__superior.hasRankFeatures);
                    }
                    this.significance(this.significance.override(__superior.significance));
                    if (!__superior.input.isEmpty()) {
                        this.input.addAll(__superior.input);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder hasSummaryFeatures(boolean __value) {
                    this.hasSummaryFeatures = __value;
                    return this;
                }

                private Builder hasSummaryFeatures(String __value) {
                    return this.hasSummaryFeatures(Boolean.valueOf(__value));
                }

                public Builder hasRankFeatures(boolean __value) {
                    this.hasRankFeatures = __value;
                    return this;
                }

                private Builder hasRankFeatures(String __value) {
                    return this.hasRankFeatures(Boolean.valueOf(__value));
                }

                public Builder significance(Significance.Builder __builder) {
                    this.significance = __builder;
                    return this;
                }

                public Builder significance(Consumer<Significance.Builder> __func) {
                    Significance.Builder __inner = new Significance.Builder();
                    __func.accept(__inner);
                    this.significance = __inner;
                    return this;
                }

                public Builder input(Input.Builder __builder) {
                    this.input.add(__builder);
                    return this;
                }

                public Builder input(Consumer<Input.Builder> __func) {
                    Input.Builder __inner = new Input.Builder();
                    __func.accept(__inner);
                    this.input.add(__inner);
                    return this;
                }

                public Builder input(List<Input.Builder> __builders) {
                    this.input = __builders;
                    return this;
                }

                public Rankprofile build() {
                    return new Rankprofile(this);
                }
            }

            public static final class Significance
            extends InnerNode {
                private final BooleanNode useModel;

                public Significance(Builder builder) {
                    this(builder, true);
                }

                private Significance(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for schema-info.schema[].rankprofile[].significance must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.useModel = builder.useModel == null ? new BooleanNode(false) : new BooleanNode(builder.useModel.booleanValue());
                }

                public boolean useModel() {
                    return this.useModel.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Significance newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("significance");
                    return changes;
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Boolean useModel = null;

                    public Builder() {
                    }

                    public Builder(Significance config) {
                        this.useModel(config.useModel());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.useModel != null) {
                            this.useModel(__superior.useModel);
                        }
                        return this;
                    }

                    public Builder useModel(boolean __value) {
                        this.useModel = __value;
                        return this;
                    }

                    private Builder useModel(String __value) {
                        return this.useModel(Boolean.valueOf(__value));
                    }

                    public Significance build() {
                        return new Significance(this);
                    }
                }
            }

            public static final class Input
            extends InnerNode {
                private final StringNode name;
                private final StringNode type;

                public Input(Builder builder) {
                    this(builder, true);
                }

                private Input(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for schema-info.schema[].rankprofile[].input[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.type = builder.type == null ? new StringNode() : new StringNode(builder.type);
                }

                public String name() {
                    return this.name.value();
                }

                public String type() {
                    return this.type.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Input newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("input");
                    return changes;
                }

                private static InnerNodeVector<Input> createVector(List<Builder> builders) {
                    ArrayList<Input> elems = new ArrayList<Input>();
                    for (Builder b : builders) {
                        elems.add(new Input(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("name", "type"));
                    private String name = null;
                    private String type = null;

                    public Builder() {
                    }

                    public Builder(Input config) {
                        this.name(config.name());
                        this.type(config.type());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.type != null) {
                            this.type(__superior.type);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder type(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.type = __value;
                        this.__uninitialized.remove("type");
                        return this;
                    }

                    public Input build() {
                        return new Input(this);
                    }
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

