/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.engine.NameSpace;
import com.yahoo.prelude.semantics.engine.RuleBaseLinguistics;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Condition;

public class TermCondition
extends Condition {
    private final RuleBaseLinguistics linguistics;
    private final String originalTerm;
    private final String term;

    public TermCondition(String term, RuleBaseLinguistics linguistics) {
        this(null, term, linguistics);
    }

    public TermCondition(String label, String term, RuleBaseLinguistics linguistics) {
        super(label);
        this.linguistics = linguistics;
        this.originalTerm = term;
        this.term = linguistics.process(term);
    }

    @Override
    protected boolean doesMatch(RuleEvaluation e) {
        boolean matches;
        if (this.getNameSpace() != null) {
            NameSpace nameSpace = e.getEvaluation().getNameSpace(this.getNameSpace());
            return nameSpace.matches(this.originalTerm, e);
        }
        if (e.currentItem() == null) {
            return false;
        }
        if (!this.labelMatches(e)) {
            return false;
        }
        boolean bl = matches = this.labelMatches(e.currentItem().getItem(), e) && this.linguistics.process(e.currentItem().getItem().stringValue()).equals(this.term);
        if (matches && !e.isInNegation() || !matches && e.isInNegation()) {
            e.addMatch(e.currentItem(), this.originalTerm);
            e.setValue(this.term);
            e.next();
        }
        return matches;
    }

    public String term() {
        return this.term;
    }

    @Override
    public String toInnerString() {
        return this.getLabelString() + this.term;
    }
}

