/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import java.time.Duration;
import java.time.Instant;

class RequestDuration {
    private final long startTime;
    private long endTime;

    RequestDuration() {
        this(System.nanoTime());
    }

    private RequestDuration(long startTime) {
        this.startTime = startTime;
    }

    RequestDuration complete() {
        this.endTime = System.nanoTime();
        return this;
    }

    private RequestDuration complete(long duration) {
        this.endTime = this.startTime + duration;
        return this;
    }

    Duration duration() {
        return Duration.ofNanos(this.endTime - this.startTime);
    }

    Duration difference(RequestDuration prev) {
        return Duration.ofNanos(Math.abs(this.endTime - prev.endTime));
    }

    static RequestDuration of(Duration duration) {
        return new RequestDuration().complete(duration.toNanos());
    }

    static RequestDuration of(Instant sinceEpoch, Duration duration) {
        return new RequestDuration(sinceEpoch.toEpochMilli() * 1000000L).complete(duration.toNanos());
    }
}

