/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.search.Query;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.query.ranking.RankFeatures;
import com.yahoo.search.query.ranking.RankProperties;
import com.yahoo.tensor.Tensor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

record PreparedInput(String name, Tensor value) {
    static List<PreparedInput> findFromQuery(Query query, Collection<String> queryFeatures, Map<String, Tensor> defaultValues) {
        ArrayList<PreparedInput> result = new ArrayList<PreparedInput>();
        Ranking ranking = query.getRanking();
        RankFeatures rankFeatures = ranking.getFeatures();
        RankProperties rankProps = ranking.getProperties();
        for (String queryFeatureName : queryFeatures) {
            Tensor t;
            String needed = "query(" + queryFeatureName + ")";
            Optional<Tensor> feature = rankProps.getAsTensor(queryFeatureName);
            if (feature.isEmpty()) {
                feature = rankFeatures.getTensor(needed);
            }
            if (feature.isEmpty() && (t = defaultValues.get(needed)) != null) {
                feature = Optional.of(t);
            }
            if (feature.isEmpty()) {
                throw new IllegalArgumentException("missing query feature: " + queryFeatureName);
            }
            result.add(new PreparedInput(needed, feature.get()));
        }
        return result;
    }
}

