/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.model;

import com.yahoo.component.provider.FreezableClass;
import com.yahoo.search.pagetemplates.model.AbstractChoice;
import com.yahoo.search.pagetemplates.model.Layout;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.PageTemplateVisitor;
import com.yahoo.search.pagetemplates.model.Renderer;
import com.yahoo.search.pagetemplates.model.Source;
import com.yahoo.search.query.Sorting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Section
extends FreezableClass
implements PageElement {
    private final String id;
    private Layout layout = Layout.column;
    private String region;
    private List<PageElement> elements = new ArrayList<PageElement>();
    private List<PageElement> sections;
    private List<PageElement> sources;
    private List<PageElement> renderers;
    private int max = -1;
    private int min = -1;
    private Sorting order = null;
    private static AtomicInteger nextId = new AtomicInteger();

    public Section() {
        this(null);
    }

    public Section(String id) {
        this.id = id == null || id.isEmpty() ? String.valueOf("section_" + nextId.incrementAndGet()) : id;
    }

    public String getId() {
        return this.id;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.ensureNotFrozen();
        if (layout == null) {
            layout = Layout.column;
        }
        this.layout = layout;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.ensureNotFrozen();
        this.region = region;
    }

    public List<PageElement> elements() {
        return this.elements;
    }

    public List<PageElement> elements(Class pageTemplateModelElementClass) {
        if (this.isFrozen()) {
            if (pageTemplateModelElementClass == Section.class) {
                return this.sections;
            }
            if (pageTemplateModelElementClass == Source.class) {
                return this.sources;
            }
            if (pageTemplateModelElementClass == Renderer.class) {
                return this.renderers;
            }
        }
        return this.createElementList(pageTemplateModelElementClass);
    }

    private List<PageElement> createElementList(Class pageTemplateModelElementClass) {
        ArrayList<PageElement> filteredElements = new ArrayList<PageElement>();
        for (PageElement element : this.elements) {
            if (pageTemplateModelElementClass.isAssignableFrom(element.getClass())) {
                filteredElements.add(element);
                continue;
            }
            if (!(element instanceof AbstractChoice) || !((AbstractChoice)element).isChoiceBetween(pageTemplateModelElementClass)) continue;
            filteredElements.add(element);
        }
        return Collections.unmodifiableList(filteredElements);
    }

    public Sorting getOrder() {
        return this.order;
    }

    public void setOrder(Sorting order) {
        this.ensureNotFrozen();
        this.order = order;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.ensureNotFrozen();
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.ensureNotFrozen();
        this.min = min;
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        for (PageElement element : this.elements) {
            element.freeze();
        }
        this.elements = Collections.unmodifiableList(this.elements);
        this.sections = this.createElementList(Section.class);
        this.sources = this.createElementList(Source.class);
        this.renderers = this.createElementList(Renderer.class);
        super.freeze();
    }

    @Override
    public void accept(PageTemplateVisitor visitor) {
        visitor.visit(this);
        for (PageElement element : this.elements) {
            element.accept(visitor);
        }
    }

    public String toString() {
        if (this.id == null || this.id.isEmpty()) {
            return "a section";
        }
        return "section '" + this.id + "'";
    }
}

