/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.ConstantValue;
import com.yahoo.search.grouping.request.ConstantValueComparator;
import com.yahoo.search.grouping.request.GroupingExpression;
import java.util.Objects;

public class BucketValue
extends GroupingExpression
implements Comparable<BucketValue> {
    private final ConstantValue<?> from;
    private final ConstantValue<?> to;
    private final ConstantValueComparator comparator = new ConstantValueComparator();

    protected BucketValue(String label, Integer level, ConstantValue<?> inclusiveFrom, ConstantValue<?> exclusiveTo) {
        super("bucket[" + BucketValue.asImage(inclusiveFrom) + ", " + BucketValue.asImage(exclusiveTo) + ">", label, level);
        if (this.comparator.compare(exclusiveTo, inclusiveFrom) < 0) {
            throw new IllegalArgumentException("Bucket to-value can not be less than from-value.");
        }
        this.from = inclusiveFrom;
        this.to = exclusiveTo;
    }

    @Override
    public BucketValue copy() {
        return new BucketValue(this.getLabel(), this.getLevelOrNull(), this.getFrom().copy(), this.getTo().copy());
    }

    public ConstantValue<?> getFrom() {
        return this.from;
    }

    public ConstantValue<?> getTo() {
        return this.to;
    }

    @Override
    public int compareTo(BucketValue rhs) {
        if (this.comparator.compare(this.to, rhs.from) <= 0) {
            return -1;
        }
        if (this.comparator.compare(this.from, rhs.to) >= 0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketValue)) {
            return false;
        }
        BucketValue other = (BucketValue)o;
        if (!Objects.equals(this.from, other.from)) {
            return false;
        }
        return Objects.equals(this.to, other.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

