/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@After(value={"blendedResult"})
@Before(value={"unblendedResult"})
@Provides(value={"Blending"})
public class BlendingSearcher
extends Searcher {
    public static final String BLENDING = "Blending";
    private final String blendingField;

    @Inject
    public BlendingSearcher(ComponentId id, QrSearchersConfig cfg) {
        super(id);
        QrSearchersConfig.Com.Yahoo.Prelude.Searcher.BlendingSearcher s = cfg.com().yahoo().prelude().searcher().BlendingSearcher();
        this.blendingField = !s.docid().isEmpty() ? s.docid() : null;
    }

    public BlendingSearcher(String blendingField) {
        this.blendingField = blendingField;
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result result = execution.search(query);
        Result blended = this.blendResults(result, query, query.getOffset(), query.getHits(), execution);
        blended.trace("Blended result");
        return blended;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        execution.fill(result, summaryClass);
        result.analyzeHits();
    }

    protected Result blendResults(Result result, Query q, int offset, int hits, Execution execution) {
        boolean foundNonGroup = false;
        Iterator<Hit> hitIterator = result.hits().iterator();
        ArrayList<HitGroup> groups = new ArrayList<HitGroup>();
        while (hitIterator.hasNext()) {
            Hit hit = hitIterator.next();
            if (hit instanceof HitGroup) {
                groups.add((HitGroup)hit);
                hitIterator.remove();
                continue;
            }
            if (hit.isMeta()) continue;
            foundNonGroup = true;
        }
        if (foundNonGroup) {
            result.hits().addError(ErrorMessage.createUnspecifiedError("Blendingsearcher could not blend - there are toplevel hits that are not hitgroups"));
            return result;
        }
        if (groups.isEmpty()) {
            return result;
        }
        if (groups.size() == 1) {
            result.hits().addAll(((HitGroup)groups.get(0)).asUnorderedHits());
            result.hits().setOrderer(((HitGroup)groups.get(0)).getOrderer());
            return result;
        }
        if (this.blendingField != null) {
            return this.blendResultsUniquely(result, q, offset, hits, groups, execution);
        }
        return this.blendResultsDirectly(result, q, offset, hits, groups, execution);
    }

    private Result sortAndTrimResults(Result result, Query q, int offset, int hits, Execution execution) {
        if (q.getRanking().getSorting() != null) {
            execution.fill(result, "attributeprefetch");
            result.hits().sort();
        }
        result.hits().trim(offset, hits);
        return result;
    }

    private Result blendResultsDirectly(Result result, Query q, int offset, int hits, List<HitGroup> groups, Execution execution) {
        BasicMerger m = new BasicMerger(result, groups.get(0));
        m.scanResult(execution);
        m.mergeResults(groups, execution);
        return this.sortAndTrimResults(m.getResult(), q, offset, hits, execution);
    }

    private Result blendResultsUniquely(Result result, Query q, int offset, int hits, List<HitGroup> groups, Execution execution) {
        UniqueMerger m = new UniqueMerger(result, groups.get(0), new HashSet<String>(20));
        m.scanResult(execution);
        m.mergeResults(groups, execution);
        return this.sortAndTrimResults(m.getResult(), q, offset, hits, execution);
    }

    private class BasicMerger
    extends DocumentMerger {
        BasicMerger(Result result, HitGroup group) {
            this.result = result;
            this.group = group;
        }

        @Override
        void put(HitGroup source, Hit hit, Execution execution) {
            this.result.hits().add(hit);
        }

        @Override
        void scan(Hit hit, int i, Execution execution) {
            this.result.hits().add(hit);
        }
    }

    private abstract class DocumentMerger {
        protected Set<String> documentsToStrip;
        protected Result result;
        protected HitGroup group;

        private DocumentMerger() {
        }

        abstract void put(HitGroup var1, Hit var2, Execution var3);

        abstract void scan(Hit var1, int var2, Execution var3);

        Result getResult() {
            return this.result;
        }

        private String getProperty(Hit hit, String field) {
            if ("[id]".equals(field)) {
                return hit.getId().toString();
            }
            Object o = hit.getField(field);
            return o == null ? null : o.toString();
        }

        protected void storeID(Hit hit, Execution execution) {
            String id = this.getProperty(hit, BlendingSearcher.this.blendingField);
            if (id != null) {
                this.documentsToStrip.add(id);
            } else if (!this.result.isFilled(this.result.getQuery().getPresentation().getSummary())) {
                BlendingSearcher.this.fill(this.result, this.result.getQuery().getPresentation().getSummary(), execution);
                id = this.getProperty(hit, BlendingSearcher.this.blendingField);
                if (id != null) {
                    this.documentsToStrip.add(id);
                }
            }
        }

        protected boolean known(HitGroup source, Hit hit, Execution execution) {
            String stripID = this.getProperty(hit, BlendingSearcher.this.blendingField);
            if (stripID == null) {
                if (!source.isFilled(this.result.getQuery().getPresentation().getSummary())) {
                    Result nResult = new Result(this.result.getQuery());
                    nResult.hits().add(source);
                    BlendingSearcher.this.fill(nResult, nResult.getQuery().getPresentation().getSummary(), execution);
                    stripID = this.getProperty(hit, BlendingSearcher.this.blendingField);
                    if (stripID == null) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (this.documentsToStrip.contains(stripID)) {
                return true;
            }
            this.documentsToStrip.add(stripID);
            return false;
        }

        void scanResult(Execution execution) {
            List<Hit> hits = this.group.asUnorderedHits();
            for (int i = hits.size() - 1; i >= 0; --i) {
                Hit hit = hits.get(i);
                if (!hit.isMeta()) {
                    this.scan(hit, i, execution);
                    continue;
                }
                this.result.hits().add(hit);
            }
        }

        void mergeResults(List<HitGroup> groups, Execution execution) {
            for (HitGroup group : groups.subList(1, groups.size())) {
                for (Hit hit : group.asList()) {
                    if (hit.isMeta()) {
                        this.result.hits().add(hit);
                        continue;
                    }
                    this.put(group, hit, execution);
                }
            }
        }
    }

    private class UniqueMerger
    extends DocumentMerger {
        UniqueMerger(Result result, HitGroup group, Set<String> documentsToStrip) {
            this.documentsToStrip = documentsToStrip;
            this.result = result;
            this.group = group;
        }

        @Override
        void scan(Hit hit, int i, Execution execution) {
            this.result.hits().add(hit);
            if (!hit.isMeta()) {
                this.storeID(hit, execution);
            }
        }

        @Override
        void put(HitGroup source, Hit hit, Execution execution) {
            if (!hit.isMeta()) {
                if (!this.known(source, hit, execution)) {
                    this.addHit(hit);
                }
            } else {
                this.result.hits().add(hit);
            }
        }

        protected void addHit(Hit hit) {
            this.result.hits().add(hit);
        }
    }
}

