/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.IndexedSegmentItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;

public class PhraseSegmentItem
extends IndexedSegmentItem {
    private boolean explicit = false;

    public PhraseSegmentItem(AndSegmentItem andSegment) {
        super(andSegment.getRawWord(), andSegment.stringValue(), andSegment.isFromQuery(), andSegment.isStemmed(), andSegment.getOrigin());
        if (andSegment.getItemCount() > 0) {
            WordItem w = (WordItem)andSegment.getItem(0);
            this.setIndexName(w.getIndexName());
            ListIterator<Item> i = andSegment.getItemIterator();
            while (i.hasNext()) {
                WordItem word = (WordItem)i.next();
                this.addWordItem(word);
            }
        }
    }

    public PhraseSegmentItem(String rawWord, boolean isFromQuery, boolean stemmed) {
        super(rawWord, rawWord, isFromQuery, stemmed, null);
    }

    public PhraseSegmentItem(String rawWord, String current, boolean isFromQuery, boolean stemmed) {
        super(rawWord, current, isFromQuery, stemmed, null);
    }

    public PhraseSegmentItem(String rawWord, String current, boolean isFromQuery, boolean stemmed, Substring substring) {
        super(rawWord, current, isFromQuery, stemmed, substring);
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.PHRASE;
    }

    @Override
    public String getName() {
        return "SPHRASE";
    }

    @Override
    public void setIndexName(String index) {
        super.setIndexName(index);
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            WordItem word = (WordItem)i.next();
            word.setIndexName(index);
        }
    }

    @Override
    public void setWeight(int weight) {
        super.setWeight(weight);
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item word = (Item)i.next();
            word.setWeight(weight);
        }
    }

    @Override
    public void addItem(Item item) {
        if (!(item instanceof WordItem)) {
            throw new IllegalArgumentException("Can not add " + String.valueOf(item) + " to a segment phrase");
        }
        this.addWordItem((WordItem)item);
    }

    @Override
    public Optional<Item> extractSingleChild() {
        Optional<Item> extracted = super.extractSingleChild();
        extracted.ifPresent(e -> e.setWeight(this.getWeight()));
        return extracted;
    }

    private void addWordItem(WordItem word) {
        word.setIndexName(this.getIndexName());
        super.addItem(word);
    }

    public WordItem getWordItem(int index) {
        return (WordItem)this.getItem(index);
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
    }

    @Override
    public int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        return this.encodeContent(buffer, 1);
    }

    public int encodeContent(ByteBuffer buffer) {
        return this.encodeContent(buffer, 0);
    }

    private int encodeContent(ByteBuffer buffer, int itemCount) {
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item subitem = (Item)i.next();
            itemCount += subitem.encode(buffer);
        }
        return itemCount;
    }

    @Override
    protected boolean shouldParenthesize() {
        return false;
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        this.appendIndexString(buffer);
        this.appendContentsString(buffer);
    }

    void appendContentsString(StringBuilder buffer) {
        buffer.append("'");
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            WordItem wordItem = (WordItem)i.next();
            buffer.append(wordItem.getWord());
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        buffer.append("'");
    }

    @Override
    public String getIndexedString() {
        StringBuilder buf = new StringBuilder();
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            IndexedItem indexedItem = (IndexedItem)i.next();
            buf.append(indexedItem.getIndexedString());
            if (!i.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("explicit", this.explicit);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.explicit == ((PhraseSegmentItem)other).explicit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.explicit);
    }
}

