/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.TermType;
import com.yahoo.prelude.semantics.engine.EvaluationException;
import com.yahoo.prelude.semantics.engine.Match;
import com.yahoo.prelude.semantics.engine.ReferencedMatches;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.ChoiceCondition;
import com.yahoo.prelude.semantics.rule.Condition;
import com.yahoo.prelude.semantics.rule.NamedCondition;
import com.yahoo.prelude.semantics.rule.SequenceCondition;
import com.yahoo.prelude.semantics.rule.TermCondition;
import com.yahoo.prelude.semantics.rule.TermProduction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ReferenceTermProduction
extends TermProduction {
    private final String reference;
    private final boolean produceAll;

    public ReferenceTermProduction(String reference, boolean produceAll) {
        this.reference = Objects.requireNonNull(reference, "Reference cannot be null");
        this.produceAll = produceAll;
    }

    public ReferenceTermProduction(String reference, TermType termType, boolean produceAll) {
        super(termType);
        this.reference = Objects.requireNonNull(reference, "Reference cannot be null");
        this.produceAll = produceAll;
    }

    public ReferenceTermProduction(String label, String reference, boolean produceAll) {
        super(label);
        this.reference = Objects.requireNonNull(reference, "Reference cannot be null");
        this.produceAll = produceAll;
    }

    public ReferenceTermProduction(String label, String reference, TermType termType, boolean produceAll) {
        super(label, termType);
        this.reference = Objects.requireNonNull(reference, "Reference cannot be null");
        this.produceAll = produceAll;
    }

    public String getReference() {
        return this.reference;
    }

    public boolean producesAll() {
        return this.produceAll;
    }

    @Override
    void addMatchReferences(Set<String> matchReferences) {
        matchReferences.add(this.reference);
    }

    @Override
    public void produce(RuleEvaluation e, int ignored) {
        ReferencedMatches referencedMatches = e.getReferencedMatches(this.reference);
        if (referencedMatches == null) {
            throw new EvaluationException("Referred match '" + this.reference + "' not found");
        }
        if (this.replacing) {
            e.removeMatches(referencedMatches);
        }
        Match match = referencedMatches.matchIterator().next();
        if (this.produceAll) {
            NamedCondition namedCondition = e.getEvaluation().ruleBase().getCondition(referencedMatches.getContextName());
            ChoiceCondition choices = (ChoiceCondition)namedCondition.getCondition();
            ArrayList<Item> items = new ArrayList<Item>();
            Iterator<Condition> i = choices.conditionIterator();
            while (i.hasNext()) {
                Condition condition = i.next();
                if (condition instanceof TermCondition) {
                    items.add(match.toItem(this.getLabel(), ((TermCondition)condition).term()));
                    continue;
                }
                if (condition instanceof SequenceCondition) {
                    PhraseItem phrase = new PhraseItem(this.getLabel());
                    for (Condition term : ((SequenceCondition)condition).conditions()) {
                        phrase.addItem(match.toItem(this.getLabel(), ((TermCondition)term).term()));
                    }
                    items.add(phrase);
                    continue;
                }
                throw new EvaluationException("Could not produce all terms in " + String.valueOf(namedCondition) + " as it is not a term or sequence condition");
            }
            this.produce(e, match, items, 0);
        } else {
            this.produce(e, match, List.of(referencedMatches.toItem(this.getLabel())), 0);
        }
    }

    private void produce(RuleEvaluation e, Match match, List<Item> items, int offset) {
        if (this.replacing) {
            this.insertMatch(e, match, items, offset);
        } else {
            e.addItems(items, this.getTermType());
        }
    }

    @Override
    public String toInnerTermString() {
        return this.getLabelString() + "[" + this.reference + "]";
    }
}

