/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.TensorInfo;
import java.io.IOException;

public abstract class OnnxTensorLike
implements OnnxValue {
    protected final long nativeHandle;
    protected final long allocatorHandle;
    protected final TensorInfo info;
    protected boolean closed;

    OnnxTensorLike(long nativeHandle, long allocatorHandle, TensorInfo info) {
        this.nativeHandle = nativeHandle;
        this.allocatorHandle = allocatorHandle;
        this.info = info;
        this.closed = false;
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public TensorInfo getInfo() {
        return this.info;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Trying to use a closed OnnxValue");
        }
    }

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }
}

