/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc.test;

import com.google.inject.Module;
import com.yahoo.jdisc.References;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.jdisc.application.ContainerBuilder;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.service.CurrentContainer;
import com.yahoo.jdisc.test.TestDriver;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.SourceSession;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.jdisc.MbusClient;
import com.yahoo.messagebus.jdisc.MbusRequest;
import com.yahoo.messagebus.jdisc.test.RemoteServer;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.shared.SharedMessageBus;
import com.yahoo.messagebus.shared.SharedSourceSession;
import com.yahoo.messagebus.test.SimpleProtocol;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class ClientTestDriver {
    private final RemoteServer server;
    private final MbusClient client;
    private final SharedSourceSession session;
    private final TestDriver driver;

    private ClientTestDriver(RemoteServer server, Protocol protocol) {
        this.server = server;
        MessageBusParams mbusParams = new MessageBusParams().addProtocol(protocol);
        RPCNetworkParams netParams = new RPCNetworkParams().setSlobroksConfig(server.slobroksConfig());
        SharedMessageBus mbus = SharedMessageBus.newInstance(mbusParams, netParams);
        this.session = mbus.newSourceSession(new SourceSessionParams());
        this.client = new MbusClient(this.session);
        this.client.start();
        mbus.release();
        this.driver = TestDriver.newSimpleApplicationInstanceWithoutOsgi((Module[])new Module[0]);
        ContainerBuilder builder = this.driver.newContainerBuilder();
        builder.clientBindings().bind("mbus://*/*", (Object)this.client);
        this.driver.activateContainer(builder);
    }

    public SourceSession sourceSession() {
        return this.session.session();
    }

    public Request newServerRequest() {
        return new Request((CurrentContainer)this.driver, URI.create("mbus://localhost/"));
    }

    public Request newClientRequest(Message msg) {
        msg.setRoute(Route.parse((String)this.server.connectionSpec()));
        if (msg.getTrace().getLevel() == 0) {
            msg.getTrace().setLevel(9);
        }
        Request parent = this.newServerRequest();
        try (ResourceReference ref = References.fromResource((SharedResource)parent);){
            MbusRequest mbusRequest = new MbusRequest(parent, URI.create("mbus://remotehost/"), msg);
            return mbusRequest;
        }
    }

    public boolean sendRequest(Request request, ResponseHandler responseHandler) {
        request.connect(responseHandler).close(null);
        return true;
    }

    public boolean sendMessage(Message msg, ResponseHandler responseHandler) {
        Request request = this.newClientRequest(msg);
        try (ResourceReference ref = References.fromResource((SharedResource)request);){
            boolean bl = this.sendRequest(request, responseHandler);
            return bl;
        }
    }

    public Message awaitMessage() {
        Message msg = null;
        try {
            msg = this.server.awaitMessage(60, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (msg != null) {
            msg.getTrace().trace(0, "Message received by RemoteServer.");
        }
        return msg;
    }

    public void sendReply(Reply reply) {
        reply.getTrace().trace(0, "Sending reply from RemoteServer.");
        this.server.sendReply(reply);
    }

    public boolean awaitMessageAndSendReply(Reply reply) {
        Message msg = this.awaitMessage();
        if (msg == null) {
            return false;
        }
        reply.swapState((Routable)msg);
        this.sendReply(reply);
        return true;
    }

    public boolean close() {
        this.session.release();
        this.client.release();
        this.server.close();
        return this.driver.close();
    }

    public MbusClient client() {
        return this.client;
    }

    public RemoteServer server() {
        return this.server;
    }

    public static ClientTestDriver newInstance() {
        return new ClientTestDriver(RemoteServer.newInstanceWithInternSlobrok(), (Protocol)new SimpleProtocol());
    }

    public static ClientTestDriver newInstanceWithProtocol(Protocol protocol) {
        return new ClientTestDriver(RemoteServer.newInstanceWithInternSlobrok(), protocol);
    }
}

