// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.jdisc.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of session
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class SessionConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c4a43fa080185fadaac4024d698a139c";
  public final static String CONFIG_DEF_NAME = "session";
  public final static String CONFIG_DEF_NAMESPACE = "container.jdisc.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.jdisc.config",
    "name string default=\"\"",
    "type enum {INTERMEDIATE, SOURCE, INTERNAL} default=INTERMEDIATE"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String name = null;
    private Type.Enum type = null;

    public Builder() { }

    public Builder(SessionConfig config) {
      name(config.name());
      type(config.type());
    }

    private Builder override(Builder __superior) {
      if (__superior.name != null)
        name(__superior.name);
      if (__superior.type != null)
        type(__superior.type);
      return this;
    }

    public Builder name(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      name = __value;
      return this;
    }


    public Builder type(Type.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      type = __value;
      return this;
    }

    private Builder type(String __value) {
      return type(Type.Enum.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SessionConfig build() {
      return new SessionConfig(this);
    }

  }

  private final StringNode name;
  private final Type type;

  public SessionConfig(Builder builder) {
    this(builder, true);
  }

  private SessionConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "session must be initialized: " + builder.__uninitialized);

    name = (builder.name == null) ?
        new StringNode("") : new StringNode(builder.name);
    type = (builder.type == null) ?
        new Type(Type.INTERMEDIATE) : new Type(builder.type);
  }

  /**
   * @return session.name
   */
  public String name() {
    return name.value();
  }

  /**
   * @return session.type
   */
  public Type.Enum type() {
    return type.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SessionConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("session");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents session.type
   */
  public final static class Type extends EnumNode<Type.Enum> {

    public Type(){
      this.value = null;
    }

    public Type(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {INTERMEDIATE, SOURCE, INTERNAL}
    public final static Enum INTERMEDIATE = Enum.INTERMEDIATE;
    public final static Enum SOURCE = Enum.SOURCE;
    public final static Enum INTERNAL = Enum.INTERNAL;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
