// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.jdisc;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of container-mbus
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ContainerMbusConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "33e1e411ab46f3a268fb2e1b2c16ca36";
  public final static String CONFIG_DEF_NAME = "container-mbus";
  public final static String CONFIG_DEF_NAMESPACE = "container.jdisc";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.jdisc",
    "port int default=0",
    "numconnectionspertarget int default=1",
    "numthreads int default=2",
    "optimize_for enum {LATENCY, THROUGHPUT} default=LATENCY",
    "transport_events_before_wakeup int default=1",
    "maxpendingcount int default=4096",
    "maxConcurrentFactor double default=0.2 range=[0.0-1.0]",
    "documentExpansionFactor double default=80.0",
    "containerCoreMemory int default=150"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer port = null;
    private Integer numconnectionspertarget = null;
    private Integer numthreads = null;
    private Optimize_for.Enum optimize_for = null;
    private Integer transport_events_before_wakeup = null;
    private Integer maxpendingcount = null;
    private Double maxConcurrentFactor = null;
    private Double documentExpansionFactor = null;
    private Integer containerCoreMemory = null;

    public Builder() { }

    public Builder(ContainerMbusConfig config) {
      port(config.port());
      numconnectionspertarget(config.numconnectionspertarget());
      numthreads(config.numthreads());
      optimize_for(config.optimize_for());
      transport_events_before_wakeup(config.transport_events_before_wakeup());
      maxpendingcount(config.maxpendingcount());
      maxConcurrentFactor(config.maxConcurrentFactor());
      documentExpansionFactor(config.documentExpansionFactor());
      containerCoreMemory(config.containerCoreMemory());
    }

    private Builder override(Builder __superior) {
      if (__superior.port != null)
        port(__superior.port);
      if (__superior.numconnectionspertarget != null)
        numconnectionspertarget(__superior.numconnectionspertarget);
      if (__superior.numthreads != null)
        numthreads(__superior.numthreads);
      if (__superior.optimize_for != null)
        optimize_for(__superior.optimize_for);
      if (__superior.transport_events_before_wakeup != null)
        transport_events_before_wakeup(__superior.transport_events_before_wakeup);
      if (__superior.maxpendingcount != null)
        maxpendingcount(__superior.maxpendingcount);
      if (__superior.maxConcurrentFactor != null)
        maxConcurrentFactor(__superior.maxConcurrentFactor);
      if (__superior.documentExpansionFactor != null)
        documentExpansionFactor(__superior.documentExpansionFactor);
      if (__superior.containerCoreMemory != null)
        containerCoreMemory(__superior.containerCoreMemory);
      return this;
    }

    public Builder port(int __value) {
      port = __value;
      return this;
    }

    private Builder port(String __value) {
      return port(Integer.valueOf(__value));
    }

    public Builder numconnectionspertarget(int __value) {
      numconnectionspertarget = __value;
      return this;
    }

    private Builder numconnectionspertarget(String __value) {
      return numconnectionspertarget(Integer.valueOf(__value));
    }

    public Builder numthreads(int __value) {
      numthreads = __value;
      return this;
    }

    private Builder numthreads(String __value) {
      return numthreads(Integer.valueOf(__value));
    }

    public Builder optimize_for(Optimize_for.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      optimize_for = __value;
      return this;
    }

    private Builder optimize_for(String __value) {
      return optimize_for(Optimize_for.Enum.valueOf(__value));
    }

    public Builder transport_events_before_wakeup(int __value) {
      transport_events_before_wakeup = __value;
      return this;
    }

    private Builder transport_events_before_wakeup(String __value) {
      return transport_events_before_wakeup(Integer.valueOf(__value));
    }

    public Builder maxpendingcount(int __value) {
      maxpendingcount = __value;
      return this;
    }

    private Builder maxpendingcount(String __value) {
      return maxpendingcount(Integer.valueOf(__value));
    }

    public Builder maxConcurrentFactor(double __value) {
      maxConcurrentFactor = __value;
      return this;
    }

    private Builder maxConcurrentFactor(String __value) {
      return maxConcurrentFactor(Double.valueOf(__value));
    }

    public Builder documentExpansionFactor(double __value) {
      documentExpansionFactor = __value;
      return this;
    }

    private Builder documentExpansionFactor(String __value) {
      return documentExpansionFactor(Double.valueOf(__value));
    }

    public Builder containerCoreMemory(int __value) {
      containerCoreMemory = __value;
      return this;
    }

    private Builder containerCoreMemory(String __value) {
      return containerCoreMemory(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ContainerMbusConfig build() {
      return new ContainerMbusConfig(this);
    }

  }

  // settings for message bus in container
  // Which network port is used
  private final IntegerNode port;
  // Number of connections per target
  private final IntegerNode numconnectionspertarget;
  // Number network threads
  private final IntegerNode numthreads;
  // Optimize for latency, or throughput.
  private final Optimize_for optimize_for;
  // Number of events before triggering wakeup of network thread.
  private final IntegerNode transport_events_before_wakeup;
  // Everying below is deprecated and will go away very soon.
  // Dynamic throttling is used, and works better than anything else.
  private final IntegerNode maxpendingcount;
  // The amount of input data that the service can process concurrently
  private final DoubleNode maxConcurrentFactor;
  // The factor that an operation grows by in terms of temporary memory usage during deserialization and processing
  private final DoubleNode documentExpansionFactor;
  // The headroom left for the container and other stuff, i.e. heap that cannot be used for processing (megabytes)
  private final IntegerNode containerCoreMemory;

  public ContainerMbusConfig(Builder builder) {
    this(builder, true);
  }

  private ContainerMbusConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "container-mbus must be initialized: " + builder.__uninitialized);

    port = (builder.port == null) ?
        new IntegerNode(0) : new IntegerNode(builder.port);
    numconnectionspertarget = (builder.numconnectionspertarget == null) ?
        new IntegerNode(1) : new IntegerNode(builder.numconnectionspertarget);
    numthreads = (builder.numthreads == null) ?
        new IntegerNode(2) : new IntegerNode(builder.numthreads);
    optimize_for = (builder.optimize_for == null) ?
        new Optimize_for(Optimize_for.LATENCY) : new Optimize_for(builder.optimize_for);
    transport_events_before_wakeup = (builder.transport_events_before_wakeup == null) ?
        new IntegerNode(1) : new IntegerNode(builder.transport_events_before_wakeup);
    maxpendingcount = (builder.maxpendingcount == null) ?
        new IntegerNode(4096) : new IntegerNode(builder.maxpendingcount);
    maxConcurrentFactor = (builder.maxConcurrentFactor == null) ?
        new DoubleNode(0.2D) : new DoubleNode(builder.maxConcurrentFactor);
    documentExpansionFactor = (builder.documentExpansionFactor == null) ?
        new DoubleNode(80.0D) : new DoubleNode(builder.documentExpansionFactor);
    containerCoreMemory = (builder.containerCoreMemory == null) ?
        new IntegerNode(150) : new IntegerNode(builder.containerCoreMemory);
  }

  /**
   * @return container-mbus.port
   */
  public int port() {
    return port.value();
  }

  /**
   * @return container-mbus.numconnectionspertarget
   */
  public int numconnectionspertarget() {
    return numconnectionspertarget.value();
  }

  /**
   * @return container-mbus.numthreads
   */
  public int numthreads() {
    return numthreads.value();
  }

  /**
   * @return container-mbus.optimize_for
   */
  public Optimize_for.Enum optimize_for() {
    return optimize_for.value();
  }

  /**
   * @return container-mbus.transport_events_before_wakeup
   */
  public int transport_events_before_wakeup() {
    return transport_events_before_wakeup.value();
  }

  /**
   * @return container-mbus.maxpendingcount
   */
  public int maxpendingcount() {
    return maxpendingcount.value();
  }

  /**
   * @return container-mbus.maxConcurrentFactor
   */
  public double maxConcurrentFactor() {
    return maxConcurrentFactor.value();
  }

  /**
   * @return container-mbus.documentExpansionFactor
   */
  public double documentExpansionFactor() {
    return documentExpansionFactor.value();
  }

  /**
   * @return container-mbus.containerCoreMemory
   */
  public int containerCoreMemory() {
    return containerCoreMemory.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ContainerMbusConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("container-mbus");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents container-mbus.optimize_for
   * 
   * Optimize for latency, or throughput.
   */
  public final static class Optimize_for extends EnumNode<Optimize_for.Enum> {

    public Optimize_for(){
      this.value = null;
    }

    public Optimize_for(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {LATENCY, THROUGHPUT}
    public final static Enum LATENCY = Enum.LATENCY;
    public final static Enum THROUGHPUT = Enum.THROUGHPUT;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
