/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.metrics.ManagerConfig;
import com.yahoo.metrics.simple.Bucket;
import com.yahoo.metrics.simple.MetricManager;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.MetricUpdater;
import com.yahoo.metrics.simple.Sample;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class UnitTestSetup {
    MetricManager metricManager;
    MetricReceiver receiver;
    ObservableUpdater updater;

    void init() {
        this.updater = new ObservableUpdater();
        this.metricManager = MetricManager.constructWithCustomUpdater(new ManagerConfig(new ManagerConfig.Builder()), this.updater);
        this.receiver = this.metricManager.get();
    }

    void fini() {
        this.receiver = null;
        this.metricManager.deconstruct();
        this.metricManager = null;
        this.updater = null;
    }

    public Bucket getUpdatedSnapshot() throws InterruptedException {
        this.updater.gotData.await(10L, TimeUnit.SECONDS);
        Bucket s = this.receiver.getSnapshot();
        long startedWaitingForSnapshot = System.currentTimeMillis();
        while (s == null || s.entrySet().size() == 0) {
            if (System.currentTimeMillis() - startedWaitingForSnapshot > 10000L) {
                throw new RuntimeException("Test timed out.");
            }
            Thread.sleep(10L);
            s = this.receiver.getSnapshot();
        }
        return s;
    }

    public MetricReceiver getReceiver() {
        return this.receiver;
    }

    static class ObservableUpdater
    extends MetricUpdater {
        CountDownLatch gotData = new CountDownLatch(1);
        private volatile boolean hasBeenAccessed = false;

        ObservableUpdater() {
        }

        @Override
        public Bucket createGenerationInstance(Bucket previous) {
            if (this.hasBeenAccessed) {
                this.gotData.countDown();
            }
            return super.createGenerationInstance(previous);
        }

        @Override
        public Bucket update(Bucket current, Sample x) {
            this.hasBeenAccessed = true;
            return super.update(current, x);
        }
    }
}

