/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.SslProvider;
import com.yahoo.jdisc.http.ssl.impl.TlsContextBasedProvider;
import com.yahoo.security.tls.ConfigFileBasedTlsContext;
import com.yahoo.security.tls.PeerAuthentication;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.nio.file.Path;

public class DefaultSslContextFactoryProvider
extends AbstractComponent
implements SslProvider {
    private final SslProvider instance = TransportSecurityUtils.getConfigFile().map(configFile -> DefaultSslContextFactoryProvider.createTlsContextBasedProvider(connectorConfig, configFile)).orElseGet(ThrowingSslContextFactoryProvider::new);

    @Inject
    public DefaultSslContextFactoryProvider(ConnectorConfig connectorConfig) {
    }

    private static SslProvider createTlsContextBasedProvider(ConnectorConfig connectorConfig, Path configFile) {
        return new StaticTlsContextBasedProvider((TlsContext)new ConfigFileBasedTlsContext(configFile, TransportSecurityUtils.getInsecureAuthorizationMode(), DefaultSslContextFactoryProvider.getPeerAuthenticationMode(connectorConfig)));
    }

    private static PeerAuthentication getPeerAuthenticationMode(ConnectorConfig connectorConfig) {
        return connectorConfig.tlsClientAuthEnforcer().enable() ? PeerAuthentication.WANT : PeerAuthentication.NEED;
    }

    @Override
    public void configureSsl(SslProvider.ConnectorSsl ssl, String name, int port) {
        this.instance.configureSsl(ssl, name, port);
    }

    public void deconstruct() {
        this.instance.close();
    }

    private static class StaticTlsContextBasedProvider
    extends TlsContextBasedProvider {
        final TlsContext tlsContext;

        StaticTlsContextBasedProvider(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
        }

        @Override
        protected TlsContext getTlsContext(String containerId, int port) {
            return this.tlsContext;
        }

        public void deconstruct() {
            this.tlsContext.close();
        }
    }

    private static class ThrowingSslContextFactoryProvider
    implements SslProvider {
        private ThrowingSslContextFactoryProvider() {
        }

        @Override
        public void configureSsl(SslProvider.ConnectorSsl ssl, String name, int port) {
            throw new UnsupportedOperationException();
        }
    }
}

