/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.yahoo.component.AbstractComponent;
import com.yahoo.container.core.AccessLogConfig;
import com.yahoo.container.logging.AccessLogHandler;
import com.yahoo.container.logging.HitCounts;
import com.yahoo.container.logging.LogWriter;
import com.yahoo.container.logging.RequestLogEntry;
import com.yahoo.container.logging.RequestLogHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class VespaAccessLog
extends AbstractComponent
implements RequestLogHandler,
LogWriter<RequestLogEntry> {
    private static final ThreadLocal<SimpleDateFormat> dateFormat = ThreadLocal.withInitial(VespaAccessLog::createDateFormat);
    private final AccessLogHandler logHandler;

    public VespaAccessLog(AccessLogConfig config) {
        this.logHandler = new AccessLogHandler(config.fileHandler(), this);
    }

    private static SimpleDateFormat createDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss Z]");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    private static String getDate() {
        return dateFormat.get().format(new Date());
    }

    private String getRequest(String httpMethod, String rawPath, String rawQuery, String httpVersion) {
        return httpMethod + " " + (String)(rawQuery != null ? rawPath + "?" + rawQuery : rawPath) + " " + httpVersion;
    }

    private String getUser(String user) {
        return user == null ? "-" : user;
    }

    private String toLogline(String ipAddr, String user, String request, String referer, String agent, long durationMillis, long byteCount, HitCounts hitcounts, int returnCode) {
        long ms = Math.max(0L, durationMillis);
        StringBuilder sb = new StringBuilder().append(ipAddr).append(" - ").append(this.getUser(user)).append(' ').append(VespaAccessLog.getDate()).append(" \"").append(request).append("\" ").append(returnCode).append(' ').append(byteCount).append(" \"").append(referer).append("\" \"").append(agent).append("\" ").append(ms / 1000L).append('.');
        this.decimalsOfSecondsFromMilliseconds(ms, sb);
        sb.append(' ').append(hitcounts == null ? 0L : hitcounts.getTotalHitCount()).append(" 0.0 ").append(hitcounts == null ? 0 : hitcounts.getSummaryCount());
        return sb.toString();
    }

    private void decimalsOfSecondsFromMilliseconds(long ms, StringBuilder sb) {
        long dec = ms % 1000L;
        String numbers = String.valueOf(dec);
        if (dec <= 9L) {
            sb.append("00");
        } else if (dec <= 99L) {
            sb.append('0');
        }
        sb.append(numbers);
    }

    public void deconstruct() {
        this.logHandler.shutdown();
    }

    @Override
    public void log(RequestLogEntry entry) {
        this.logHandler.log(entry);
    }

    @Override
    public void write(RequestLogEntry entry, OutputStream outputStream) throws IOException {
        outputStream.write(this.toLogline(entry.peerAddress().get(), null, this.getRequest(entry.httpMethod().orElse(null), entry.rawPath().orElse(null), entry.rawQuery().orElse(null), entry.httpVersion().orElse(null)), entry.referer().orElse(null), entry.userAgent().orElse(null), entry.duration().get().toMillis(), entry.responseSize().orElse(0L), entry.hitCounts().orElse(null), entry.statusCode().orElse(0)).getBytes(StandardCharsets.UTF_8));
    }
}

