/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.yahoo.container.jdisc.state.CountMetric;
import com.yahoo.container.jdisc.state.GaugeMetric;
import com.yahoo.container.jdisc.state.MetricValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class MetricSet
implements Iterable<Map.Entry<String, MetricValue>> {
    private static final Logger log = Logger.getLogger(MetricSet.class.getName());
    private final Map<String, MetricValue> data;

    MetricSet() {
        this.data = new HashMap<String, MetricValue>();
    }

    public MetricSet(Map<String, MetricValue> data) {
        this.data = data;
    }

    @Override
    public Iterator<Map.Entry<String, MetricValue>> iterator() {
        return this.data.entrySet().iterator();
    }

    public MetricValue get(String key) {
        return this.data.get(key);
    }

    void add(String key, Number val) {
        this.add(key, CountMetric.newSingleValue(val));
    }

    void set(String key, Number val) {
        this.add(key, GaugeMetric.newSingleValue(val));
    }

    void add(MetricSet metricSet) {
        for (Map.Entry<String, MetricValue> entry : metricSet) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    private void add(String key, MetricValue value) {
        MetricValue existingValue = this.data.get(key);
        if (existingValue == null) {
            this.data.put(key, value);
            return;
        }
        if (!existingValue.getClass().isAssignableFrom(value.getClass())) {
            log.info("Resetting metric '" + key + "' as it changed type. If you see this outside of deployment changes it means you incorrectly call both set() and add() on the same metric");
            this.data.put(key, value);
            return;
        }
        existingValue.add(value);
    }

    boolean isEmpty() {
        return this.data.isEmpty();
    }

    public MetricSet partialClone() {
        return new MetricSet(this.data.entrySet().stream().filter(kv -> kv.getValue() instanceof GaugeMetric).collect(Collectors.toMap(kv -> (String)kv.getKey(), kv -> ((GaugeMetric)kv.getValue()).newWithPreservedLastValue())));
    }
}

