// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of components
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ComponentsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "8acfd530c0587f3a7748f840bb262ae0";
  public final static String CONFIG_DEF_NAME = "components";
  public final static String CONFIG_DEF_NAMESPACE = "container";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container",
    "components[].id string",
    "components[].configId reference default=\":parent:\"",
    "components[].classId string default=\"\"",
    "components[].bundle string default=\"\"",
    "components[].inject[].id string",
    "components[].inject[].name string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Components.Builder> components = new ArrayList<>();

    public Builder() { }

    public Builder(ComponentsConfig config) {
      for (Components c : config.components()) {
        components(new Components.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.components.isEmpty())
        components.addAll(__superior.components);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Components builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder components(Components.Builder __builder) {
      components.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder components(java.util.function.Consumer<Components.Builder> __func) {
      Components.Builder __inner = new Components.Builder();
      __func.accept(__inner);
      components.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Components builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder components(List<Components.Builder> __builders) {
      components = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ComponentsConfig build() {
      return new ComponentsConfig(this);
    }

  }

  private final InnerNodeVector<Components> components;

  public ComponentsConfig(Builder builder) {
    this(builder, true);
  }

  private ComponentsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "components must be initialized: " + builder.__uninitialized);

    components = Components.createVector(builder.components);
  }

  /**
   * @return components.components[]
   */
  public List<Components> components() {
    return components;
  }

  /**
   * @param i the index of the value to return
   * @return components.components[]
   */
  public Components components(int i) {
    return components.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ComponentsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("components");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents components.components[]
   */
  public final static class Components extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id"
        ));

      private String id = null;
      private String configId = null;
      private String classId = null;
      private String bundle = null;
      public List<Inject.Builder> inject = new ArrayList<>();

      public Builder() { }

      public Builder(Components config) {
        id(config.id());
        configId(config.configId());
        classId(config.classId());
        bundle(config.bundle());
        for (Inject i : config.inject()) {
          inject(new Inject.Builder(i));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.configId != null)
          configId(__superior.configId);
        if (__superior.classId != null)
          classId(__superior.classId);
        if (__superior.bundle != null)
          bundle(__superior.bundle);
        if (!__superior.inject.isEmpty())
          inject.addAll(__superior.inject);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder configId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        configId = __value;
        return this;
      }


      public Builder classId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        classId = __value;
        return this;
      }


      public Builder bundle(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        bundle = __value;
        return this;
      }


      /**
       * Add the given builder to this builder's list of Inject builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder inject(Inject.Builder __builder) {
        inject.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder inject(java.util.function.Consumer<Inject.Builder> __func) {
        Inject.Builder __inner = new Inject.Builder();
        __func.accept(__inner);
        inject.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Inject builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder inject(List<Inject.Builder> __builders) {
        inject = __builders;
        return this;
      }

      public Components build() {
        return new Components(this);
      }

    }

    // A list of components. Components depending on other components may use this to
    // get its list of components injected.
    // A component
    private final StringNode id;
    // The component id used by this component to subscribe to its configs (if any)
    private final ReferenceNode configId;
    // The id of the class to instantiate for this component.
    private final StringNode classId;
    // The symbolic name of the Osgi bundle this component is located in.
    // Assumed to be the same as the classid if not set.
    private final StringNode bundle;
    private final InnerNodeVector<Inject> inject;

    public Components(Builder builder) {
      this(builder, true);
    }

    private Components(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "components.components[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      configId = (builder.configId == null) ?
          new ReferenceNode(":parent:") : new ReferenceNode(builder.configId);
      classId = (builder.classId == null) ?
          new StringNode("") : new StringNode(builder.classId);
      bundle = (builder.bundle == null) ?
          new StringNode("") : new StringNode(builder.bundle);
      inject = Inject.createVector(builder.inject);
    }

    /**
     * @return components.components[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return components.components[].configId
     */
    public String configId() {
      return configId.value();
    }

    /**
     * @return components.components[].classId
     */
    public String classId() {
      return classId.value();
    }

    /**
     * @return components.components[].bundle
     */
    public String bundle() {
      return bundle.value();
    }

    /**
     * @return components.components[].inject[]
     */
    public List<Inject> inject() {
      return inject;
    }

    /**
     * @param i the index of the value to return
     * @return components.components[].inject[]
     */
    public Inject inject(int i) {
      return inject.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Components newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("components");
      return changes;
    }

    private static InnerNodeVector<Components> createVector(List<Builder> builders) {
        List<Components> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Components(b));
        }
        return new InnerNodeVector<Components>(elems);
    }

    /**
     * This class represents components.components[].inject[]
     */
    public final static class Inject extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "id"
          ));

        private String id = null;
        private String name = null;

        public Builder() { }

        public Builder(Inject config) {
          id(config.id());
          name(config.name());
        }

        private Builder override(Builder __superior) {
          if (__superior.id != null)
            id(__superior.id);
          if (__superior.name != null)
            name(__superior.name);
          return this;
        }

        public Builder id(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          id = __value;
          __uninitialized.remove("id");
          return this;
        }


        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          return this;
        }


        public Inject build() {
          return new Inject(this);
        }

      }

      // The component id of the component to inject to this component
      private final StringNode id;
      // The name to use for the injected component when injected to this component
      private final StringNode name;

      public Inject(Builder builder) {
        this(builder, true);
      }

      private Inject(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "components.components[].inject[] must be initialized: " + builder.__uninitialized);

        id = (builder.id == null) ?
            new StringNode() : new StringNode(builder.id);
        name = (builder.name == null) ?
            new StringNode("") : new StringNode(builder.name);
      }

      /**
       * @return components.components[].inject[].id
       */
      public String id() {
        return id.value();
      }

      /**
       * @return components.components[].inject[].name
       */
      public String name() {
        return name.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Inject newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("inject");
        return changes;
      }

      private static InnerNodeVector<Inject> createVector(List<Builder> builders) {
          List<Inject> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Inject(b));
          }
          return new InnerNodeVector<Inject>(elems);
      }
    }
  }

}
