/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty.testutils;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.ConnectorFactory;
import com.yahoo.jdisc.http.ssl.impl.ConfiguredSslContextFactoryProvider;

public class ConnectorFactoryRegistryModule
implements Module {
    private final ConnectorConfig config;

    public ConnectorFactoryRegistryModule(ConnectorConfig config) {
        this.config = config;
    }

    public ConnectorFactoryRegistryModule() {
        this(new ConnectorConfig(new ConnectorConfig.Builder()));
    }

    @Provides
    public ComponentRegistry<ConnectorFactory> connectorFactoryComponentRegistry() {
        ComponentRegistry registry = new ComponentRegistry();
        registry.register(ComponentId.createAnonymousComponentId((String)"connector-factory"), (Object)new StaticKeyDbConnectorFactory(this.config));
        registry.freeze();
        return registry;
    }

    public void configure(Binder binder) {
    }

    private static class StaticKeyDbConnectorFactory
    extends ConnectorFactory {
        public StaticKeyDbConnectorFactory(ConnectorConfig connectorConfig) {
            super(connectorConfig, new ConfiguredSslContextFactoryProvider(connectorConfig));
        }
    }
}

