// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.jdisc.state;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of metrics-packets-handler
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class MetricsPacketsHandlerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "95f7684d1e846a385498a0b101236654";
  public final static String CONFIG_DEF_NAME = "metrics-packets-handler";
  public final static String CONFIG_DEF_NAMESPACE = "container.jdisc.state";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.jdisc.state",
    "application string",
    "hostname string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "application"
      ));

    private String application = null;
    private String hostname = null;

    public Builder() { }

    public Builder(MetricsPacketsHandlerConfig config) {
      application(config.application());
      hostname(config.hostname());
    }

    private Builder override(Builder __superior) {
      if (__superior.application != null)
        application(__superior.application);
      if (__superior.hostname != null)
        hostname(__superior.hostname);
      return this;
    }

    public Builder application(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      application = __value;
      __uninitialized.remove("application");
      return this;
    }


    public Builder hostname(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      hostname = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public MetricsPacketsHandlerConfig build() {
      return new MetricsPacketsHandlerConfig(this);
    }

  }

  // The name of the application that is reporting metrics.
  private final StringNode application;
  // Optional hostname to add as dimension
  private final StringNode hostname;

  public MetricsPacketsHandlerConfig(Builder builder) {
    this(builder, true);
  }

  private MetricsPacketsHandlerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "metrics-packets-handler must be initialized: " + builder.__uninitialized);

    application = (builder.application == null) ?
        new StringNode() : new StringNode(builder.application);
    hostname = (builder.hostname == null) ?
        new StringNode("") : new StringNode(builder.hostname);
  }

  /**
   * @return metrics-packets-handler.application
   */
  public String application() {
    return application.value();
  }

  /**
   * @return metrics-packets-handler.hostname
   */
  public String hostname() {
    return hostname.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(MetricsPacketsHandlerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("metrics-packets-handler");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
