// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.handler.metrics;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of metrics-proxy-api
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class MetricsProxyApiConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "6d2727803e8592184031a6601b96f7c2";
  public final static String CONFIG_DEF_NAME = "metrics-proxy-api";
  public final static String CONFIG_DEF_NAMESPACE = "container.handler.metrics";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.handler.metrics",
    "metricsPort int",
    "metricsApiPath string",
    "prometheusApiPath string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "metricsPort",
      "metricsApiPath",
      "prometheusApiPath"
      ));

    private Integer metricsPort = null;
    private String metricsApiPath = null;
    private String prometheusApiPath = null;

    public Builder() { }

    public Builder(MetricsProxyApiConfig config) {
      metricsPort(config.metricsPort());
      metricsApiPath(config.metricsApiPath());
      prometheusApiPath(config.prometheusApiPath());
    }

    private Builder override(Builder __superior) {
      if (__superior.metricsPort != null)
        metricsPort(__superior.metricsPort);
      if (__superior.metricsApiPath != null)
        metricsApiPath(__superior.metricsApiPath);
      if (__superior.prometheusApiPath != null)
        prometheusApiPath(__superior.prometheusApiPath);
      return this;
    }

    public Builder metricsPort(int __value) {
      metricsPort = __value;
      __uninitialized.remove("metricsPort");
      return this;
    }

    private Builder metricsPort(String __value) {
      return metricsPort(Integer.valueOf(__value));
    }

    public Builder metricsApiPath(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      metricsApiPath = __value;
      __uninitialized.remove("metricsApiPath");
      return this;
    }


    public Builder prometheusApiPath(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      prometheusApiPath = __value;
      __uninitialized.remove("prometheusApiPath");
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public MetricsProxyApiConfig build() {
      return new MetricsProxyApiConfig(this);
    }

  }

  private final IntegerNode metricsPort;
  private final StringNode metricsApiPath;
  private final StringNode prometheusApiPath;

  public MetricsProxyApiConfig(Builder builder) {
    this(builder, true);
  }

  private MetricsProxyApiConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "metrics-proxy-api must be initialized: " + builder.__uninitialized);

    metricsPort = (builder.metricsPort == null) ?
        new IntegerNode() : new IntegerNode(builder.metricsPort);
    metricsApiPath = (builder.metricsApiPath == null) ?
        new StringNode() : new StringNode(builder.metricsApiPath);
    prometheusApiPath = (builder.prometheusApiPath == null) ?
        new StringNode() : new StringNode(builder.prometheusApiPath);
  }

  /**
   * @return metrics-proxy-api.metricsPort
   */
  public int metricsPort() {
    return metricsPort.value();
  }

  /**
   * @return metrics-proxy-api.metricsApiPath
   */
  public String metricsApiPath() {
    return metricsApiPath.value();
  }

  /**
   * @return metrics-proxy-api.prometheusApiPath
   */
  public String prometheusApiPath() {
    return prometheusApiPath.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(MetricsProxyApiConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("metrics-proxy-api");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
