// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of access-log
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class AccessLogConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "947dab75f6463375c2a8ad7f77c42db2";
  public final static String CONFIG_DEF_NAME = "access-log";
  public final static String CONFIG_DEF_NAMESPACE = "container.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.core",
    "fileHandler.pattern string",
    "fileHandler.rotation string default=\"0 60 ...\"",
    "fileHandler.symlink string default=\"\"",
    "fileHandler.compressOnRotation bool default=true",
    "fileHandler.compressionFormat enum {GZIP, ZSTD} default=ZSTD",
    "fileHandler.queueSize int default=10000",
    "fileHandler.bufferSize int default=262144",
    "fileHandler.rotationSize long default=0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public FileHandler.Builder fileHandler = new FileHandler.Builder();

    public Builder() { }

    public Builder(AccessLogConfig config) {
      fileHandler(new FileHandler.Builder(config.fileHandler()));
    }

    private Builder override(Builder __superior) {
      fileHandler(fileHandler.override(__superior.fileHandler));
      return this;
    }

    public Builder fileHandler(FileHandler.Builder __builder) {
      fileHandler = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder fileHandler(java.util.function.Consumer<FileHandler.Builder> __func) {
      FileHandler.Builder __inner = new FileHandler.Builder();
      __func.accept(__inner);
      fileHandler = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public AccessLogConfig build() {
      return new AccessLogConfig(this);
    }

  }

  private final FileHandler fileHandler;

  public AccessLogConfig(Builder builder) {
    this(builder, true);
  }

  private AccessLogConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "access-log must be initialized: " + builder.__uninitialized);

    fileHandler = new FileHandler(builder.fileHandler, throwIfUninitialized);
  }

  /**
   * @return access-log.fileHandler
   */
  public FileHandler fileHandler() {
    return fileHandler;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(AccessLogConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("access-log");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents access-log.fileHandler
   */
  public final static class FileHandler extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "pattern"
        ));

      private String pattern = null;
      private String rotation = null;
      private String symlink = null;
      private Boolean compressOnRotation = null;
      private CompressionFormat.Enum compressionFormat = null;
      private Integer queueSize = null;
      private Integer bufferSize = null;
      private Long rotationSize = null;

      public Builder() { }

      public Builder(FileHandler config) {
        pattern(config.pattern());
        rotation(config.rotation());
        symlink(config.symlink());
        compressOnRotation(config.compressOnRotation());
        compressionFormat(config.compressionFormat());
        queueSize(config.queueSize());
        bufferSize(config.bufferSize());
        rotationSize(config.rotationSize());
      }

      private Builder override(Builder __superior) {
        if (__superior.pattern != null)
          pattern(__superior.pattern);
        if (__superior.rotation != null)
          rotation(__superior.rotation);
        if (__superior.symlink != null)
          symlink(__superior.symlink);
        if (__superior.compressOnRotation != null)
          compressOnRotation(__superior.compressOnRotation);
        if (__superior.compressionFormat != null)
          compressionFormat(__superior.compressionFormat);
        if (__superior.queueSize != null)
          queueSize(__superior.queueSize);
        if (__superior.bufferSize != null)
          bufferSize(__superior.bufferSize);
        if (__superior.rotationSize != null)
          rotationSize(__superior.rotationSize);
        return this;
      }

      public Builder pattern(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        pattern = __value;
        __uninitialized.remove("pattern");
        return this;
      }


      public Builder rotation(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        rotation = __value;
        return this;
      }


      public Builder symlink(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        symlink = __value;
        return this;
      }


      public Builder compressOnRotation(boolean __value) {
        compressOnRotation = __value;
        return this;
      }

      private Builder compressOnRotation(String __value) {
        return compressOnRotation(Boolean.valueOf(__value));
      }

      public Builder compressionFormat(CompressionFormat.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        compressionFormat = __value;
        return this;
      }

      private Builder compressionFormat(String __value) {
        return compressionFormat(CompressionFormat.Enum.valueOf(__value));
      }

      public Builder queueSize(int __value) {
        queueSize = __value;
        return this;
      }

      private Builder queueSize(String __value) {
        return queueSize(Integer.valueOf(__value));
      }

      public Builder bufferSize(int __value) {
        bufferSize = __value;
        return this;
      }

      private Builder bufferSize(String __value) {
        return bufferSize(Integer.valueOf(__value));
      }

      public Builder rotationSize(long __value) {
        rotationSize = __value;
        return this;
      }

      private Builder rotationSize(String __value) {
        return rotationSize(Long.valueOf(__value));
      }

      public FileHandler build() {
        return new FileHandler(this);
      }

    }

    // File name patterns supporting the expected time variables, e.g. ".%Y%m%d%H%M%S"
    private final StringNode pattern;
    // When should rotation happen, in minutes after midnight
    // Does this really need to be configurable?
    // Could just configure "every N minutes" instead
    private final StringNode rotation;
    // Use this as the name of the symlink created pointing to the newest file in the "date" naming scheme.
    // This is ignored if the sequence naming scheme is used.
    private final StringNode symlink;
    // compress the previous access log after rotation
    private final BooleanNode compressOnRotation;
    // Compression format
    private final CompressionFormat compressionFormat;
    // Max queue length of file handler
    private final IntegerNode queueSize;
    // Buffer size for the output stream has a default of 256k
    private final IntegerNode bufferSize;
    // Maximum file size (in bytes) before rotation. 0 means disabled (only time-based rotation)
    private final LongNode rotationSize;

    public FileHandler(Builder builder) {
      this(builder, true);
    }

    private FileHandler(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "access-log.fileHandler must be initialized: " + builder.__uninitialized);

      pattern = (builder.pattern == null) ?
          new StringNode() : new StringNode(builder.pattern);
      rotation = (builder.rotation == null) ?
          new StringNode("0 60 ...") : new StringNode(builder.rotation);
      symlink = (builder.symlink == null) ?
          new StringNode("") : new StringNode(builder.symlink);
      compressOnRotation = (builder.compressOnRotation == null) ?
          new BooleanNode(true) : new BooleanNode(builder.compressOnRotation);
      compressionFormat = (builder.compressionFormat == null) ?
          new CompressionFormat(CompressionFormat.ZSTD) : new CompressionFormat(builder.compressionFormat);
      queueSize = (builder.queueSize == null) ?
          new IntegerNode(10000) : new IntegerNode(builder.queueSize);
      bufferSize = (builder.bufferSize == null) ?
          new IntegerNode(262144) : new IntegerNode(builder.bufferSize);
      rotationSize = (builder.rotationSize == null) ?
          new LongNode(0L) : new LongNode(builder.rotationSize);
    }

    /**
     * @return access-log.fileHandler.pattern
     */
    public String pattern() {
      return pattern.value();
    }

    /**
     * @return access-log.fileHandler.rotation
     */
    public String rotation() {
      return rotation.value();
    }

    /**
     * @return access-log.fileHandler.symlink
     */
    public String symlink() {
      return symlink.value();
    }

    /**
     * @return access-log.fileHandler.compressOnRotation
     */
    public boolean compressOnRotation() {
      return compressOnRotation.value();
    }

    /**
     * @return access-log.fileHandler.compressionFormat
     */
    public CompressionFormat.Enum compressionFormat() {
      return compressionFormat.value();
    }

    /**
     * @return access-log.fileHandler.queueSize
     */
    public int queueSize() {
      return queueSize.value();
    }

    /**
     * @return access-log.fileHandler.bufferSize
     */
    public int bufferSize() {
      return bufferSize.value();
    }

    /**
     * @return access-log.fileHandler.rotationSize
     */
    public long rotationSize() {
      return rotationSize.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(FileHandler newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("fileHandler");
      return changes;
    }

    /**
     * This class represents access-log.fileHandler.compressionFormat
     * 
     * Compression format
     */
    public final static class CompressionFormat extends EnumNode<CompressionFormat.Enum> {

      public CompressionFormat(){
        this.value = null;
      }

      public CompressionFormat(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {GZIP, ZSTD}
      public final static Enum GZIP = Enum.GZIP;
      public final static Enum ZSTD = Enum.ZSTD;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

}
