// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of qr-searchers
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class QrSearchersConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "b4495380ba09c8e1e7099ff79c0eded6";
  public final static String CONFIG_DEF_NAME = "qr-searchers";
  public final static String CONFIG_DEF_NAMESPACE = "container";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container",
    "tag.bold.open string default=\"<hi>\"",
    "tag.bold.close string default=\"</hi>\"",
    "tag.separator string default=\"<sep />\"",
    "com.yahoo.prelude.searcher.FieldCollapsingSearcher.collapsesize int default=1",
    "com.yahoo.prelude.searcher.FieldCollapsingSearcher.extrafactor double default=2.0",
    "com.yahoo.prelude.searcher.FieldCollapsingSearcher.collapsefield string default=\"mid\"",
    "com.yahoo.prelude.searcher.BlendingSearcher.numthreads int default=200",
    "com.yahoo.prelude.searcher.BlendingSearcher.docid string default=\"\"",
    "com.yahoo.prelude.searcher.JuniperSearcher.source string default=\"\"",
    "com.yahoo.prelude.searcher.JuniperSearcher.defaultdoctype string default=\"\"",
    "com.yahoo.prelude.searcher.XMLStringSearcher.source string default=\"\"",
    "com.yahoo.prelude.querytransform.PhrasingSearcher.automatonfile string default=\"\"",
    "com.yahoo.prelude.querytransform.NonPhrasingSearcher.automatonfile string default=\"\"",
    "com.yahoo.prelude.querytransform.TermReplacingSearcher.termlist[] string",
    "com.yahoo.prelude.querytransform.CompleteBoostSearcher.source string default=\"\"",
    "com.yahoo.prelude.querytransform.ExactStringSearcher.source string default=\"\"",
    "com.yahoo.prelude.querytransform.LiteralBoostSearcher.source string default=\"\"",
    "com.yahoo.prelude.querytransform.TermBoostSearcher.source string default=\"\"",
    "com.yahoo.prelude.querytransform.NormalizingSearcher.source string default=\"\"",
    "com.yahoo.prelude.querytransform.StemmingSearcher.source string default=\"\"",
    "com.yahoo.prelude.statistics.StatisticsSearcher.latencybucketsize int default=30",
    "customizedsearchers.rawquery[] string",
    "customizedsearchers.transformedquery[] string",
    "customizedsearchers.blendedresult[] string",
    "customizedsearchers.unblendedresult[] string",
    "customizedsearchers.backend[] string",
    "customizedsearchers.argument[].key string",
    "customizedsearchers.argument[].value string",
    "external[].name string",
    "external[].searcher[] string",
    "searchcluster[].name string",
    "searchcluster[].searchdef[] string",
    "searchcluster[].rankprofiles_configid string default=\"\"",
    "searchcluster[].indexingmode enum { REALTIME, STREAMING } default=REALTIME",
    "searchcluster[].storagecluster.routespec string default=\"\"",
    "parserSettings.keepImplicitAnds bool default=true",
    "parserSettings.markSegmentAnds bool default=false",
    "parserSettings.keepSegmentAnds bool default=false",
    "parserSettings.keepIdeographicPunctuation bool default=false",
    "sendProtobufQuerytree bool default=false"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Tag.Builder tag = new Tag.Builder();
    public Com.Builder com = new Com.Builder();
    public Customizedsearchers.Builder customizedsearchers = new Customizedsearchers.Builder();
    public List<External.Builder> external = new ArrayList<>();
    public List<Searchcluster.Builder> searchcluster = new ArrayList<>();
    public ParserSettings.Builder parserSettings = new ParserSettings.Builder();
    private Boolean sendProtobufQuerytree = null;

    public Builder() { }

    public Builder(QrSearchersConfig config) {
      tag(new Tag.Builder(config.tag()));
      com(new Com.Builder(config.com()));
      customizedsearchers(new Customizedsearchers.Builder(config.customizedsearchers()));
      for (External e : config.external()) {
        external(new External.Builder(e));
      }
      for (Searchcluster s : config.searchcluster()) {
        searchcluster(new Searchcluster.Builder(s));
      }
      parserSettings(new ParserSettings.Builder(config.parserSettings()));
      sendProtobufQuerytree(config.sendProtobufQuerytree());
    }

    private Builder override(Builder __superior) {
      tag(tag.override(__superior.tag));
      com(com.override(__superior.com));
      customizedsearchers(customizedsearchers.override(__superior.customizedsearchers));
      if (!__superior.external.isEmpty())
        external.addAll(__superior.external);
      if (!__superior.searchcluster.isEmpty())
        searchcluster.addAll(__superior.searchcluster);
      parserSettings(parserSettings.override(__superior.parserSettings));
      if (__superior.sendProtobufQuerytree != null)
        sendProtobufQuerytree(__superior.sendProtobufQuerytree);
      return this;
    }

    public Builder tag(Tag.Builder __builder) {
      tag = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder tag(java.util.function.Consumer<Tag.Builder> __func) {
      Tag.Builder __inner = new Tag.Builder();
      __func.accept(__inner);
      tag = __inner;
      return this;
    }

    public Builder com(Com.Builder __builder) {
      com = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder com(java.util.function.Consumer<Com.Builder> __func) {
      Com.Builder __inner = new Com.Builder();
      __func.accept(__inner);
      com = __inner;
      return this;
    }

    public Builder customizedsearchers(Customizedsearchers.Builder __builder) {
      customizedsearchers = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder customizedsearchers(java.util.function.Consumer<Customizedsearchers.Builder> __func) {
      Customizedsearchers.Builder __inner = new Customizedsearchers.Builder();
      __func.accept(__inner);
      customizedsearchers = __inner;
      return this;
    }

    /**
     * Add the given builder to this builder's list of External builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder external(External.Builder __builder) {
      external.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder external(java.util.function.Consumer<External.Builder> __func) {
      External.Builder __inner = new External.Builder();
      __func.accept(__inner);
      external.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of External builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder external(List<External.Builder> __builders) {
      external = __builders;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Searchcluster builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder searchcluster(Searchcluster.Builder __builder) {
      searchcluster.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder searchcluster(java.util.function.Consumer<Searchcluster.Builder> __func) {
      Searchcluster.Builder __inner = new Searchcluster.Builder();
      __func.accept(__inner);
      searchcluster.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Searchcluster builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder searchcluster(List<Searchcluster.Builder> __builders) {
      searchcluster = __builders;
      return this;
    }

    public Builder parserSettings(ParserSettings.Builder __builder) {
      parserSettings = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder parserSettings(java.util.function.Consumer<ParserSettings.Builder> __func) {
      ParserSettings.Builder __inner = new ParserSettings.Builder();
      __func.accept(__inner);
      parserSettings = __inner;
      return this;
    }

    public Builder sendProtobufQuerytree(boolean __value) {
      sendProtobufQuerytree = __value;
      return this;
    }

    private Builder sendProtobufQuerytree(String __value) {
      return sendProtobufQuerytree(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public QrSearchersConfig build() {
      return new QrSearchersConfig(this);
    }

  }

  private final Tag tag;
  private final Com com;
  private final Customizedsearchers customizedsearchers;
  private final InnerNodeVector<External> external;
  private final InnerNodeVector<Searchcluster> searchcluster;
  private final ParserSettings parserSettings;
  // send query tree as protobuf in addition to legacy format
  private final BooleanNode sendProtobufQuerytree;

  public QrSearchersConfig(Builder builder) {
    this(builder, true);
  }

  private QrSearchersConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "qr-searchers must be initialized: " + builder.__uninitialized);

    tag = new Tag(builder.tag, throwIfUninitialized);
    com = new Com(builder.com, throwIfUninitialized);
    customizedsearchers = new Customizedsearchers(builder.customizedsearchers, throwIfUninitialized);
    external = External.createVector(builder.external);
    searchcluster = Searchcluster.createVector(builder.searchcluster);
    parserSettings = new ParserSettings(builder.parserSettings, throwIfUninitialized);
    sendProtobufQuerytree = (builder.sendProtobufQuerytree == null) ?
        new BooleanNode(false) : new BooleanNode(builder.sendProtobufQuerytree);
  }

  /**
   * @return qr-searchers.tag
   */
  public Tag tag() {
    return tag;
  }

  /**
   * @return qr-searchers.com
   */
  public Com com() {
    return com;
  }

  /**
   * @return qr-searchers.customizedsearchers
   */
  public Customizedsearchers customizedsearchers() {
    return customizedsearchers;
  }

  /**
   * @return qr-searchers.external[]
   */
  public List<External> external() {
    return external;
  }

  /**
   * @param i the index of the value to return
   * @return qr-searchers.external[]
   */
  public External external(int i) {
    return external.get(i);
  }

  /**
   * @return qr-searchers.searchcluster[]
   */
  public List<Searchcluster> searchcluster() {
    return searchcluster;
  }

  /**
   * @param i the index of the value to return
   * @return qr-searchers.searchcluster[]
   */
  public Searchcluster searchcluster(int i) {
    return searchcluster.get(i);
  }

  /**
   * @return qr-searchers.parserSettings
   */
  public ParserSettings parserSettings() {
    return parserSettings;
  }

  /**
   * @return qr-searchers.sendProtobufQuerytree
   */
  public boolean sendProtobufQuerytree() {
    return sendProtobufQuerytree.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(QrSearchersConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("qr-searchers");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents qr-searchers.tag
   */
  public final static class Tag extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Bold.Builder bold = new Bold.Builder();
      private String separator = null;

      public Builder() { }

      public Builder(Tag config) {
        bold(new Bold.Builder(config.bold()));
        separator(config.separator());
      }

      private Builder override(Builder __superior) {
        bold(bold.override(__superior.bold));
        if (__superior.separator != null)
          separator(__superior.separator);
        return this;
      }

      public Builder bold(Bold.Builder __builder) {
        bold = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder bold(java.util.function.Consumer<Bold.Builder> __func) {
        Bold.Builder __inner = new Bold.Builder();
        __func.accept(__inner);
        bold = __inner;
        return this;
      }

      public Builder separator(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        separator = __value;
        return this;
      }


      public Tag build() {
        return new Tag(this);
      }

    }

    private final Bold bold;
    private final StringNode separator;

    public Tag(Builder builder) {
      this(builder, true);
    }

    private Tag(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-searchers.tag must be initialized: " + builder.__uninitialized);

      bold = new Bold(builder.bold, throwIfUninitialized);
      separator = (builder.separator == null) ?
          new StringNode("<sep />") : new StringNode(builder.separator);
    }

    /**
     * @return qr-searchers.tag.bold
     */
    public Bold bold() {
      return bold;
    }

    /**
     * @return qr-searchers.tag.separator
     */
    public String separator() {
      return separator.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Tag newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("tag");
      return changes;
    }

    /**
     * This class represents qr-searchers.tag.bold
     */
    public final static class Bold extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private String open = null;
        private String close = null;

        public Builder() { }

        public Builder(Bold config) {
          open(config.open());
          close(config.close());
        }

        private Builder override(Builder __superior) {
          if (__superior.open != null)
            open(__superior.open);
          if (__superior.close != null)
            close(__superior.close);
          return this;
        }

        public Builder open(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          open = __value;
          return this;
        }


        public Builder close(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          close = __value;
          return this;
        }


        public Bold build() {
          return new Bold(this);
        }

      }

      // this file needs more comments
      private final StringNode open;
      private final StringNode close;

      public Bold(Builder builder) {
        this(builder, true);
      }

      private Bold(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "qr-searchers.tag.bold must be initialized: " + builder.__uninitialized);

        open = (builder.open == null) ?
            new StringNode("<hi>") : new StringNode(builder.open);
        close = (builder.close == null) ?
            new StringNode("</hi>") : new StringNode(builder.close);
      }

      /**
       * @return qr-searchers.tag.bold.open
       */
      public String open() {
        return open.value();
      }

      /**
       * @return qr-searchers.tag.bold.close
       */
      public String close() {
        return close.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Bold newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("bold");
        return changes;
      }
    }
  }

  /**
   * This class represents qr-searchers.com
   */
  public final static class Com extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Yahoo.Builder yahoo = new Yahoo.Builder();

      public Builder() { }

      public Builder(Com config) {
        yahoo(new Yahoo.Builder(config.yahoo()));
      }

      private Builder override(Builder __superior) {
        yahoo(yahoo.override(__superior.yahoo));
        return this;
      }

      public Builder yahoo(Yahoo.Builder __builder) {
        yahoo = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder yahoo(java.util.function.Consumer<Yahoo.Builder> __func) {
        Yahoo.Builder __inner = new Yahoo.Builder();
        __func.accept(__inner);
        yahoo = __inner;
        return this;
      }

      public Com build() {
        return new Com(this);
      }

    }

    private final Yahoo yahoo;

    public Com(Builder builder) {
      this(builder, true);
    }

    private Com(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-searchers.com must be initialized: " + builder.__uninitialized);

      yahoo = new Yahoo(builder.yahoo, throwIfUninitialized);
    }

    /**
     * @return qr-searchers.com.yahoo
     */
    public Yahoo yahoo() {
      return yahoo;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Com newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("com");
      return changes;
    }

    /**
     * This class represents qr-searchers.com.yahoo
     */
    public final static class Yahoo extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public Prelude.Builder prelude = new Prelude.Builder();

        public Builder() { }

        public Builder(Yahoo config) {
          prelude(new Prelude.Builder(config.prelude()));
        }

        private Builder override(Builder __superior) {
          prelude(prelude.override(__superior.prelude));
          return this;
        }

        public Builder prelude(Prelude.Builder __builder) {
          prelude = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder prelude(java.util.function.Consumer<Prelude.Builder> __func) {
          Prelude.Builder __inner = new Prelude.Builder();
          __func.accept(__inner);
          prelude = __inner;
          return this;
        }

        public Yahoo build() {
          return new Yahoo(this);
        }

      }

      private final Prelude prelude;

      public Yahoo(Builder builder) {
        this(builder, true);
      }

      private Yahoo(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "qr-searchers.com.yahoo must be initialized: " + builder.__uninitialized);

        prelude = new Prelude(builder.prelude, throwIfUninitialized);
      }

      /**
       * @return qr-searchers.com.yahoo.prelude
       */
      public Prelude prelude() {
        return prelude;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Yahoo newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("yahoo");
        return changes;
      }

      /**
       * This class represents qr-searchers.com.yahoo.prelude
       */
      public final static class Prelude extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public Searcher.Builder searcher = new Searcher.Builder();
          public Querytransform.Builder querytransform = new Querytransform.Builder();
          public Statistics.Builder statistics = new Statistics.Builder();

          public Builder() { }

          public Builder(Prelude config) {
            searcher(new Searcher.Builder(config.searcher()));
            querytransform(new Querytransform.Builder(config.querytransform()));
            statistics(new Statistics.Builder(config.statistics()));
          }

          private Builder override(Builder __superior) {
            searcher(searcher.override(__superior.searcher));
            querytransform(querytransform.override(__superior.querytransform));
            statistics(statistics.override(__superior.statistics));
            return this;
          }

          public Builder searcher(Searcher.Builder __builder) {
            searcher = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder searcher(java.util.function.Consumer<Searcher.Builder> __func) {
            Searcher.Builder __inner = new Searcher.Builder();
            __func.accept(__inner);
            searcher = __inner;
            return this;
          }

          public Builder querytransform(Querytransform.Builder __builder) {
            querytransform = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder querytransform(java.util.function.Consumer<Querytransform.Builder> __func) {
            Querytransform.Builder __inner = new Querytransform.Builder();
            __func.accept(__inner);
            querytransform = __inner;
            return this;
          }

          public Builder statistics(Statistics.Builder __builder) {
            statistics = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder statistics(java.util.function.Consumer<Statistics.Builder> __func) {
            Statistics.Builder __inner = new Statistics.Builder();
            __func.accept(__inner);
            statistics = __inner;
            return this;
          }

          public Prelude build() {
            return new Prelude(this);
          }

        }

        private final Searcher searcher;
        private final Querytransform querytransform;
        private final Statistics statistics;

        public Prelude(Builder builder) {
          this(builder, true);
        }

        private Prelude(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "qr-searchers.com.yahoo.prelude must be initialized: " + builder.__uninitialized);

          searcher = new Searcher(builder.searcher, throwIfUninitialized);
          querytransform = new Querytransform(builder.querytransform, throwIfUninitialized);
          statistics = new Statistics(builder.statistics, throwIfUninitialized);
        }

        /**
         * @return qr-searchers.com.yahoo.prelude.searcher
         */
        public Searcher searcher() {
          return searcher;
        }

        /**
         * @return qr-searchers.com.yahoo.prelude.querytransform
         */
        public Querytransform querytransform() {
          return querytransform;
        }

        /**
         * @return qr-searchers.com.yahoo.prelude.statistics
         */
        public Statistics statistics() {
          return statistics;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Prelude newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("prelude");
          return changes;
        }

        /**
         * This class represents qr-searchers.com.yahoo.prelude.searcher
         */
        public final static class Searcher extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            public FieldCollapsingSearcher.Builder FieldCollapsingSearcher = new FieldCollapsingSearcher.Builder();
            public BlendingSearcher.Builder BlendingSearcher = new BlendingSearcher.Builder();
            public JuniperSearcher.Builder JuniperSearcher = new JuniperSearcher.Builder();
            public XMLStringSearcher.Builder XMLStringSearcher = new XMLStringSearcher.Builder();

            public Builder() { }

            public Builder(Searcher config) {
              FieldCollapsingSearcher(new FieldCollapsingSearcher.Builder(config.FieldCollapsingSearcher()));
              BlendingSearcher(new BlendingSearcher.Builder(config.BlendingSearcher()));
              JuniperSearcher(new JuniperSearcher.Builder(config.JuniperSearcher()));
              XMLStringSearcher(new XMLStringSearcher.Builder(config.XMLStringSearcher()));
            }

            private Builder override(Builder __superior) {
              FieldCollapsingSearcher(FieldCollapsingSearcher.override(__superior.FieldCollapsingSearcher));
              BlendingSearcher(BlendingSearcher.override(__superior.BlendingSearcher));
              JuniperSearcher(JuniperSearcher.override(__superior.JuniperSearcher));
              XMLStringSearcher(XMLStringSearcher.override(__superior.XMLStringSearcher));
              return this;
            }

            public Builder FieldCollapsingSearcher(FieldCollapsingSearcher.Builder __builder) {
              FieldCollapsingSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder FieldCollapsingSearcher(java.util.function.Consumer<FieldCollapsingSearcher.Builder> __func) {
              FieldCollapsingSearcher.Builder __inner = new FieldCollapsingSearcher.Builder();
              __func.accept(__inner);
              FieldCollapsingSearcher = __inner;
              return this;
            }

            public Builder BlendingSearcher(BlendingSearcher.Builder __builder) {
              BlendingSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder BlendingSearcher(java.util.function.Consumer<BlendingSearcher.Builder> __func) {
              BlendingSearcher.Builder __inner = new BlendingSearcher.Builder();
              __func.accept(__inner);
              BlendingSearcher = __inner;
              return this;
            }

            public Builder JuniperSearcher(JuniperSearcher.Builder __builder) {
              JuniperSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder JuniperSearcher(java.util.function.Consumer<JuniperSearcher.Builder> __func) {
              JuniperSearcher.Builder __inner = new JuniperSearcher.Builder();
              __func.accept(__inner);
              JuniperSearcher = __inner;
              return this;
            }

            public Builder XMLStringSearcher(XMLStringSearcher.Builder __builder) {
              XMLStringSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder XMLStringSearcher(java.util.function.Consumer<XMLStringSearcher.Builder> __func) {
              XMLStringSearcher.Builder __inner = new XMLStringSearcher.Builder();
              __func.accept(__inner);
              XMLStringSearcher = __inner;
              return this;
            }

            public Searcher build() {
              return new Searcher(this);
            }

          }

          private final FieldCollapsingSearcher FieldCollapsingSearcher;
          private final BlendingSearcher BlendingSearcher;
          private final JuniperSearcher JuniperSearcher;
          private final XMLStringSearcher XMLStringSearcher;

          public Searcher(Builder builder) {
            this(builder, true);
          }

          private Searcher(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "qr-searchers.com.yahoo.prelude.searcher must be initialized: " + builder.__uninitialized);

            FieldCollapsingSearcher = new FieldCollapsingSearcher(builder.FieldCollapsingSearcher, throwIfUninitialized);
            BlendingSearcher = new BlendingSearcher(builder.BlendingSearcher, throwIfUninitialized);
            JuniperSearcher = new JuniperSearcher(builder.JuniperSearcher, throwIfUninitialized);
            XMLStringSearcher = new XMLStringSearcher(builder.XMLStringSearcher, throwIfUninitialized);
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.searcher.FieldCollapsingSearcher
           */
          public FieldCollapsingSearcher FieldCollapsingSearcher() {
            return FieldCollapsingSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.searcher.BlendingSearcher
           */
          public BlendingSearcher BlendingSearcher() {
            return BlendingSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.searcher.JuniperSearcher
           */
          public JuniperSearcher JuniperSearcher() {
            return JuniperSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.searcher.XMLStringSearcher
           */
          public XMLStringSearcher XMLStringSearcher() {
            return XMLStringSearcher;
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Searcher newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("searcher");
            return changes;
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.searcher.FieldCollapsingSearcher
           */
          public final static class FieldCollapsingSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private Integer collapsesize = null;
              private Double extrafactor = null;
              private String collapsefield = null;

              public Builder() { }

              public Builder(FieldCollapsingSearcher config) {
                collapsesize(config.collapsesize());
                extrafactor(config.extrafactor());
                collapsefield(config.collapsefield());
              }

              private Builder override(Builder __superior) {
                if (__superior.collapsesize != null)
                  collapsesize(__superior.collapsesize);
                if (__superior.extrafactor != null)
                  extrafactor(__superior.extrafactor);
                if (__superior.collapsefield != null)
                  collapsefield(__superior.collapsefield);
                return this;
              }

              public Builder collapsesize(int __value) {
                collapsesize = __value;
                return this;
              }

              private Builder collapsesize(String __value) {
                return collapsesize(Integer.valueOf(__value));
              }

              public Builder extrafactor(double __value) {
                extrafactor = __value;
                return this;
              }

              private Builder extrafactor(String __value) {
                return extrafactor(Double.valueOf(__value));
              }

              public Builder collapsefield(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                collapsefield = __value;
                return this;
              }


              public FieldCollapsingSearcher build() {
                return new FieldCollapsingSearcher(this);
              }

            }

            // some searcher specific configuration parameters:
            private final IntegerNode collapsesize;
            private final DoubleNode extrafactor;
            private final StringNode collapsefield;

            public FieldCollapsingSearcher(Builder builder) {
              this(builder, true);
            }

            private FieldCollapsingSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.searcher.FieldCollapsingSearcher must be initialized: " + builder.__uninitialized);

              collapsesize = (builder.collapsesize == null) ?
                  new IntegerNode(1) : new IntegerNode(builder.collapsesize);
              extrafactor = (builder.extrafactor == null) ?
                  new DoubleNode(2.0D) : new DoubleNode(builder.extrafactor);
              collapsefield = (builder.collapsefield == null) ?
                  new StringNode("mid") : new StringNode(builder.collapsefield);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.searcher.FieldCollapsingSearcher.collapsesize
             */
            public int collapsesize() {
              return collapsesize.value();
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.searcher.FieldCollapsingSearcher.extrafactor
             */
            public double extrafactor() {
              return extrafactor.value();
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.searcher.FieldCollapsingSearcher.collapsefield
             */
            public String collapsefield() {
              return collapsefield.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(FieldCollapsingSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("FieldCollapsingSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.searcher.BlendingSearcher
           */
          public final static class BlendingSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private Integer numthreads = null;
              private String docid = null;

              public Builder() { }

              public Builder(BlendingSearcher config) {
                numthreads(config.numthreads());
                docid(config.docid());
              }

              private Builder override(Builder __superior) {
                if (__superior.numthreads != null)
                  numthreads(__superior.numthreads);
                if (__superior.docid != null)
                  docid(__superior.docid);
                return this;
              }

              public Builder numthreads(int __value) {
                numthreads = __value;
                return this;
              }

              private Builder numthreads(String __value) {
                return numthreads(Integer.valueOf(__value));
              }

              public Builder docid(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                docid = __value;
                return this;
              }


              public BlendingSearcher build() {
                return new BlendingSearcher(this);
              }

            }

            private final IntegerNode numthreads;
            // The field we'll unique on, use [id] to unique on the document id
            private final StringNode docid;

            public BlendingSearcher(Builder builder) {
              this(builder, true);
            }

            private BlendingSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.searcher.BlendingSearcher must be initialized: " + builder.__uninitialized);

              numthreads = (builder.numthreads == null) ?
                  new IntegerNode(200) : new IntegerNode(builder.numthreads);
              docid = (builder.docid == null) ?
                  new StringNode("") : new StringNode(builder.docid);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.searcher.BlendingSearcher.numthreads
             */
            public int numthreads() {
              return numthreads.value();
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.searcher.BlendingSearcher.docid
             */
            public String docid() {
              return docid.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(BlendingSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("BlendingSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.searcher.JuniperSearcher
           */
          public final static class JuniperSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String source = null;
              private String defaultdoctype = null;

              public Builder() { }

              public Builder(JuniperSearcher config) {
                source(config.source());
                defaultdoctype(config.defaultdoctype());
              }

              private Builder override(Builder __superior) {
                if (__superior.source != null)
                  source(__superior.source);
                if (__superior.defaultdoctype != null)
                  defaultdoctype(__superior.defaultdoctype);
                return this;
              }

              public Builder source(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                source = __value;
                return this;
              }


              public Builder defaultdoctype(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                defaultdoctype = __value;
                return this;
              }


              public JuniperSearcher build() {
                return new JuniperSearcher(this);
              }

            }

            private final StringNode source;
            private final StringNode defaultdoctype;

            public JuniperSearcher(Builder builder) {
              this(builder, true);
            }

            private JuniperSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.searcher.JuniperSearcher must be initialized: " + builder.__uninitialized);

              source = (builder.source == null) ?
                  new StringNode("") : new StringNode(builder.source);
              defaultdoctype = (builder.defaultdoctype == null) ?
                  new StringNode("") : new StringNode(builder.defaultdoctype);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.searcher.JuniperSearcher.source
             */
            public String source() {
              return source.value();
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.searcher.JuniperSearcher.defaultdoctype
             */
            public String defaultdoctype() {
              return defaultdoctype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(JuniperSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("JuniperSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.searcher.XMLStringSearcher
           */
          public final static class XMLStringSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String source = null;

              public Builder() { }

              public Builder(XMLStringSearcher config) {
                source(config.source());
              }

              private Builder override(Builder __superior) {
                if (__superior.source != null)
                  source(__superior.source);
                return this;
              }

              public Builder source(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                source = __value;
                return this;
              }


              public XMLStringSearcher build() {
                return new XMLStringSearcher(this);
              }

            }

            private final StringNode source;

            public XMLStringSearcher(Builder builder) {
              this(builder, true);
            }

            private XMLStringSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.searcher.XMLStringSearcher must be initialized: " + builder.__uninitialized);

              source = (builder.source == null) ?
                  new StringNode("") : new StringNode(builder.source);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.searcher.XMLStringSearcher.source
             */
            public String source() {
              return source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(XMLStringSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("XMLStringSearcher");
              return changes;
            }
          }
        }

        /**
         * This class represents qr-searchers.com.yahoo.prelude.querytransform
         */
        public final static class Querytransform extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            public PhrasingSearcher.Builder PhrasingSearcher = new PhrasingSearcher.Builder();
            public NonPhrasingSearcher.Builder NonPhrasingSearcher = new NonPhrasingSearcher.Builder();
            public TermReplacingSearcher.Builder TermReplacingSearcher = new TermReplacingSearcher.Builder();
            public CompleteBoostSearcher.Builder CompleteBoostSearcher = new CompleteBoostSearcher.Builder();
            public ExactStringSearcher.Builder ExactStringSearcher = new ExactStringSearcher.Builder();
            public LiteralBoostSearcher.Builder LiteralBoostSearcher = new LiteralBoostSearcher.Builder();
            public TermBoostSearcher.Builder TermBoostSearcher = new TermBoostSearcher.Builder();
            public NormalizingSearcher.Builder NormalizingSearcher = new NormalizingSearcher.Builder();
            public StemmingSearcher.Builder StemmingSearcher = new StemmingSearcher.Builder();

            public Builder() { }

            public Builder(Querytransform config) {
              PhrasingSearcher(new PhrasingSearcher.Builder(config.PhrasingSearcher()));
              NonPhrasingSearcher(new NonPhrasingSearcher.Builder(config.NonPhrasingSearcher()));
              TermReplacingSearcher(new TermReplacingSearcher.Builder(config.TermReplacingSearcher()));
              CompleteBoostSearcher(new CompleteBoostSearcher.Builder(config.CompleteBoostSearcher()));
              ExactStringSearcher(new ExactStringSearcher.Builder(config.ExactStringSearcher()));
              LiteralBoostSearcher(new LiteralBoostSearcher.Builder(config.LiteralBoostSearcher()));
              TermBoostSearcher(new TermBoostSearcher.Builder(config.TermBoostSearcher()));
              NormalizingSearcher(new NormalizingSearcher.Builder(config.NormalizingSearcher()));
              StemmingSearcher(new StemmingSearcher.Builder(config.StemmingSearcher()));
            }

            private Builder override(Builder __superior) {
              PhrasingSearcher(PhrasingSearcher.override(__superior.PhrasingSearcher));
              NonPhrasingSearcher(NonPhrasingSearcher.override(__superior.NonPhrasingSearcher));
              TermReplacingSearcher(TermReplacingSearcher.override(__superior.TermReplacingSearcher));
              CompleteBoostSearcher(CompleteBoostSearcher.override(__superior.CompleteBoostSearcher));
              ExactStringSearcher(ExactStringSearcher.override(__superior.ExactStringSearcher));
              LiteralBoostSearcher(LiteralBoostSearcher.override(__superior.LiteralBoostSearcher));
              TermBoostSearcher(TermBoostSearcher.override(__superior.TermBoostSearcher));
              NormalizingSearcher(NormalizingSearcher.override(__superior.NormalizingSearcher));
              StemmingSearcher(StemmingSearcher.override(__superior.StemmingSearcher));
              return this;
            }

            public Builder PhrasingSearcher(PhrasingSearcher.Builder __builder) {
              PhrasingSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder PhrasingSearcher(java.util.function.Consumer<PhrasingSearcher.Builder> __func) {
              PhrasingSearcher.Builder __inner = new PhrasingSearcher.Builder();
              __func.accept(__inner);
              PhrasingSearcher = __inner;
              return this;
            }

            public Builder NonPhrasingSearcher(NonPhrasingSearcher.Builder __builder) {
              NonPhrasingSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder NonPhrasingSearcher(java.util.function.Consumer<NonPhrasingSearcher.Builder> __func) {
              NonPhrasingSearcher.Builder __inner = new NonPhrasingSearcher.Builder();
              __func.accept(__inner);
              NonPhrasingSearcher = __inner;
              return this;
            }

            public Builder TermReplacingSearcher(TermReplacingSearcher.Builder __builder) {
              TermReplacingSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder TermReplacingSearcher(java.util.function.Consumer<TermReplacingSearcher.Builder> __func) {
              TermReplacingSearcher.Builder __inner = new TermReplacingSearcher.Builder();
              __func.accept(__inner);
              TermReplacingSearcher = __inner;
              return this;
            }

            public Builder CompleteBoostSearcher(CompleteBoostSearcher.Builder __builder) {
              CompleteBoostSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder CompleteBoostSearcher(java.util.function.Consumer<CompleteBoostSearcher.Builder> __func) {
              CompleteBoostSearcher.Builder __inner = new CompleteBoostSearcher.Builder();
              __func.accept(__inner);
              CompleteBoostSearcher = __inner;
              return this;
            }

            public Builder ExactStringSearcher(ExactStringSearcher.Builder __builder) {
              ExactStringSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder ExactStringSearcher(java.util.function.Consumer<ExactStringSearcher.Builder> __func) {
              ExactStringSearcher.Builder __inner = new ExactStringSearcher.Builder();
              __func.accept(__inner);
              ExactStringSearcher = __inner;
              return this;
            }

            public Builder LiteralBoostSearcher(LiteralBoostSearcher.Builder __builder) {
              LiteralBoostSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder LiteralBoostSearcher(java.util.function.Consumer<LiteralBoostSearcher.Builder> __func) {
              LiteralBoostSearcher.Builder __inner = new LiteralBoostSearcher.Builder();
              __func.accept(__inner);
              LiteralBoostSearcher = __inner;
              return this;
            }

            public Builder TermBoostSearcher(TermBoostSearcher.Builder __builder) {
              TermBoostSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder TermBoostSearcher(java.util.function.Consumer<TermBoostSearcher.Builder> __func) {
              TermBoostSearcher.Builder __inner = new TermBoostSearcher.Builder();
              __func.accept(__inner);
              TermBoostSearcher = __inner;
              return this;
            }

            public Builder NormalizingSearcher(NormalizingSearcher.Builder __builder) {
              NormalizingSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder NormalizingSearcher(java.util.function.Consumer<NormalizingSearcher.Builder> __func) {
              NormalizingSearcher.Builder __inner = new NormalizingSearcher.Builder();
              __func.accept(__inner);
              NormalizingSearcher = __inner;
              return this;
            }

            public Builder StemmingSearcher(StemmingSearcher.Builder __builder) {
              StemmingSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder StemmingSearcher(java.util.function.Consumer<StemmingSearcher.Builder> __func) {
              StemmingSearcher.Builder __inner = new StemmingSearcher.Builder();
              __func.accept(__inner);
              StemmingSearcher = __inner;
              return this;
            }

            public Querytransform build() {
              return new Querytransform(this);
            }

          }

          private final PhrasingSearcher PhrasingSearcher;
          private final NonPhrasingSearcher NonPhrasingSearcher;
          private final TermReplacingSearcher TermReplacingSearcher;
          private final CompleteBoostSearcher CompleteBoostSearcher;
          private final ExactStringSearcher ExactStringSearcher;
          private final LiteralBoostSearcher LiteralBoostSearcher;
          private final TermBoostSearcher TermBoostSearcher;
          private final NormalizingSearcher NormalizingSearcher;
          private final StemmingSearcher StemmingSearcher;

          public Querytransform(Builder builder) {
            this(builder, true);
          }

          private Querytransform(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "qr-searchers.com.yahoo.prelude.querytransform must be initialized: " + builder.__uninitialized);

            PhrasingSearcher = new PhrasingSearcher(builder.PhrasingSearcher, throwIfUninitialized);
            NonPhrasingSearcher = new NonPhrasingSearcher(builder.NonPhrasingSearcher, throwIfUninitialized);
            TermReplacingSearcher = new TermReplacingSearcher(builder.TermReplacingSearcher, throwIfUninitialized);
            CompleteBoostSearcher = new CompleteBoostSearcher(builder.CompleteBoostSearcher, throwIfUninitialized);
            ExactStringSearcher = new ExactStringSearcher(builder.ExactStringSearcher, throwIfUninitialized);
            LiteralBoostSearcher = new LiteralBoostSearcher(builder.LiteralBoostSearcher, throwIfUninitialized);
            TermBoostSearcher = new TermBoostSearcher(builder.TermBoostSearcher, throwIfUninitialized);
            NormalizingSearcher = new NormalizingSearcher(builder.NormalizingSearcher, throwIfUninitialized);
            StemmingSearcher = new StemmingSearcher(builder.StemmingSearcher, throwIfUninitialized);
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.PhrasingSearcher
           */
          public PhrasingSearcher PhrasingSearcher() {
            return PhrasingSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.NonPhrasingSearcher
           */
          public NonPhrasingSearcher NonPhrasingSearcher() {
            return NonPhrasingSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.TermReplacingSearcher
           */
          public TermReplacingSearcher TermReplacingSearcher() {
            return TermReplacingSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.CompleteBoostSearcher
           */
          public CompleteBoostSearcher CompleteBoostSearcher() {
            return CompleteBoostSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.ExactStringSearcher
           */
          public ExactStringSearcher ExactStringSearcher() {
            return ExactStringSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.LiteralBoostSearcher
           */
          public LiteralBoostSearcher LiteralBoostSearcher() {
            return LiteralBoostSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.TermBoostSearcher
           */
          public TermBoostSearcher TermBoostSearcher() {
            return TermBoostSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.NormalizingSearcher
           */
          public NormalizingSearcher NormalizingSearcher() {
            return NormalizingSearcher;
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.querytransform.StemmingSearcher
           */
          public StemmingSearcher StemmingSearcher() {
            return StemmingSearcher;
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Querytransform newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("querytransform");
            return changes;
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.PhrasingSearcher
           */
          public final static class PhrasingSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String automatonfile = null;

              public Builder() { }

              public Builder(PhrasingSearcher config) {
                automatonfile(config.automatonfile());
              }

              private Builder override(Builder __superior) {
                if (__superior.automatonfile != null)
                  automatonfile(__superior.automatonfile);
                return this;
              }

              public Builder automatonfile(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                automatonfile = __value;
                return this;
              }


              public PhrasingSearcher build() {
                return new PhrasingSearcher(this);
              }

            }

            private final StringNode automatonfile;

            public PhrasingSearcher(Builder builder) {
              this(builder, true);
            }

            private PhrasingSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.PhrasingSearcher must be initialized: " + builder.__uninitialized);

              automatonfile = (builder.automatonfile == null) ?
                  new StringNode("") : new StringNode(builder.automatonfile);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.PhrasingSearcher.automatonfile
             */
            public String automatonfile() {
              return automatonfile.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(PhrasingSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("PhrasingSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.NonPhrasingSearcher
           */
          public final static class NonPhrasingSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String automatonfile = null;

              public Builder() { }

              public Builder(NonPhrasingSearcher config) {
                automatonfile(config.automatonfile());
              }

              private Builder override(Builder __superior) {
                if (__superior.automatonfile != null)
                  automatonfile(__superior.automatonfile);
                return this;
              }

              public Builder automatonfile(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                automatonfile = __value;
                return this;
              }


              public NonPhrasingSearcher build() {
                return new NonPhrasingSearcher(this);
              }

            }

            private final StringNode automatonfile;

            public NonPhrasingSearcher(Builder builder) {
              this(builder, true);
            }

            private NonPhrasingSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.NonPhrasingSearcher must be initialized: " + builder.__uninitialized);

              automatonfile = (builder.automatonfile == null) ?
                  new StringNode("") : new StringNode(builder.automatonfile);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.NonPhrasingSearcher.automatonfile
             */
            public String automatonfile() {
              return automatonfile.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(NonPhrasingSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("NonPhrasingSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.TermReplacingSearcher
           */
          public final static class TermReplacingSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              public List<String> termlist = new ArrayList<>();

              public Builder() { }

              public Builder(TermReplacingSearcher config) {
                termlist(config.termlist());
              }

              private Builder override(Builder __superior) {
                if (!__superior.termlist.isEmpty())
                  termlist.addAll(__superior.termlist);
                return this;
              }

              public Builder termlist(String __value) {
                termlist.add(__value);
                return this;
              }

              public Builder termlist(Collection<String> __values) {
                termlist.addAll(__values);
                return this;
              }

              public TermReplacingSearcher build() {
                return new TermReplacingSearcher(this);
              }

            }

            private final LeafNodeVector<String, StringNode> termlist;

            public TermReplacingSearcher(Builder builder) {
              this(builder, true);
            }

            private TermReplacingSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.TermReplacingSearcher must be initialized: " + builder.__uninitialized);

              termlist = new LeafNodeVector<>(builder.termlist, new StringNode());
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.TermReplacingSearcher.termlist[]
             */
            public List<String> termlist() {
              return termlist.asList();
            }

            /**
             * @param i the index of the value to return
             * @return qr-searchers.com.yahoo.prelude.querytransform.TermReplacingSearcher.termlist[]
             */
            public String termlist(int i) {
              return termlist.get(i).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(TermReplacingSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("TermReplacingSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.CompleteBoostSearcher
           */
          public final static class CompleteBoostSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String source = null;

              public Builder() { }

              public Builder(CompleteBoostSearcher config) {
                source(config.source());
              }

              private Builder override(Builder __superior) {
                if (__superior.source != null)
                  source(__superior.source);
                return this;
              }

              public Builder source(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                source = __value;
                return this;
              }


              public CompleteBoostSearcher build() {
                return new CompleteBoostSearcher(this);
              }

            }

            private final StringNode source;

            public CompleteBoostSearcher(Builder builder) {
              this(builder, true);
            }

            private CompleteBoostSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.CompleteBoostSearcher must be initialized: " + builder.__uninitialized);

              source = (builder.source == null) ?
                  new StringNode("") : new StringNode(builder.source);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.CompleteBoostSearcher.source
             */
            public String source() {
              return source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(CompleteBoostSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("CompleteBoostSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.ExactStringSearcher
           */
          public final static class ExactStringSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String source = null;

              public Builder() { }

              public Builder(ExactStringSearcher config) {
                source(config.source());
              }

              private Builder override(Builder __superior) {
                if (__superior.source != null)
                  source(__superior.source);
                return this;
              }

              public Builder source(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                source = __value;
                return this;
              }


              public ExactStringSearcher build() {
                return new ExactStringSearcher(this);
              }

            }

            private final StringNode source;

            public ExactStringSearcher(Builder builder) {
              this(builder, true);
            }

            private ExactStringSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.ExactStringSearcher must be initialized: " + builder.__uninitialized);

              source = (builder.source == null) ?
                  new StringNode("") : new StringNode(builder.source);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.ExactStringSearcher.source
             */
            public String source() {
              return source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(ExactStringSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("ExactStringSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.LiteralBoostSearcher
           */
          public final static class LiteralBoostSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String source = null;

              public Builder() { }

              public Builder(LiteralBoostSearcher config) {
                source(config.source());
              }

              private Builder override(Builder __superior) {
                if (__superior.source != null)
                  source(__superior.source);
                return this;
              }

              public Builder source(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                source = __value;
                return this;
              }


              public LiteralBoostSearcher build() {
                return new LiteralBoostSearcher(this);
              }

            }

            private final StringNode source;

            public LiteralBoostSearcher(Builder builder) {
              this(builder, true);
            }

            private LiteralBoostSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.LiteralBoostSearcher must be initialized: " + builder.__uninitialized);

              source = (builder.source == null) ?
                  new StringNode("") : new StringNode(builder.source);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.LiteralBoostSearcher.source
             */
            public String source() {
              return source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(LiteralBoostSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("LiteralBoostSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.TermBoostSearcher
           */
          public final static class TermBoostSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String source = null;

              public Builder() { }

              public Builder(TermBoostSearcher config) {
                source(config.source());
              }

              private Builder override(Builder __superior) {
                if (__superior.source != null)
                  source(__superior.source);
                return this;
              }

              public Builder source(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                source = __value;
                return this;
              }


              public TermBoostSearcher build() {
                return new TermBoostSearcher(this);
              }

            }

            private final StringNode source;

            public TermBoostSearcher(Builder builder) {
              this(builder, true);
            }

            private TermBoostSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.TermBoostSearcher must be initialized: " + builder.__uninitialized);

              source = (builder.source == null) ?
                  new StringNode("") : new StringNode(builder.source);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.TermBoostSearcher.source
             */
            public String source() {
              return source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(TermBoostSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("TermBoostSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.NormalizingSearcher
           */
          public final static class NormalizingSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String source = null;

              public Builder() { }

              public Builder(NormalizingSearcher config) {
                source(config.source());
              }

              private Builder override(Builder __superior) {
                if (__superior.source != null)
                  source(__superior.source);
                return this;
              }

              public Builder source(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                source = __value;
                return this;
              }


              public NormalizingSearcher build() {
                return new NormalizingSearcher(this);
              }

            }

            private final StringNode source;

            public NormalizingSearcher(Builder builder) {
              this(builder, true);
            }

            private NormalizingSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.NormalizingSearcher must be initialized: " + builder.__uninitialized);

              source = (builder.source == null) ?
                  new StringNode("") : new StringNode(builder.source);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.NormalizingSearcher.source
             */
            public String source() {
              return source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(NormalizingSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("NormalizingSearcher");
              return changes;
            }
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.querytransform.StemmingSearcher
           */
          public final static class StemmingSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private String source = null;

              public Builder() { }

              public Builder(StemmingSearcher config) {
                source(config.source());
              }

              private Builder override(Builder __superior) {
                if (__superior.source != null)
                  source(__superior.source);
                return this;
              }

              public Builder source(String __value) {
              if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
                source = __value;
                return this;
              }


              public StemmingSearcher build() {
                return new StemmingSearcher(this);
              }

            }

            private final StringNode source;

            public StemmingSearcher(Builder builder) {
              this(builder, true);
            }

            private StemmingSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.querytransform.StemmingSearcher must be initialized: " + builder.__uninitialized);

              source = (builder.source == null) ?
                  new StringNode("") : new StringNode(builder.source);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.querytransform.StemmingSearcher.source
             */
            public String source() {
              return source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(StemmingSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("StemmingSearcher");
              return changes;
            }
          }
        }

        /**
         * This class represents qr-searchers.com.yahoo.prelude.statistics
         */
        public final static class Statistics extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            public StatisticsSearcher.Builder StatisticsSearcher = new StatisticsSearcher.Builder();

            public Builder() { }

            public Builder(Statistics config) {
              StatisticsSearcher(new StatisticsSearcher.Builder(config.StatisticsSearcher()));
            }

            private Builder override(Builder __superior) {
              StatisticsSearcher(StatisticsSearcher.override(__superior.StatisticsSearcher));
              return this;
            }

            public Builder StatisticsSearcher(StatisticsSearcher.Builder __builder) {
              StatisticsSearcher = __builder;
              return this;
            }
            /**
             * Make a new builder and run the supplied function on it before adding it to the list
             * @param __func lambda that modifies the given builder
             * @return this builder
             */
            public Builder StatisticsSearcher(java.util.function.Consumer<StatisticsSearcher.Builder> __func) {
              StatisticsSearcher.Builder __inner = new StatisticsSearcher.Builder();
              __func.accept(__inner);
              StatisticsSearcher = __inner;
              return this;
            }

            public Statistics build() {
              return new Statistics(this);
            }

          }

          private final StatisticsSearcher StatisticsSearcher;

          public Statistics(Builder builder) {
            this(builder, true);
          }

          private Statistics(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "qr-searchers.com.yahoo.prelude.statistics must be initialized: " + builder.__uninitialized);

            StatisticsSearcher = new StatisticsSearcher(builder.StatisticsSearcher, throwIfUninitialized);
          }

          /**
           * @return qr-searchers.com.yahoo.prelude.statistics.StatisticsSearcher
           */
          public StatisticsSearcher StatisticsSearcher() {
            return StatisticsSearcher;
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Statistics newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("statistics");
            return changes;
          }

          /**
           * This class represents qr-searchers.com.yahoo.prelude.statistics.StatisticsSearcher
           */
          public final static class StatisticsSearcher extends InnerNode { 

            public static final class Builder implements ConfigBuilder {
              private Set<String> __uninitialized = new HashSet<String>();

              private Integer latencybucketsize = null;

              public Builder() { }

              public Builder(StatisticsSearcher config) {
                latencybucketsize(config.latencybucketsize());
              }

              private Builder override(Builder __superior) {
                if (__superior.latencybucketsize != null)
                  latencybucketsize(__superior.latencybucketsize);
                return this;
              }

              public Builder latencybucketsize(int __value) {
                latencybucketsize = __value;
                return this;
              }

              private Builder latencybucketsize(String __value) {
                return latencybucketsize(Integer.valueOf(__value));
              }

              public StatisticsSearcher build() {
                return new StatisticsSearcher(this);
              }

            }

            private final IntegerNode latencybucketsize;

            public StatisticsSearcher(Builder builder) {
              this(builder, true);
            }

            private StatisticsSearcher(Builder builder, boolean throwIfUninitialized) {
              if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
                throw new IllegalArgumentException("The following builder parameters for " +
                    "qr-searchers.com.yahoo.prelude.statistics.StatisticsSearcher must be initialized: " + builder.__uninitialized);

              latencybucketsize = (builder.latencybucketsize == null) ?
                  new IntegerNode(30) : new IntegerNode(builder.latencybucketsize);
            }

            /**
             * @return qr-searchers.com.yahoo.prelude.statistics.StatisticsSearcher.latencybucketsize
             */
            public int latencybucketsize() {
              return latencybucketsize.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(StatisticsSearcher newConfig) {
              ChangesRequiringRestart changes = new ChangesRequiringRestart("StatisticsSearcher");
              return changes;
            }
          }
        }
      }
    }
  }

  /**
   * This class represents qr-searchers.customizedsearchers
   */
  public final static class Customizedsearchers extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public List<String> rawquery = new ArrayList<>();
      public List<String> transformedquery = new ArrayList<>();
      public List<String> blendedresult = new ArrayList<>();
      public List<String> unblendedresult = new ArrayList<>();
      public List<String> backend = new ArrayList<>();
      public List<Argument.Builder> argument = new ArrayList<>();

      public Builder() { }

      public Builder(Customizedsearchers config) {
        rawquery(config.rawquery());
        transformedquery(config.transformedquery());
        blendedresult(config.blendedresult());
        unblendedresult(config.unblendedresult());
        backend(config.backend());
        for (Argument a : config.argument()) {
          argument(new Argument.Builder(a));
        }
      }

      private Builder override(Builder __superior) {
        if (!__superior.rawquery.isEmpty())
          rawquery.addAll(__superior.rawquery);
        if (!__superior.transformedquery.isEmpty())
          transformedquery.addAll(__superior.transformedquery);
        if (!__superior.blendedresult.isEmpty())
          blendedresult.addAll(__superior.blendedresult);
        if (!__superior.unblendedresult.isEmpty())
          unblendedresult.addAll(__superior.unblendedresult);
        if (!__superior.backend.isEmpty())
          backend.addAll(__superior.backend);
        if (!__superior.argument.isEmpty())
          argument.addAll(__superior.argument);
        return this;
      }

      public Builder rawquery(String __value) {
        rawquery.add(__value);
        return this;
      }

      public Builder rawquery(Collection<String> __values) {
        rawquery.addAll(__values);
        return this;
      }

      public Builder transformedquery(String __value) {
        transformedquery.add(__value);
        return this;
      }

      public Builder transformedquery(Collection<String> __values) {
        transformedquery.addAll(__values);
        return this;
      }

      public Builder blendedresult(String __value) {
        blendedresult.add(__value);
        return this;
      }

      public Builder blendedresult(Collection<String> __values) {
        blendedresult.addAll(__values);
        return this;
      }

      public Builder unblendedresult(String __value) {
        unblendedresult.add(__value);
        return this;
      }

      public Builder unblendedresult(Collection<String> __values) {
        unblendedresult.addAll(__values);
        return this;
      }

      public Builder backend(String __value) {
        backend.add(__value);
        return this;
      }

      public Builder backend(Collection<String> __values) {
        backend.addAll(__values);
        return this;
      }

      /**
       * Add the given builder to this builder's list of Argument builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder argument(Argument.Builder __builder) {
        argument.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder argument(java.util.function.Consumer<Argument.Builder> __func) {
        Argument.Builder __inner = new Argument.Builder();
        __func.accept(__inner);
        argument.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Argument builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder argument(List<Argument.Builder> __builders) {
        argument = __builders;
        return this;
      }

      public Customizedsearchers build() {
        return new Customizedsearchers(this);
      }

    }

    // here users may add their custom searchers
    // (all strings should be class names)
    private final LeafNodeVector<String, StringNode> rawquery;
    private final LeafNodeVector<String, StringNode> transformedquery;
    private final LeafNodeVector<String, StringNode> blendedresult;
    private final LeafNodeVector<String, StringNode> unblendedresult;
    private final LeafNodeVector<String, StringNode> backend;
    private final InnerNodeVector<Argument> argument;

    public Customizedsearchers(Builder builder) {
      this(builder, true);
    }

    private Customizedsearchers(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-searchers.customizedsearchers must be initialized: " + builder.__uninitialized);

      rawquery = new LeafNodeVector<>(builder.rawquery, new StringNode());
      transformedquery = new LeafNodeVector<>(builder.transformedquery, new StringNode());
      blendedresult = new LeafNodeVector<>(builder.blendedresult, new StringNode());
      unblendedresult = new LeafNodeVector<>(builder.unblendedresult, new StringNode());
      backend = new LeafNodeVector<>(builder.backend, new StringNode());
      argument = Argument.createVector(builder.argument);
    }

    /**
     * @return qr-searchers.customizedsearchers.rawquery[]
     */
    public List<String> rawquery() {
      return rawquery.asList();
    }

    /**
     * @param i the index of the value to return
     * @return qr-searchers.customizedsearchers.rawquery[]
     */
    public String rawquery(int i) {
      return rawquery.get(i).value();
    }

    /**
     * @return qr-searchers.customizedsearchers.transformedquery[]
     */
    public List<String> transformedquery() {
      return transformedquery.asList();
    }

    /**
     * @param i the index of the value to return
     * @return qr-searchers.customizedsearchers.transformedquery[]
     */
    public String transformedquery(int i) {
      return transformedquery.get(i).value();
    }

    /**
     * @return qr-searchers.customizedsearchers.blendedresult[]
     */
    public List<String> blendedresult() {
      return blendedresult.asList();
    }

    /**
     * @param i the index of the value to return
     * @return qr-searchers.customizedsearchers.blendedresult[]
     */
    public String blendedresult(int i) {
      return blendedresult.get(i).value();
    }

    /**
     * @return qr-searchers.customizedsearchers.unblendedresult[]
     */
    public List<String> unblendedresult() {
      return unblendedresult.asList();
    }

    /**
     * @param i the index of the value to return
     * @return qr-searchers.customizedsearchers.unblendedresult[]
     */
    public String unblendedresult(int i) {
      return unblendedresult.get(i).value();
    }

    /**
     * @return qr-searchers.customizedsearchers.backend[]
     */
    public List<String> backend() {
      return backend.asList();
    }

    /**
     * @param i the index of the value to return
     * @return qr-searchers.customizedsearchers.backend[]
     */
    public String backend(int i) {
      return backend.get(i).value();
    }

    /**
     * @return qr-searchers.customizedsearchers.argument[]
     */
    public List<Argument> argument() {
      return argument;
    }

    /**
     * @param i the index of the value to return
     * @return qr-searchers.customizedsearchers.argument[]
     */
    public Argument argument(int i) {
      return argument.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Customizedsearchers newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("customizedsearchers");
      return changes;
    }

    /**
     * This class represents qr-searchers.customizedsearchers.argument[]
     */
    public final static class Argument extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "key",
          "value"
          ));

        private String key = null;
        private String value = null;

        public Builder() { }

        public Builder(Argument config) {
          key(config.key());
          value(config.value());
        }

        private Builder override(Builder __superior) {
          if (__superior.key != null)
            key(__superior.key);
          if (__superior.value != null)
            value(__superior.value);
          return this;
        }

        public Builder key(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          key = __value;
          __uninitialized.remove("key");
          return this;
        }


        public Builder value(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          value = __value;
          __uninitialized.remove("value");
          return this;
        }


        public Argument build() {
          return new Argument(this);
        }

      }

      private final StringNode key;
      private final StringNode value;

      public Argument(Builder builder) {
        this(builder, true);
      }

      private Argument(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "qr-searchers.customizedsearchers.argument[] must be initialized: " + builder.__uninitialized);

        key = (builder.key == null) ?
            new StringNode() : new StringNode(builder.key);
        value = (builder.value == null) ?
            new StringNode() : new StringNode(builder.value);
      }

      /**
       * @return qr-searchers.customizedsearchers.argument[].key
       */
      public String key() {
        return key.value();
      }

      /**
       * @return qr-searchers.customizedsearchers.argument[].value
       */
      public String value() {
        return value.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Argument newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("argument");
        return changes;
      }

      private static InnerNodeVector<Argument> createVector(List<Builder> builders) {
          List<Argument> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Argument(b));
          }
          return new InnerNodeVector<Argument>(elems);
      }
    }
  }

  /**
   * This class represents qr-searchers.external[]
   */
  public final static class External extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public List<String> searcher = new ArrayList<>();

      public Builder() { }

      public Builder(External config) {
        name(config.name());
        searcher(config.searcher());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.searcher.isEmpty())
          searcher.addAll(__superior.searcher);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder searcher(String __value) {
        searcher.add(__value);
        return this;
      }

      public Builder searcher(Collection<String> __values) {
        searcher.addAll(__values);
        return this;
      }

      public External build() {
        return new External(this);
      }

    }

    // This is for adding searchers which should be below BlendingSearcher,
    // but not be linked to any Vespa cluster (directly).
    private final StringNode name;
    private final LeafNodeVector<String, StringNode> searcher;

    public External(Builder builder) {
      this(builder, true);
    }

    private External(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-searchers.external[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      searcher = new LeafNodeVector<>(builder.searcher, new StringNode());
    }

    /**
     * @return qr-searchers.external[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return qr-searchers.external[].searcher[]
     */
    public List<String> searcher() {
      return searcher.asList();
    }

    /**
     * @param i the index of the value to return
     * @return qr-searchers.external[].searcher[]
     */
    public String searcher(int i) {
      return searcher.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(External newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("external");
      return changes;
    }

    private static InnerNodeVector<External> createVector(List<Builder> builders) {
        List<External> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new External(b));
        }
        return new InnerNodeVector<External>(elems);
    }
  }

  /**
   * This class represents qr-searchers.searchcluster[]
   */
  public final static class Searchcluster extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public List<String> searchdef = new ArrayList<>();
      private String rankprofiles_configid = null;
      private Indexingmode.Enum indexingmode = null;
      public Storagecluster.Builder storagecluster = new Storagecluster.Builder();

      public Builder() { }

      public Builder(Searchcluster config) {
        name(config.name());
        searchdef(config.searchdef());
        rankprofiles_configid(config.rankprofiles_configid());
        indexingmode(config.indexingmode());
        storagecluster(new Storagecluster.Builder(config.storagecluster()));
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.searchdef.isEmpty())
          searchdef.addAll(__superior.searchdef);
        if (__superior.rankprofiles_configid != null)
          rankprofiles_configid(__superior.rankprofiles_configid);
        if (__superior.indexingmode != null)
          indexingmode(__superior.indexingmode);
        storagecluster(storagecluster.override(__superior.storagecluster));
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder searchdef(String __value) {
        searchdef.add(__value);
        return this;
      }

      public Builder searchdef(Collection<String> __values) {
        searchdef.addAll(__values);
        return this;
      }

      public Builder rankprofiles_configid(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        rankprofiles_configid = __value;
        return this;
      }


      public Builder indexingmode(Indexingmode.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        indexingmode = __value;
        return this;
      }

      private Builder indexingmode(String __value) {
        return indexingmode(Indexingmode.Enum.valueOf(__value));
      }

      public Builder storagecluster(Storagecluster.Builder __builder) {
        storagecluster = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder storagecluster(java.util.function.Consumer<Storagecluster.Builder> __func) {
        Storagecluster.Builder __inner = new Storagecluster.Builder();
        __func.accept(__inner);
        storagecluster = __inner;
        return this;
      }

      public Searchcluster build() {
        return new Searchcluster(this);
      }

    }

    // Search cluster specific information.
    // Name of search cluster.
    private final StringNode name;
    // Names of search definitions served by search cluster.
    private final LeafNodeVector<String, StringNode> searchdef;
    // configid that may be used to get rank-profiles config for the cluster.
    private final StringNode rankprofiles_configid;
    // Indexing mode of search cluster.
    private final Indexingmode indexingmode;
    private final Storagecluster storagecluster;

    public Searchcluster(Builder builder) {
      this(builder, true);
    }

    private Searchcluster(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-searchers.searchcluster[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      searchdef = new LeafNodeVector<>(builder.searchdef, new StringNode());
      rankprofiles_configid = (builder.rankprofiles_configid == null) ?
          new StringNode("") : new StringNode(builder.rankprofiles_configid);
      indexingmode = (builder.indexingmode == null) ?
          new Indexingmode(Indexingmode.REALTIME) : new Indexingmode(builder.indexingmode);
      storagecluster = new Storagecluster(builder.storagecluster, throwIfUninitialized);
    }

    /**
     * @return qr-searchers.searchcluster[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return qr-searchers.searchcluster[].searchdef[]
     */
    public List<String> searchdef() {
      return searchdef.asList();
    }

    /**
     * @param i the index of the value to return
     * @return qr-searchers.searchcluster[].searchdef[]
     */
    public String searchdef(int i) {
      return searchdef.get(i).value();
    }

    /**
     * @return qr-searchers.searchcluster[].rankprofiles_configid
     */
    public String rankprofiles_configid() {
      return rankprofiles_configid.value();
    }

    /**
     * @return qr-searchers.searchcluster[].indexingmode
     */
    public Indexingmode.Enum indexingmode() {
      return indexingmode.value();
    }

    /**
     * @return qr-searchers.searchcluster[].storagecluster
     */
    public Storagecluster storagecluster() {
      return storagecluster;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Searchcluster newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("searchcluster");
      return changes;
    }

    private static InnerNodeVector<Searchcluster> createVector(List<Builder> builders) {
        List<Searchcluster> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Searchcluster(b));
        }
        return new InnerNodeVector<Searchcluster>(elems);
    }

    /**
     * This class represents qr-searchers.searchcluster[].indexingmode
     * 
     * Indexing mode of search cluster.
     */
    public final static class Indexingmode extends EnumNode<Indexingmode.Enum> {

      public Indexingmode(){
        this.value = null;
      }

      public Indexingmode(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {REALTIME, STREAMING}
      public final static Enum REALTIME = Enum.REALTIME;
      public final static Enum STREAMING = Enum.STREAMING;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents qr-searchers.searchcluster[].storagecluster
     */
    public final static class Storagecluster extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private String routespec = null;

        public Builder() { }

        public Builder(Storagecluster config) {
          routespec(config.routespec());
        }

        private Builder override(Builder __superior) {
          if (__superior.routespec != null)
            routespec(__superior.routespec);
          return this;
        }

        public Builder routespec(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          routespec = __value;
          return this;
        }


        public Storagecluster build() {
          return new Storagecluster(this);
        }

      }

      // Storage cluster route to use for search cluster if indexingmode is streaming.
      private final StringNode routespec;

      public Storagecluster(Builder builder) {
        this(builder, true);
      }

      private Storagecluster(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "qr-searchers.searchcluster[].storagecluster must be initialized: " + builder.__uninitialized);

        routespec = (builder.routespec == null) ?
            new StringNode("") : new StringNode(builder.routespec);
      }

      /**
       * @return qr-searchers.searchcluster[].storagecluster.routespec
       */
      public String routespec() {
        return routespec.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Storagecluster newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("storagecluster");
        return changes;
      }
    }
  }

  /**
   * This class represents qr-searchers.parserSettings
   */
  public final static class ParserSettings extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean keepImplicitAnds = null;
      private Boolean markSegmentAnds = null;
      private Boolean keepSegmentAnds = null;
      private Boolean keepIdeographicPunctuation = null;

      public Builder() { }

      public Builder(ParserSettings config) {
        keepImplicitAnds(config.keepImplicitAnds());
        markSegmentAnds(config.markSegmentAnds());
        keepSegmentAnds(config.keepSegmentAnds());
        keepIdeographicPunctuation(config.keepIdeographicPunctuation());
      }

      private Builder override(Builder __superior) {
        if (__superior.keepImplicitAnds != null)
          keepImplicitAnds(__superior.keepImplicitAnds);
        if (__superior.markSegmentAnds != null)
          markSegmentAnds(__superior.markSegmentAnds);
        if (__superior.keepSegmentAnds != null)
          keepSegmentAnds(__superior.keepSegmentAnds);
        if (__superior.keepIdeographicPunctuation != null)
          keepIdeographicPunctuation(__superior.keepIdeographicPunctuation);
        return this;
      }

      public Builder keepImplicitAnds(boolean __value) {
        keepImplicitAnds = __value;
        return this;
      }

      private Builder keepImplicitAnds(String __value) {
        return keepImplicitAnds(Boolean.valueOf(__value));
      }

      public Builder markSegmentAnds(boolean __value) {
        markSegmentAnds = __value;
        return this;
      }

      private Builder markSegmentAnds(String __value) {
        return markSegmentAnds(Boolean.valueOf(__value));
      }

      public Builder keepSegmentAnds(boolean __value) {
        keepSegmentAnds = __value;
        return this;
      }

      private Builder keepSegmentAnds(String __value) {
        return keepSegmentAnds(Boolean.valueOf(__value));
      }

      public Builder keepIdeographicPunctuation(boolean __value) {
        keepIdeographicPunctuation = __value;
        return this;
      }

      private Builder keepIdeographicPunctuation(String __value) {
        return keepIdeographicPunctuation(Boolean.valueOf(__value));
      }

      public ParserSettings build() {
        return new ParserSettings(this);
      }

    }

    // flags for enabling legacy behavior in weakAnd query parsing:
    // make "a b,c d" parse as (WAND "a" (AND "b" "c") "d")
    private final BooleanNode keepImplicitAnds;
    // mark segment-and items (for folding later) in query parsing
    private final BooleanNode markSegmentAnds;
    // keep segment-and items as-is in query parsing (overrides markSegmentAnds)
    private final BooleanNode keepSegmentAnds;
    // keep ideographic comma and full stop (default: replace with space)
    private final BooleanNode keepIdeographicPunctuation;

    public ParserSettings(Builder builder) {
      this(builder, true);
    }

    private ParserSettings(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr-searchers.parserSettings must be initialized: " + builder.__uninitialized);

      keepImplicitAnds = (builder.keepImplicitAnds == null) ?
          new BooleanNode(true) : new BooleanNode(builder.keepImplicitAnds);
      markSegmentAnds = (builder.markSegmentAnds == null) ?
          new BooleanNode(false) : new BooleanNode(builder.markSegmentAnds);
      keepSegmentAnds = (builder.keepSegmentAnds == null) ?
          new BooleanNode(false) : new BooleanNode(builder.keepSegmentAnds);
      keepIdeographicPunctuation = (builder.keepIdeographicPunctuation == null) ?
          new BooleanNode(false) : new BooleanNode(builder.keepIdeographicPunctuation);
    }

    /**
     * @return qr-searchers.parserSettings.keepImplicitAnds
     */
    public boolean keepImplicitAnds() {
      return keepImplicitAnds.value();
    }

    /**
     * @return qr-searchers.parserSettings.markSegmentAnds
     */
    public boolean markSegmentAnds() {
      return markSegmentAnds.value();
    }

    /**
     * @return qr-searchers.parserSettings.keepSegmentAnds
     */
    public boolean keepSegmentAnds() {
      return keepSegmentAnds.value();
    }

    /**
     * @return qr-searchers.parserSettings.keepIdeographicPunctuation
     */
    public boolean keepIdeographicPunctuation() {
      return keepIdeographicPunctuation.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ParserSettings newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("parserSettings");
      return changes;
    }
  }

}
