/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class MetricSnapshot
implements Iterable<Map.Entry<MetricDimensions, MetricSet>> {
    private final Map<MetricDimensions, MetricSet> data;
    private final long fromMillis;
    private final long toMillis;

    public MetricSnapshot(long from, long to, TimeUnit unit, Map<MetricDimensions, MetricSet> data) {
        this.fromMillis = unit.toMillis(from);
        this.toMillis = unit.toMillis(to);
        this.data = data;
    }

    MetricSnapshot() {
        this(0L, 0L, TimeUnit.MILLISECONDS, new HashMap<MetricDimensions, MetricSet>());
    }

    MetricSnapshot(long from, long to, TimeUnit unit) {
        this(from, to, unit, new HashMap<MetricDimensions, MetricSet>());
    }

    private static MetricSnapshot createWithMetrics(Map<MetricDimensions, MetricSet> data) {
        return new MetricSnapshot(0L, 0L, TimeUnit.MILLISECONDS, data);
    }

    public long getFromTime(TimeUnit unit) {
        return unit.convert(this.fromMillis, TimeUnit.MILLISECONDS);
    }

    public long getToTime(TimeUnit unit) {
        return unit.convert(this.toMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public Iterator<Map.Entry<MetricDimensions, MetricSet>> iterator() {
        return this.data.entrySet().iterator();
    }

    void add(MetricDimensions dim, String key, Number val) {
        this.metricSet(dim).add(key, val);
    }

    void set(MetricDimensions dim, String key, Number val) {
        this.metricSet(dim).set(key, val);
    }

    void add(MetricSnapshot snapshot) {
        for (Map.Entry<MetricDimensions, MetricSet> entry : snapshot) {
            MetricSet metricSet = this.data.get(entry.getKey());
            if (metricSet != null) {
                metricSet.add(entry.getValue());
                continue;
            }
            this.data.put(entry.getKey(), entry.getValue());
        }
    }

    public MetricSet metricSet(MetricDimensions dim) {
        MetricSet metricSet = this.data.get(dim);
        if (metricSet == null) {
            metricSet = new MetricSet();
            this.data.put(dim, metricSet);
        }
        return metricSet;
    }

    public MetricSnapshot createSnapshot() {
        HashMap<MetricDimensions, MetricSet> newData = new HashMap<MetricDimensions, MetricSet>();
        for (Map.Entry<MetricDimensions, MetricSet> entry : this.data.entrySet()) {
            MetricSet newSet = entry.getValue().partialClone();
            if (newSet.isEmpty()) continue;
            newData.put(entry.getKey(), newSet);
        }
        return MetricSnapshot.createWithMetrics(newData);
    }
}

