/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.processors;

import com.yahoo.processing.Processor;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import java.util.Map;

public class RequestPropertyTracer
extends Processor {
    @Override
    public Response process(Request request, Execution execution) {
        if (execution.trace().getTraceLevel() < 4) {
            return execution.process(request);
        }
        StringBuilder b = new StringBuilder("{");
        for (Map.Entry<String, Object> property : request.properties().listProperties().entrySet()) {
            b.append(property.getKey()).append(": '").append(property.getValue()).append("',");
        }
        b.setLength(b.length() - 1);
        b.append("}");
        execution.trace().trace(b.toString(), 4);
        return execution.process(request);
    }
}

