/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class ThreadpoolConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "68f09a2773696a5224de584d1fb17673";
    public static final String CONFIG_DEF_NAME = "threadpool";
    public static final String CONFIG_DEF_NAMESPACE = "container.handler";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.handler", "maxthreads int default=500", "corePoolSize int default=500", "keepAliveTime double default=5.0", "queueSize int default=0", "maxThreadExecutionTimeSeconds int default=190", "name string default=\"default-pool\""};
    private final IntegerNode maxthreads;
    private final IntegerNode corePoolSize;
    private final DoubleNode keepAliveTime;
    private final IntegerNode queueSize;
    private final IntegerNode maxThreadExecutionTimeSeconds;
    private final StringNode name;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ThreadpoolConfig(Builder builder) {
        this(builder, true);
    }

    private ThreadpoolConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for threadpool must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.maxthreads = builder.maxthreads == null ? new IntegerNode(500) : new IntegerNode(builder.maxthreads.intValue());
        this.corePoolSize = builder.corePoolSize == null ? new IntegerNode(500) : new IntegerNode(builder.corePoolSize.intValue());
        this.keepAliveTime = builder.keepAliveTime == null ? new DoubleNode(5.0) : new DoubleNode(builder.keepAliveTime.doubleValue());
        this.queueSize = builder.queueSize == null ? new IntegerNode(0) : new IntegerNode(builder.queueSize.intValue());
        this.maxThreadExecutionTimeSeconds = builder.maxThreadExecutionTimeSeconds == null ? new IntegerNode(190) : new IntegerNode(builder.maxThreadExecutionTimeSeconds.intValue());
        this.name = builder.name == null ? new StringNode("default-pool") : new StringNode(builder.name);
    }

    public int maxthreads() {
        return this.maxthreads.value();
    }

    public int corePoolSize() {
        return this.corePoolSize.value();
    }

    public double keepAliveTime() {
        return this.keepAliveTime.value();
    }

    public int queueSize() {
        return this.queueSize.value();
    }

    public int maxThreadExecutionTimeSeconds() {
        return this.maxThreadExecutionTimeSeconds.value();
    }

    public String name() {
        return this.name.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ThreadpoolConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer maxthreads = null;
        private Integer corePoolSize = null;
        private Double keepAliveTime = null;
        private Integer queueSize = null;
        private Integer maxThreadExecutionTimeSeconds = null;
        private String name = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ThreadpoolConfig config) {
            this.maxthreads(config.maxthreads());
            this.corePoolSize(config.corePoolSize());
            this.keepAliveTime(config.keepAliveTime());
            this.queueSize(config.queueSize());
            this.maxThreadExecutionTimeSeconds(config.maxThreadExecutionTimeSeconds());
            this.name(config.name());
        }

        private Builder override(Builder __superior) {
            if (__superior.maxthreads != null) {
                this.maxthreads(__superior.maxthreads);
            }
            if (__superior.corePoolSize != null) {
                this.corePoolSize(__superior.corePoolSize);
            }
            if (__superior.keepAliveTime != null) {
                this.keepAliveTime(__superior.keepAliveTime);
            }
            if (__superior.queueSize != null) {
                this.queueSize(__superior.queueSize);
            }
            if (__superior.maxThreadExecutionTimeSeconds != null) {
                this.maxThreadExecutionTimeSeconds(__superior.maxThreadExecutionTimeSeconds);
            }
            if (__superior.name != null) {
                this.name(__superior.name);
            }
            return this;
        }

        public Builder maxthreads(int __value) {
            this.maxthreads = __value;
            return this;
        }

        private Builder maxthreads(String __value) {
            return this.maxthreads(Integer.valueOf(__value));
        }

        public Builder corePoolSize(int __value) {
            this.corePoolSize = __value;
            return this;
        }

        private Builder corePoolSize(String __value) {
            return this.corePoolSize(Integer.valueOf(__value));
        }

        public Builder keepAliveTime(double __value) {
            this.keepAliveTime = __value;
            return this;
        }

        private Builder keepAliveTime(String __value) {
            return this.keepAliveTime(Double.valueOf(__value));
        }

        public Builder queueSize(int __value) {
            this.queueSize = __value;
            return this;
        }

        private Builder queueSize(String __value) {
            return this.queueSize(Integer.valueOf(__value));
        }

        public Builder maxThreadExecutionTimeSeconds(int __value) {
            this.maxThreadExecutionTimeSeconds = __value;
            return this;
        }

        private Builder maxThreadExecutionTimeSeconds(String __value) {
            return this.maxThreadExecutionTimeSeconds(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.name = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ThreadpoolConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ThreadpoolConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ThreadpoolConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ThreadpoolConfig build() {
            return new ThreadpoolConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

