// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.jdisc.http;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of server
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ServerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "2a8779f48af4afc39d1f08b1ee644336";
  public final static String CONFIG_DEF_NAME = "server";
  public final static String CONFIG_DEF_NAMESPACE = "jdisc.http";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=jdisc.http",
    "developerMode bool default=false",
    "responseCompressionLevel int default=6",
    "removeRawPostBodyForWwwUrlEncodedPost bool default=false",
    "filter[].id string",
    "filter[].binding string",
    "defaultFilters[].filterId string",
    "defaultFilters[].localPort int",
    "strictFiltering bool default = false",
    "maxWorkerThreads int default = -1",
    "minWorkerThreads int default = -1",
    "stopTimeout double default = 30.0",
    "jmx.enabled bool default = false",
    "jmx.listenPort int default = 1099",
    "metric.monitoringHandlerPaths[] string",
    "metric.searchHandlerPaths[] string",
    "metric.ignoredUserAgents[] string",
    "metric.reporterEnabled bool default = true",
    "connectionLog.enabled bool default=false"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean developerMode = null;
    private Integer responseCompressionLevel = null;
    private Boolean removeRawPostBodyForWwwUrlEncodedPost = null;
    public List<Filter.Builder> filter = new ArrayList<>();
    public List<DefaultFilters.Builder> defaultFilters = new ArrayList<>();
    private Boolean strictFiltering = null;
    private Integer maxWorkerThreads = null;
    private Integer minWorkerThreads = null;
    private Double stopTimeout = null;
    public Jmx.Builder jmx = new Jmx.Builder();
    public Metric.Builder metric = new Metric.Builder();
    public ConnectionLog.Builder connectionLog = new ConnectionLog.Builder();

    public Builder() { }

    public Builder(ServerConfig config) {
      developerMode(config.developerMode());
      responseCompressionLevel(config.responseCompressionLevel());
      removeRawPostBodyForWwwUrlEncodedPost(config.removeRawPostBodyForWwwUrlEncodedPost());
      for (Filter f : config.filter()) {
        filter(new Filter.Builder(f));
      }
      for (DefaultFilters d : config.defaultFilters()) {
        defaultFilters(new DefaultFilters.Builder(d));
      }
      strictFiltering(config.strictFiltering());
      maxWorkerThreads(config.maxWorkerThreads());
      minWorkerThreads(config.minWorkerThreads());
      stopTimeout(config.stopTimeout());
      jmx(new Jmx.Builder(config.jmx()));
      metric(new Metric.Builder(config.metric()));
      connectionLog(new ConnectionLog.Builder(config.connectionLog()));
    }

    private Builder override(Builder __superior) {
      if (__superior.developerMode != null)
        developerMode(__superior.developerMode);
      if (__superior.responseCompressionLevel != null)
        responseCompressionLevel(__superior.responseCompressionLevel);
      if (__superior.removeRawPostBodyForWwwUrlEncodedPost != null)
        removeRawPostBodyForWwwUrlEncodedPost(__superior.removeRawPostBodyForWwwUrlEncodedPost);
      if (!__superior.filter.isEmpty())
        filter.addAll(__superior.filter);
      if (!__superior.defaultFilters.isEmpty())
        defaultFilters.addAll(__superior.defaultFilters);
      if (__superior.strictFiltering != null)
        strictFiltering(__superior.strictFiltering);
      if (__superior.maxWorkerThreads != null)
        maxWorkerThreads(__superior.maxWorkerThreads);
      if (__superior.minWorkerThreads != null)
        minWorkerThreads(__superior.minWorkerThreads);
      if (__superior.stopTimeout != null)
        stopTimeout(__superior.stopTimeout);
      jmx(jmx.override(__superior.jmx));
      metric(metric.override(__superior.metric));
      connectionLog(connectionLog.override(__superior.connectionLog));
      return this;
    }

    public Builder developerMode(boolean __value) {
      developerMode = __value;
      return this;
    }

    private Builder developerMode(String __value) {
      return developerMode(Boolean.valueOf(__value));
    }

    public Builder responseCompressionLevel(int __value) {
      responseCompressionLevel = __value;
      return this;
    }

    private Builder responseCompressionLevel(String __value) {
      return responseCompressionLevel(Integer.valueOf(__value));
    }

    public Builder removeRawPostBodyForWwwUrlEncodedPost(boolean __value) {
      removeRawPostBodyForWwwUrlEncodedPost = __value;
      return this;
    }

    private Builder removeRawPostBodyForWwwUrlEncodedPost(String __value) {
      return removeRawPostBodyForWwwUrlEncodedPost(Boolean.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Filter builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder filter(Filter.Builder __builder) {
      filter.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder filter(java.util.function.Consumer<Filter.Builder> __func) {
      Filter.Builder __inner = new Filter.Builder();
      __func.accept(__inner);
      filter.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Filter builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder filter(List<Filter.Builder> __builders) {
      filter = __builders;
      return this;
    }

    /**
     * Add the given builder to this builder's list of DefaultFilters builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder defaultFilters(DefaultFilters.Builder __builder) {
      defaultFilters.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder defaultFilters(java.util.function.Consumer<DefaultFilters.Builder> __func) {
      DefaultFilters.Builder __inner = new DefaultFilters.Builder();
      __func.accept(__inner);
      defaultFilters.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of DefaultFilters builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder defaultFilters(List<DefaultFilters.Builder> __builders) {
      defaultFilters = __builders;
      return this;
    }

    public Builder strictFiltering(boolean __value) {
      strictFiltering = __value;
      return this;
    }

    private Builder strictFiltering(String __value) {
      return strictFiltering(Boolean.valueOf(__value));
    }

    public Builder maxWorkerThreads(int __value) {
      maxWorkerThreads = __value;
      return this;
    }

    private Builder maxWorkerThreads(String __value) {
      return maxWorkerThreads(Integer.valueOf(__value));
    }

    public Builder minWorkerThreads(int __value) {
      minWorkerThreads = __value;
      return this;
    }

    private Builder minWorkerThreads(String __value) {
      return minWorkerThreads(Integer.valueOf(__value));
    }

    public Builder stopTimeout(double __value) {
      stopTimeout = __value;
      return this;
    }

    private Builder stopTimeout(String __value) {
      return stopTimeout(Double.valueOf(__value));
    }

    public Builder jmx(Jmx.Builder __builder) {
      jmx = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder jmx(java.util.function.Consumer<Jmx.Builder> __func) {
      Jmx.Builder __inner = new Jmx.Builder();
      __func.accept(__inner);
      jmx = __inner;
      return this;
    }

    public Builder metric(Metric.Builder __builder) {
      metric = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder metric(java.util.function.Consumer<Metric.Builder> __func) {
      Metric.Builder __inner = new Metric.Builder();
      __func.accept(__inner);
      metric = __inner;
      return this;
    }

    public Builder connectionLog(ConnectionLog.Builder __builder) {
      connectionLog = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder connectionLog(java.util.function.Consumer<ConnectionLog.Builder> __func) {
      ConnectionLog.Builder __inner = new ConnectionLog.Builder();
      __func.accept(__inner);
      connectionLog = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ServerConfig build() {
      return new ServerConfig(this);
    }

  }

  // Whether to enable developer mode, where stack traces etc are visible in response bodies.
  private final BooleanNode developerMode;
  // TODO Vespa 9 Remove
  // Has no effect since Jetty 11 upgrade
  private final IntegerNode responseCompressionLevel;
  // Whether the request body of POSTed forms should be removed (form parameters are available as request parameters).
  private final BooleanNode removeRawPostBodyForWwwUrlEncodedPost;
  private final InnerNodeVector<Filter> filter;
  private final InnerNodeVector<DefaultFilters> defaultFilters;
  // Reject all requests not handled by a request filter (chain)
  private final BooleanNode strictFiltering;
  // Max number of threads in underlying Jetty pool
  // Defaults to 16+vCPU
  private final IntegerNode maxWorkerThreads;
  // Min number of threads in underlying Jetty pool
  // Defaults to 16+vCPU
  private final IntegerNode minWorkerThreads;
  // Stop timeout in seconds. The maximum allowed time to process in-flight requests during server shutdown. Setting it to 0 disable graceful shutdown.
  private final DoubleNode stopTimeout;
  private final Jmx jmx;
  private final Metric metric;
  private final ConnectionLog connectionLog;

  public ServerConfig(Builder builder) {
    this(builder, true);
  }

  private ServerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "server must be initialized: " + builder.__uninitialized);

    developerMode = (builder.developerMode == null) ?
        new BooleanNode(false) : new BooleanNode(builder.developerMode);
    responseCompressionLevel = (builder.responseCompressionLevel == null) ?
        new IntegerNode(6) : new IntegerNode(builder.responseCompressionLevel);
    removeRawPostBodyForWwwUrlEncodedPost = (builder.removeRawPostBodyForWwwUrlEncodedPost == null) ?
        new BooleanNode(false) : new BooleanNode(builder.removeRawPostBodyForWwwUrlEncodedPost);
    filter = Filter.createVector(builder.filter);
    defaultFilters = DefaultFilters.createVector(builder.defaultFilters);
    strictFiltering = (builder.strictFiltering == null) ?
        new BooleanNode(false) : new BooleanNode(builder.strictFiltering);
    maxWorkerThreads = (builder.maxWorkerThreads == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.maxWorkerThreads);
    minWorkerThreads = (builder.minWorkerThreads == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.minWorkerThreads);
    stopTimeout = (builder.stopTimeout == null) ?
        new DoubleNode(30.0D) : new DoubleNode(builder.stopTimeout);
    jmx = new Jmx(builder.jmx, throwIfUninitialized);
    metric = new Metric(builder.metric, throwIfUninitialized);
    connectionLog = new ConnectionLog(builder.connectionLog, throwIfUninitialized);
  }

  /**
   * @return server.developerMode
   */
  public boolean developerMode() {
    return developerMode.value();
  }

  /**
   * @return server.responseCompressionLevel
   */
  public int responseCompressionLevel() {
    return responseCompressionLevel.value();
  }

  /**
   * @return server.removeRawPostBodyForWwwUrlEncodedPost
   */
  public boolean removeRawPostBodyForWwwUrlEncodedPost() {
    return removeRawPostBodyForWwwUrlEncodedPost.value();
  }

  /**
   * @return server.filter[]
   */
  public List<Filter> filter() {
    return filter;
  }

  /**
   * @param i the index of the value to return
   * @return server.filter[]
   */
  public Filter filter(int i) {
    return filter.get(i);
  }

  /**
   * @return server.defaultFilters[]
   */
  public List<DefaultFilters> defaultFilters() {
    return defaultFilters;
  }

  /**
   * @param i the index of the value to return
   * @return server.defaultFilters[]
   */
  public DefaultFilters defaultFilters(int i) {
    return defaultFilters.get(i);
  }

  /**
   * @return server.strictFiltering
   */
  public boolean strictFiltering() {
    return strictFiltering.value();
  }

  /**
   * @return server.maxWorkerThreads
   */
  public int maxWorkerThreads() {
    return maxWorkerThreads.value();
  }

  /**
   * @return server.minWorkerThreads
   */
  public int minWorkerThreads() {
    return minWorkerThreads.value();
  }

  /**
   * @return server.stopTimeout
   */
  public double stopTimeout() {
    return stopTimeout.value();
  }

  /**
   * @return server.jmx
   */
  public Jmx jmx() {
    return jmx;
  }

  /**
   * @return server.metric
   */
  public Metric metric() {
    return metric;
  }

  /**
   * @return server.connectionLog
   */
  public ConnectionLog connectionLog() {
    return connectionLog;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ServerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("server");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents server.filter[]
   */
  public final static class Filter extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "binding"
        ));

      private String id = null;
      private String binding = null;

      public Builder() { }

      public Builder(Filter config) {
        id(config.id());
        binding(config.binding());
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.binding != null)
          binding(__superior.binding);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder binding(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        binding = __value;
        __uninitialized.remove("binding");
        return this;
      }


      public Filter build() {
        return new Filter(this);
      }

    }

    // The component ID of a filter
    private final StringNode id;
    // The binding of a filter
    private final StringNode binding;

    public Filter(Builder builder) {
      this(builder, true);
    }

    private Filter(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "server.filter[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      binding = (builder.binding == null) ?
          new StringNode() : new StringNode(builder.binding);
    }

    /**
     * @return server.filter[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return server.filter[].binding
     */
    public String binding() {
      return binding.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Filter newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("filter");
      return changes;
    }

    private static InnerNodeVector<Filter> createVector(List<Builder> builders) {
        List<Filter> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Filter(b));
        }
        return new InnerNodeVector<Filter>(elems);
    }
  }

  /**
   * This class represents server.defaultFilters[]
   */
  public final static class DefaultFilters extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "filterId",
        "localPort"
        ));

      private String filterId = null;
      private Integer localPort = null;

      public Builder() { }

      public Builder(DefaultFilters config) {
        filterId(config.filterId());
        localPort(config.localPort());
      }

      private Builder override(Builder __superior) {
        if (__superior.filterId != null)
          filterId(__superior.filterId);
        if (__superior.localPort != null)
          localPort(__superior.localPort);
        return this;
      }

      public Builder filterId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        filterId = __value;
        __uninitialized.remove("filterId");
        return this;
      }


      public Builder localPort(int __value) {
        localPort = __value;
        __uninitialized.remove("localPort");
        return this;
      }

      private Builder localPort(String __value) {
        return localPort(Integer.valueOf(__value));
      }

      public DefaultFilters build() {
        return new DefaultFilters(this);
      }

    }

    // Filter id for a default filter (chain)
    private final StringNode filterId;
    // The local port which the default filter should be applied to
    private final IntegerNode localPort;

    public DefaultFilters(Builder builder) {
      this(builder, true);
    }

    private DefaultFilters(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "server.defaultFilters[] must be initialized: " + builder.__uninitialized);

      filterId = (builder.filterId == null) ?
          new StringNode() : new StringNode(builder.filterId);
      localPort = (builder.localPort == null) ?
          new IntegerNode() : new IntegerNode(builder.localPort);
    }

    /**
     * @return server.defaultFilters[].filterId
     */
    public String filterId() {
      return filterId.value();
    }

    /**
     * @return server.defaultFilters[].localPort
     */
    public int localPort() {
      return localPort.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DefaultFilters newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("defaultFilters");
      return changes;
    }

    private static InnerNodeVector<DefaultFilters> createVector(List<Builder> builders) {
        List<DefaultFilters> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new DefaultFilters(b));
        }
        return new InnerNodeVector<DefaultFilters>(elems);
    }
  }

  /**
   * This class represents server.jmx
   */
  public final static class Jmx extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean enabled = null;
      private Integer listenPort = null;

      public Builder() { }

      public Builder(Jmx config) {
        enabled(config.enabled());
        listenPort(config.listenPort());
      }

      private Builder override(Builder __superior) {
        if (__superior.enabled != null)
          enabled(__superior.enabled);
        if (__superior.listenPort != null)
          listenPort(__superior.listenPort);
        return this;
      }

      public Builder enabled(boolean __value) {
        enabled = __value;
        return this;
      }

      private Builder enabled(String __value) {
        return enabled(Boolean.valueOf(__value));
      }

      public Builder listenPort(int __value) {
        listenPort = __value;
        return this;
      }

      private Builder listenPort(String __value) {
        return listenPort(Integer.valueOf(__value));
      }

      public Jmx build() {
        return new Jmx(this);
      }

    }

    // Enable embedded JMX server. Note: only accessible through the loopback interface.
    private final BooleanNode enabled;
    // Listen port for the JMX server.
    private final IntegerNode listenPort;

    public Jmx(Builder builder) {
      this(builder, true);
    }

    private Jmx(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "server.jmx must be initialized: " + builder.__uninitialized);

      enabled = (builder.enabled == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enabled);
      listenPort = (builder.listenPort == null) ?
          new IntegerNode(1099) : new IntegerNode(builder.listenPort);
    }

    /**
     * @return server.jmx.enabled
     */
    public boolean enabled() {
      return enabled.value();
    }

    /**
     * @return server.jmx.listenPort
     */
    public int listenPort() {
      return listenPort.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Jmx newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("jmx");
      return changes;
    }
  }

  /**
   * This class represents server.metric
   */
  public final static class Metric extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public List<String> monitoringHandlerPaths = new ArrayList<>();
      public List<String> searchHandlerPaths = new ArrayList<>();
      public List<String> ignoredUserAgents = new ArrayList<>();
      private Boolean reporterEnabled = null;

      public Builder() { }

      public Builder(Metric config) {
        monitoringHandlerPaths(config.monitoringHandlerPaths());
        searchHandlerPaths(config.searchHandlerPaths());
        ignoredUserAgents(config.ignoredUserAgents());
        reporterEnabled(config.reporterEnabled());
      }

      private Builder override(Builder __superior) {
        if (!__superior.monitoringHandlerPaths.isEmpty())
          monitoringHandlerPaths.addAll(__superior.monitoringHandlerPaths);
        if (!__superior.searchHandlerPaths.isEmpty())
          searchHandlerPaths.addAll(__superior.searchHandlerPaths);
        if (!__superior.ignoredUserAgents.isEmpty())
          ignoredUserAgents.addAll(__superior.ignoredUserAgents);
        if (__superior.reporterEnabled != null)
          reporterEnabled(__superior.reporterEnabled);
        return this;
      }

      public Builder monitoringHandlerPaths(String __value) {
        monitoringHandlerPaths.add(__value);
        return this;
      }

      public Builder monitoringHandlerPaths(Collection<String> __values) {
        monitoringHandlerPaths.addAll(__values);
        return this;
      }

      public Builder searchHandlerPaths(String __value) {
        searchHandlerPaths.add(__value);
        return this;
      }

      public Builder searchHandlerPaths(Collection<String> __values) {
        searchHandlerPaths.addAll(__values);
        return this;
      }

      public Builder ignoredUserAgents(String __value) {
        ignoredUserAgents.add(__value);
        return this;
      }

      public Builder ignoredUserAgents(Collection<String> __values) {
        ignoredUserAgents.addAll(__values);
        return this;
      }

      public Builder reporterEnabled(boolean __value) {
        reporterEnabled = __value;
        return this;
      }

      private Builder reporterEnabled(String __value) {
        return reporterEnabled(Boolean.valueOf(__value));
      }

      public Metric build() {
        return new Metric(this);
      }

    }

    // Paths that should be reported with monitoring dimensions where applicable
    private final LeafNodeVector<String, StringNode> monitoringHandlerPaths;
    // Paths that should be reported with search dimensions where applicable
    private final LeafNodeVector<String, StringNode> searchHandlerPaths;
    // User-agent names to ignore wrt statistics (crawlers etc)
    private final LeafNodeVector<String, StringNode> ignoredUserAgents;
    // Whether to enable scheduled metric reporter. Disabled for unit testing to stop metric counters from being reset.
    private final BooleanNode reporterEnabled;

    public Metric(Builder builder) {
      this(builder, true);
    }

    private Metric(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "server.metric must be initialized: " + builder.__uninitialized);

      monitoringHandlerPaths = new LeafNodeVector<>(builder.monitoringHandlerPaths, new StringNode());
      searchHandlerPaths = new LeafNodeVector<>(builder.searchHandlerPaths, new StringNode());
      ignoredUserAgents = new LeafNodeVector<>(builder.ignoredUserAgents, new StringNode());
      reporterEnabled = (builder.reporterEnabled == null) ?
          new BooleanNode(true) : new BooleanNode(builder.reporterEnabled);
    }

    /**
     * @return server.metric.monitoringHandlerPaths[]
     */
    public List<String> monitoringHandlerPaths() {
      return monitoringHandlerPaths.asList();
    }

    /**
     * @param i the index of the value to return
     * @return server.metric.monitoringHandlerPaths[]
     */
    public String monitoringHandlerPaths(int i) {
      return monitoringHandlerPaths.get(i).value();
    }

    /**
     * @return server.metric.searchHandlerPaths[]
     */
    public List<String> searchHandlerPaths() {
      return searchHandlerPaths.asList();
    }

    /**
     * @param i the index of the value to return
     * @return server.metric.searchHandlerPaths[]
     */
    public String searchHandlerPaths(int i) {
      return searchHandlerPaths.get(i).value();
    }

    /**
     * @return server.metric.ignoredUserAgents[]
     */
    public List<String> ignoredUserAgents() {
      return ignoredUserAgents.asList();
    }

    /**
     * @param i the index of the value to return
     * @return server.metric.ignoredUserAgents[]
     */
    public String ignoredUserAgents(int i) {
      return ignoredUserAgents.get(i).value();
    }

    /**
     * @return server.metric.reporterEnabled
     */
    public boolean reporterEnabled() {
      return reporterEnabled.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Metric newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("metric");
      return changes;
    }
  }

  /**
   * This class represents server.connectionLog
   */
  public final static class ConnectionLog extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean enabled = null;

      public Builder() { }

      public Builder(ConnectionLog config) {
        enabled(config.enabled());
      }

      private Builder override(Builder __superior) {
        if (__superior.enabled != null)
          enabled(__superior.enabled);
        return this;
      }

      public Builder enabled(boolean __value) {
        enabled = __value;
        return this;
      }

      private Builder enabled(String __value) {
        return enabled(Boolean.valueOf(__value));
      }

      public ConnectionLog build() {
        return new ConnectionLog(this);
      }

    }

    // Whether to enable jdisc connection log
    private final BooleanNode enabled;

    public ConnectionLog(Builder builder) {
      this(builder, true);
    }

    private ConnectionLog(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "server.connectionLog must be initialized: " + builder.__uninitialized);

      enabled = (builder.enabled == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enabled);
    }

    /**
     * @return server.connectionLog.enabled
     */
    public boolean enabled() {
      return enabled.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ConnectionLog newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("connectionLog");
      return changes;
    }
  }

}
