// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.di.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of platform-bundles
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class PlatformBundlesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "287bb4abc37b528e699c08d343fccf82";
  public final static String CONFIG_DEF_NAME = "platform-bundles";
  public final static String CONFIG_DEF_NAMESPACE = "com.yahoo.container.di.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=com.yahoo.container.di.config",
    "bundlePaths[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<String> bundlePaths = new ArrayList<>();

    public Builder() { }

    public Builder(PlatformBundlesConfig config) {
      bundlePaths(config.bundlePaths());
    }

    private Builder override(Builder __superior) {
      if (!__superior.bundlePaths.isEmpty())
        bundlePaths.addAll(__superior.bundlePaths);
      return this;
    }

    public Builder bundlePaths(String __value) {
      bundlePaths.add(__value);
      return this;
    }

    public Builder bundlePaths(Collection<String> __values) {
      bundlePaths.addAll(__values);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public PlatformBundlesConfig build() {
      return new PlatformBundlesConfig(this);
    }

  }

  // Paths to platform bundles to install.
  private final LeafNodeVector<String, StringNode> bundlePaths;

  public PlatformBundlesConfig(Builder builder) {
    this(builder, true);
  }

  private PlatformBundlesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "platform-bundles must be initialized: " + builder.__uninitialized);

    bundlePaths = new LeafNodeVector<>(builder.bundlePaths, new StringNode());
  }

  /**
   * @return platform-bundles.bundlePaths[]
   */
  public List<String> bundlePaths() {
    return bundlePaths.asList();
  }

  /**
   * @param i the index of the value to return
   * @return platform-bundles.bundlePaths[]
   */
  public String bundlePaths(int i) {
    return bundlePaths.get(i).value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(PlatformBundlesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("platform-bundles");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
