// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.di.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of application-bundles
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ApplicationBundlesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c821e88e65f4c27dec15ba6d7801243a";
  public final static String CONFIG_DEF_NAME = "application-bundles";
  public final static String CONFIG_DEF_NAMESPACE = "com.yahoo.container.di.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=com.yahoo.container.di.config",
    "bundles[] file"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<String> bundles = new ArrayList<>();

    public Builder() { }

    public Builder(ApplicationBundlesConfig config) {
      bundles(FileReference.toValues(config.bundles()));
    }

    private Builder override(Builder __superior) {
      if (!__superior.bundles.isEmpty())
        bundles.addAll(__superior.bundles);
      return this;
    }

    public Builder bundles(String __value) {
      bundles.add(__value);
      return this;
    }

    public Builder bundles(Collection<String> __values) {
      bundles.addAll(__values);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ApplicationBundlesConfig build() {
      return new ApplicationBundlesConfig(this);
    }

  }

  // References to user bundles to install.
  private final LeafNodeVector<FileReference, FileNode> bundles;

  public ApplicationBundlesConfig(Builder builder) {
    this(builder, true);
  }

  private ApplicationBundlesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "application-bundles must be initialized: " + builder.__uninitialized);

    bundles = LeafNodeVector.createFileNodeVector(builder.bundles);
  }

  /**
   * @return application-bundles.bundles[]
   */
  public List<FileReference> bundles() {
    return bundles.asList();
  }

  /**
   * @param i the index of the value to return
   * @return application-bundles.bundles[]
   */
  public FileReference bundles(int i) {
    return bundles.get(i).value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ApplicationBundlesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("application-bundles");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
