// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of vip-status
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class VipStatusConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "e0fdf238d9d15d49d1fa9b145b35c674";
  public final static String CONFIG_DEF_NAME = "vip-status";
  public final static String CONFIG_DEF_NAMESPACE = "container.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.core",
    "accessdisk bool default=false",
    "statusfile string default=\"share/qrsdocs/status.html\"",
    "initiallyInRotation bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean accessdisk = null;
    private String statusfile = null;
    private Boolean initiallyInRotation = null;

    public Builder() { }

    public Builder(VipStatusConfig config) {
      accessdisk(config.accessdisk());
      statusfile(config.statusfile());
      initiallyInRotation(config.initiallyInRotation());
    }

    private Builder override(Builder __superior) {
      if (__superior.accessdisk != null)
        accessdisk(__superior.accessdisk);
      if (__superior.statusfile != null)
        statusfile(__superior.statusfile);
      if (__superior.initiallyInRotation != null)
        initiallyInRotation(__superior.initiallyInRotation);
      return this;
    }

    public Builder accessdisk(boolean __value) {
      accessdisk = __value;
      return this;
    }

    private Builder accessdisk(String __value) {
      return accessdisk(Boolean.valueOf(__value));
    }

    public Builder statusfile(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      statusfile = __value;
      return this;
    }


    public Builder initiallyInRotation(boolean __value) {
      initiallyInRotation = __value;
      return this;
    }

    private Builder initiallyInRotation(String __value) {
      return initiallyInRotation(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public VipStatusConfig build() {
      return new VipStatusConfig(this);
    }

  }

  // Whether to return hard-coded reply or serve "status.html" from disk
  private final BooleanNode accessdisk;
  // The file to serve as the status file.
  // If the path is relative vespa home is prepended
  private final StringNode statusfile;
  // Whether this container should be in rotation by default on startup
  private final BooleanNode initiallyInRotation;

  public VipStatusConfig(Builder builder) {
    this(builder, true);
  }

  private VipStatusConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "vip-status must be initialized: " + builder.__uninitialized);

    accessdisk = (builder.accessdisk == null) ?
        new BooleanNode(false) : new BooleanNode(builder.accessdisk);
    statusfile = (builder.statusfile == null) ?
        new StringNode("share/qrsdocs/status.html") : new StringNode(builder.statusfile);
    initiallyInRotation = (builder.initiallyInRotation == null) ?
        new BooleanNode(true) : new BooleanNode(builder.initiallyInRotation);
  }

  /**
   * @return vip-status.accessdisk
   */
  public boolean accessdisk() {
    return accessdisk.value();
  }

  /**
   * @return vip-status.statusfile
   */
  public String statusfile() {
    return statusfile.value();
  }

  /**
   * @return vip-status.initiallyInRotation
   */
  public boolean initiallyInRotation() {
    return initiallyInRotation.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(VipStatusConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("vip-status");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
