/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.metrics;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.handler.metrics.MetricsProxyApiConfig;
import com.yahoo.container.handler.metrics.MetricsV2Handler;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import com.yahoo.restapi.StringResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class PrometheusV1Handler
extends HttpHandlerBase {
    public static final String V1_PATH = "/prometheus/v1";
    static final String VALUES_PATH = "/prometheus/v1/values";
    private static final int HTTP_CONNECT_TIMEOUT = 5000;
    private static final int HTTP_SOCKET_TIMEOUT = 30000;
    private final String metricsProxyUri;
    private final CloseableHttpClient httpClient = PrometheusV1Handler.createHttpClient();

    @Inject
    public PrometheusV1Handler(Executor executor, MetricsProxyApiConfig config) {
        super(executor);
        this.metricsProxyUri = "http://localhost:" + config.metricsPort() + config.prometheusApiPath();
    }

    @Override
    protected Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V1_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.valuesResponse(consumer));
        }
        return Optional.empty();
    }

    private HttpResponse valuesResponse(String consumer) {
        try {
            String uri = this.metricsProxyUri + MetricsV2Handler.consumerQuery(consumer);
            String prometheusText = (String)this.httpClient.execute((ClassicHttpRequest)new HttpGet(uri), (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            return new StringResponse(prometheusText);
        }
        catch (IOException e) {
            this.log.warning("Unable to retrieve metrics from " + this.metricsProxyUri + ": " + Exceptions.toMessageString((Throwable)e));
            return new ErrorResponse(500, e.getMessage());
        }
    }

    private static CloseableHttpClient createHttpClient() {
        return VespaHttpClientBuilder.custom().connectTimeout(5000L, TimeUnit.MILLISECONDS).apacheBuilder().setUserAgent("application-prometheus-receiver").setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(30000L, TimeUnit.MILLISECONDS).build()).build();
    }

    public void destroy() {
        super.destroy();
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, "Failed closing http client", e);
        }
    }
}

