/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class BundleStarter {
    private BundleStarter() {
    }

    static void startBundles(Collection<Bundle> bundles) {
        for (Bundle bundle : bundles) {
            try {
                if (BundleStarter.isFragment(bundle)) continue;
                bundle.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not start bundle '" + bundle.getSymbolicName() + "'", e);
            }
        }
    }

    private static boolean isFragment(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundleRevision == null) {
            throw new NullPointerException("Null bundle revision means that bundle has probably been uninstalled: " + bundle.getSymbolicName() + ":" + String.valueOf(bundle.getVersion()));
        }
        return (bundleRevision.getTypes() & 1) != 0;
    }
}

