/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.api.annotations.Beta;
import com.yahoo.metrics.simple.Identifier;
import com.yahoo.metrics.simple.Measurement;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.Point;
import com.yahoo.metrics.simple.PointBuilder;
import com.yahoo.metrics.simple.Sample;
import com.yahoo.metrics.simple.UntypedMetric;

@Beta
public class Counter {
    private final Point defaultPosition;
    private final String name;
    private final MetricReceiver metricReceiver;

    Counter(String name, Point defaultPosition, MetricReceiver receiver) {
        this.name = name;
        this.defaultPosition = defaultPosition;
        this.metricReceiver = receiver;
    }

    public void add() {
        this.add(1L, this.defaultPosition);
    }

    public void add(long n) {
        this.add(n, this.defaultPosition);
    }

    public void add(Point p) {
        this.add(1L, p);
    }

    public void add(long n, Point p) {
        this.metricReceiver.update(new Sample(new Measurement(n), new Identifier(this.name, p), UntypedMetric.AssumedType.COUNTER));
    }

    public PointBuilder builder() {
        return new PointBuilder(this.defaultPosition);
    }
}

