/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.NoopSharedResource;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.FastContentWriter;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.server.jetty.FilterBindings;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.eclipse.jetty.server.Request;

class FilterResolver {
    private final FilterBindings bindings;

    FilterResolver(FilterBindings bindings) {
        this.bindings = bindings;
    }

    Optional<RequestFilter> resolveRequestFilter(Request request, URI jdiscUri) {
        Optional<String> maybeFilterId = this.bindings.resolveRequestFilter(jdiscUri, RequestUtils.getConnector(request).listenPort());
        if (maybeFilterId.isPresent()) {
            request.setAttribute("jdisc.request.chain", (Object)maybeFilterId.get());
        } else if (this.bindings.strictFiltering()) {
            String syntheticFilterId = "strict-reject";
            request.setAttribute("jdisc.request.chain", (Object)syntheticFilterId);
            return Optional.of(RejectingRequestFilter.INSTANCE);
        }
        return maybeFilterId.map(this.bindings::getRequestFilter);
    }

    Optional<ResponseFilter> resolveResponseFilter(Request request, URI jdiscUri) {
        Optional<String> maybeFilterId = this.bindings.resolveResponseFilter(jdiscUri, RequestUtils.getConnector(request).listenPort());
        maybeFilterId.ifPresent(s -> request.setAttribute("jdisc.response.chain", s));
        return maybeFilterId.map(this.bindings::getResponseFilter);
    }

    private static class RejectingRequestFilter
    extends NoopSharedResource
    implements RequestFilter {
        private static final RejectingRequestFilter INSTANCE = new RejectingRequestFilter();
        private static final String SYNTHETIC_FILTER_CHAIN_ID = "strict-reject";

        private RejectingRequestFilter() {
        }

        @Override
        public void filter(HttpRequest request, ResponseHandler handler) {
            Response response = new Response(403);
            response.headers().add("Content-Type", "text/plain");
            try (FastContentWriter writer = ResponseDispatch.newInstance((Response)response, (ByteBuffer[])new ByteBuffer[0]).connectFastWriter(handler);){
                writer.write("Request did not match any request filter chain");
            }
        }
    }
}

