/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.yahoo.container.handler.threadpool.ThreadPoolMetric;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class WorkerCompletionTimingThreadPoolExecutor
extends ThreadPoolExecutor {
    volatile long lastThreadAssignmentTimeMillis = System.currentTimeMillis();
    private final AtomicLong startedCount = new AtomicLong(0L);
    private final AtomicLong completedCount = new AtomicLong(0L);
    private final ThreadPoolMetric metric;

    WorkerCompletionTimingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, ThreadPoolMetric metric) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.metric = metric;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.lastThreadAssignmentTimeMillis = System.currentTimeMillis();
        this.startedCount.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.completedCount.incrementAndGet();
        if (t != null) {
            this.metric.reportUnhandledException(t);
        }
    }

    @Override
    public int getActiveCount() {
        return (int)(this.startedCount.get() - this.completedCount.get());
    }
}

