/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.BuilderGenerator;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.CodegenRuntimeException;
import com.yahoo.config.codegen.ConfiggenUtil;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.LeafCNode;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.stream.Collectors;

public class ConfigGenerator {
    public static String generateContent(String indent, InnerCNode node, boolean isOuter) {
        CNode[] children = node.getChildren();
        return ConfigGenerator.indentCode(indent, BuilderGenerator.getBuilder(node) + "\n\n" + Arrays.stream(children).map(ConfigGenerator::getFieldDefinition).collect(Collectors.joining("\n")) + "\n\n" + ConfigGenerator.getConstructors(node) + "\n\n" + ConfigGenerator.getAccessors(children) + "\n\n" + ConfigGenerator.getGetChangesRequiringRestart(node) + "\n\n" + ConfigGenerator.getContainsFieldsFlaggedWithRestart(node, isOuter) + ConfigGenerator.getStaticMethods(node) + ConfigGenerator.generateCodeForChildren(children, indent));
    }

    private static String generateCodeForChildren(CNode[] children, String indent) {
        LinkedList<CallSite> pieces = new LinkedList<CallSite>();
        for (CNode child : children) {
            if (child instanceof LeafCNode.EnumLeaf) {
                pieces.add((CallSite)((Object)(ConfigGenerator.getEnumCode((LeafCNode.EnumLeaf)child) + "\n")));
                continue;
            }
            if (!(child instanceof InnerCNode)) continue;
            pieces.add((CallSite)((Object)(ConfigGenerator.getInnerDefinition((InnerCNode)child, indent) + "\n")));
        }
        return String.join((CharSequence)"\n", pieces);
    }

    private static String getInnerDefinition(InnerCNode inner, String indent) {
        return (ConfigGenerator.getClassDoc(inner) + "\n" + ConfigGenerator.getClassDeclaration(inner) + "\n" + ConfigGenerator.generateContent(indent, inner, false)).trim() + "\n}";
    }

    private static String getClassDeclaration(CNode node) {
        return "public final static class " + ConfigGenerator.nodeClass(node) + " extends InnerNode { \n";
    }

    private static String getFieldDefinition(CNode node) {
        String fieldDef = node instanceof LeafCNode && node.isArray ? String.format("LeafNodeVector<%s, %s> %s;", ConfigGenerator.boxedDataType(node), ConfigGenerator.nodeClass(node), node.getName()) : (node instanceof InnerCNode && node.isArray ? String.format("InnerNodeVector<%s> %s;", ConfigGenerator.nodeClass(node), node.getName()) : (node.isMap ? String.format("Map<String, %s> %s;", ConfigGenerator.nodeClass(node), node.getName()) : String.format("%s %s;", ConfigGenerator.nodeClass(node), node.getName())));
        return node.getCommentBlock("//") + "private final " + fieldDef;
    }

    private static String getStaticMethods(InnerCNode node) {
        if (node.isArray) {
            return ConfigGenerator.getStaticMethodsForInnerArray(node) + "\n\n";
        }
        if (node.isMap) {
            return ConfigGenerator.getStaticMethodsForInnerMap(node) + "\n\n";
        }
        return "";
    }

    private static String getContainsFieldsFlaggedWithRestart(CNode node, boolean isOuter) {
        if (isOuter) {
            return String.format("private static boolean containsFieldsFlaggedWithRestart() {\n  return %b;\n}\n\n", node.needRestart());
        }
        return "";
    }

    private static String getGetChangesRequiringRestart(InnerCNode node) {
        LinkedList<CallSite> comparisons = new LinkedList<CallSite>();
        for (CNode child : node.getChildren()) {
            if (!child.needRestart()) continue;
            comparisons.add((CallSite)((Object)("\n  " + ConfigGenerator.getComparison(child))));
        }
        return "private ChangesRequiringRestart getChangesRequiringRestart(" + ConfigGenerator.nodeClass(node) + " newConfig) {\n  ChangesRequiringRestart changes = new ChangesRequiringRestart(\"" + node.getName() + "\");" + String.join((CharSequence)"", comparisons) + "\n  return changes;\n}";
    }

    private static String quotedComment(CNode node) {
        return node.getComment().replace("\n", "\\n").replace("\"", "\\\"");
    }

    private static String getComparison(CNode node) {
        if (node instanceof InnerCNode && node.isArray) {
            return "  changes.compareArray(this." + node.getName() + ", newConfig." + node.getName() + ", \"" + node.getName() + "\", \"" + ConfigGenerator.quotedComment(node) + "\",\n                      (a,b) -> ((" + ConfigGenerator.nodeClass(node) + ")a).getChangesRequiringRestart((" + ConfigGenerator.nodeClass(node) + ")b));";
        }
        if (node instanceof InnerCNode && node.isMap) {
            return "  changes.compareMap(this." + node.getName() + ", newConfig." + node.getName() + ", \"" + node.getName() + "\", \"" + ConfigGenerator.quotedComment(node) + "\",\n                    (a,b) -> ((" + ConfigGenerator.nodeClass(node) + ")a).getChangesRequiringRestart((" + ConfigGenerator.nodeClass(node) + ")b));";
        }
        if (node instanceof InnerCNode) {
            return "  changes.mergeChanges(\"" + node.getName() + "\", this." + node.getName() + ".getChangesRequiringRestart(newConfig." + node.getName() + "));";
        }
        if (node.isArray) {
            return "  changes.compareArray(this." + node.getName() + ", newConfig." + node.getName() + ", \"" + node.getName() + "\", \"" + ConfigGenerator.quotedComment(node) + "\",\n                      (a,b) -> new ChangesRequiringRestart(\"" + node.getName() + "\").compare(a,b,\"\",\"" + ConfigGenerator.quotedComment(node) + "\"));";
        }
        if (node.isMap) {
            return "  changes.compareMap(this." + node.getName() + ", newConfig." + node.getName() + ", \"" + node.getName() + "\", \"" + ConfigGenerator.quotedComment(node) + "\",\n                    (a,b) -> new ChangesRequiringRestart(\"" + node.getName() + "\").compare(a,b,\"\",\"" + ConfigGenerator.quotedComment(node) + "\"));";
        }
        return "  changes.compare(this." + node.getName() + ", newConfig." + node.getName() + ", \"" + node.getName() + "\", \"" + ConfigGenerator.quotedComment(node) + "\");";
    }

    private static String scalarDefault(LeafCNode scalar) {
        if (scalar.getDefaultValue() == null) {
            return "";
        }
        if (scalar instanceof LeafCNode.EnumLeaf && scalar.getDefaultValue().getValue() == null) {
            return "";
        }
        if (scalar instanceof LeafCNode.EnumLeaf) {
            return ConfigGenerator.nodeClass(scalar) + "." + scalar.getDefaultValue().getStringRepresentation();
        }
        if (scalar instanceof LeafCNode.LongLeaf) {
            return scalar.getDefaultValue().getStringRepresentation() + "L";
        }
        if (scalar instanceof LeafCNode.DoubleLeaf) {
            return scalar.getDefaultValue().getStringRepresentation() + "D";
        }
        return scalar.getDefaultValue().getStringRepresentation();
    }

    private static String assignFromBuilder(CNode child) {
        String name = child.getName();
        String className = ConfigGenerator.nodeClass(child);
        boolean isArray = child.isArray;
        boolean isMap = child.isMap;
        if (child instanceof LeafCNode.FileLeaf && isArray) {
            return name + " = LeafNodeVector.createFileNodeVector(builder." + name + ");";
        }
        if (child instanceof LeafCNode.PathLeaf && isArray) {
            return name + " = LeafNodeVector.createPathNodeVector(builder." + name + ");";
        }
        if (child instanceof LeafCNode.OptionalPathLeaf && isArray) {
            return name + " = LeafNodeVector.createOptionalPathNodeVector(builder." + name + ");";
        }
        if (child instanceof LeafCNode.UrlLeaf && isArray) {
            return name + " = LeafNodeVector.createUrlNodeVector(builder." + name + ");";
        }
        if (child instanceof LeafCNode.ModelLeaf && isArray) {
            return name + " = LeafNodeVector.createModelNodeVector(builder." + name + ");";
        }
        if (child instanceof LeafCNode && isArray) {
            return name + " = new LeafNodeVector<>(builder." + name + ", new " + className + "());";
        }
        if (child instanceof LeafCNode.FileLeaf && isMap) {
            return name + " = LeafNodeMaps.asFileNodeMap(builder." + name + ");";
        }
        if (child instanceof LeafCNode.PathLeaf && isMap) {
            return name + " = LeafNodeMaps.asPathNodeMap(builder." + name + ");";
        }
        if (child instanceof LeafCNode.OptionalPathLeaf && isMap) {
            return name + " = LeafNodeMaps.asOptionalPathNodeMap(builder." + name + ");";
        }
        if (child instanceof LeafCNode.UrlLeaf && isMap) {
            return name + " = LeafNodeMaps.asUrlNodeMap(builder." + name + ");";
        }
        if (child instanceof LeafCNode.ModelLeaf && isMap) {
            return name + " = LeafNodeMaps.asModelNodeMap(builder." + name + ");";
        }
        if (child instanceof LeafCNode && isMap) {
            return name + " = LeafNodeMaps.asNodeMap(builder." + name + ", new " + className + "());";
        }
        if (child instanceof InnerCNode && isArray) {
            return name + " = " + className + ".createVector(builder." + name + ");";
        }
        if (child instanceof InnerCNode && isMap) {
            return name + " = " + className + ".createMap(builder." + name + ");";
        }
        if (child instanceof InnerCNode) {
            return name + " = new " + className + "(builder." + name + ", throwIfUninitialized);";
        }
        if (child instanceof LeafCNode) {
            return name + " = (builder." + name + " == null) ?\n    new " + className + "(" + ConfigGenerator.scalarDefault((LeafCNode)child) + ") : new " + className + "(builder." + name + ");";
        }
        throw new IllegalStateException("Cannot create assignment for node");
    }

    private static String getConstructors(InnerCNode inner) {
        return "public " + ConfigGenerator.nodeClass(inner) + "(Builder builder) {\n  this(builder, true);\n}\n\nprivate " + ConfigGenerator.nodeClass(inner) + "(Builder builder, boolean throwIfUninitialized) {\n  if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())\n    throw new IllegalArgumentException(\"The following builder parameters for \" +\n        \"" + inner.getFullName() + " must be initialized: \" + builder.__uninitialized);\n\n" + ConfigGenerator.indentCode("  ", Arrays.stream(inner.getChildren()).map(ConfigGenerator::assignFromBuilder).collect(Collectors.joining("\n"))) + "\n}";
    }

    private static String getAccessorCode(CNode node) {
        if (node.isArray) {
            return ConfigGenerator.accessorsForArray(node);
        }
        if (node.isMap) {
            return ConfigGenerator.accessorsForMap(node);
        }
        if (node instanceof LeafCNode.ModelLeaf) {
            return ConfigGenerator.accessorForModel(node);
        }
        return ConfigGenerator.accessorForStructOrScalar(node);
    }

    private static String valueAccessor(CNode node) {
        if (node instanceof LeafCNode) {
            return ".value()";
        }
        return "";
    }

    private static String listAccessor(CNode node) {
        if (node instanceof LeafCNode) {
            return node.getName() + ".asList()";
        }
        return node.getName();
    }

    private static String mapAccessor(CNode node) {
        if (node instanceof LeafCNode) {
            return "LeafNodeMaps.asValueMap(" + node.getName() + ")";
        }
        return "Collections.unmodifiableMap(" + node.getName() + ")";
    }

    private static String accessorsForArray(CNode node) {
        String name = node.getName();
        String fullName = node.getFullName();
        return "/**\n * @return " + fullName + "\n */\npublic List<" + ConfigGenerator.boxedDataType(node) + "> " + name + "() {\n  return " + ConfigGenerator.listAccessor(node) + ";\n}\n\n/**\n * @param i the index of the value to return\n * @return " + fullName + "\n */\npublic " + ConfigGenerator.userDataType(node) + " " + name + "(int i) {\n  return " + name + ".get(i)" + ConfigGenerator.valueAccessor(node) + ";\n}";
    }

    private static String accessorsForMap(CNode node) {
        String name = node.getName();
        String fullName = node.getFullName();
        return "/**\n * @return " + fullName + "\n */\npublic Map<String, " + ConfigGenerator.boxedDataType(node) + "> " + name + "() {\n  return " + ConfigGenerator.mapAccessor(node) + ";\n}\n\n/**\n * @param key the key of the value to return\n * @return " + fullName + "\n */\npublic " + ConfigGenerator.userDataType(node) + " " + name + "(String key) {\n  return " + name + ".get(key)" + ConfigGenerator.valueAccessor(node) + ";\n}";
    }

    private static String accessorForStructOrScalar(CNode node) {
        return "/**\n * @return " + node.getFullName() + "\n */\npublic " + ConfigGenerator.userDataType(node) + " " + node.getName() + "() {\n  return " + node.getName() + ConfigGenerator.valueAccessor(node) + ";\n}";
    }

    private static String accessorForModel(CNode node) {
        String scalarAccessor = ConfigGenerator.accessorForStructOrScalar(node);
        return scalarAccessor + "\n\n/**\n * @return " + node.getFullName() + " ModelReference\n */\npublic ModelReference " + node.getName() + "Reference() {\n  return " + node.getName() + ".getModelReference();\n}";
    }

    private static String getAccessors(CNode[] children) {
        LinkedList<String> accessors = new LinkedList<String>();
        for (CNode child : children) {
            String accessor = ConfigGenerator.getAccessorCode(child);
            if (accessor.isEmpty()) continue;
            accessors.add(accessor);
        }
        return String.join((CharSequence)"\n\n", accessors);
    }

    private static String getStaticMethodsForInnerArray(InnerCNode inner) {
        String nc = ConfigGenerator.nodeClass(inner);
        return String.format("private static InnerNodeVector<%s> createVector(List<Builder> builders) {\n    List<%s> elems = new ArrayList<>();\n    for (Builder b : builders) {\n        elems.add(new %s(b));\n    }\n    return new InnerNodeVector<%s>(elems);\n}", nc, nc, nc, nc);
    }

    private static String getStaticMethodsForInnerMap(InnerCNode inner) {
        String nc = ConfigGenerator.nodeClass(inner);
        return String.format("private static Map<String, %s> createMap(Map<String, Builder> builders) {\n  Map<String, %s> ret = new LinkedHashMap<>();\n  for(String key : builders.keySet()) {\n    ret.put(key, new %s(builders.get(key)));\n  }\n  return Collections.unmodifiableMap(ret);\n}", nc, nc, nc);
    }

    private static String getEnumCode(LeafCNode.EnumLeaf en) {
        String enumValues = Arrays.stream(en.getLegalValues()).map(e -> String.format("  public final static Enum %s = Enum.%s;", e, e)).collect(Collectors.joining("\n"));
        String code = String.format("%s\npublic final static class %s extends EnumNode<%s> {\n\n  public %s(){\n    this.value = null;\n  }\n\n  public %s(Enum enumValue) {\n    super(enumValue != null);\n    this.value = enumValue;\n  }\n\n  public enum Enum {%s}\n%s\n\n  @Override\n  protected boolean doSetValue(String name) {\n    try {\n      value = Enum.valueOf(name);\n      return true;\n    } catch (IllegalArgumentException e) {\n    }\n    return false;\n  }\n}", ConfigGenerator.getClassDoc(en), ConfigGenerator.nodeClass(en), ConfigGenerator.nodeClass(en) + ".Enum", ConfigGenerator.nodeClass(en), ConfigGenerator.nodeClass(en), String.join((CharSequence)", ", en.getLegalValues()), enumValues);
        return ConfigGenerator.indentCode("", code);
    }

    private static String getClassDoc(CNode node) {
        String header = "/**\n * This class represents " + node.getFullName();
        String nodeComment = node.getCommentBlock(" *");
        if (nodeComment.isEmpty()) {
            return header + "\n */";
        }
        if (nodeComment.endsWith("\n")) {
            nodeComment = nodeComment.substring(0, nodeComment.length() - 1);
        }
        return header + "\n * \n" + nodeComment + "\n */";
    }

    static String indentCode(String indent, String code) {
        LinkedList<Object> indented = new LinkedList<Object>();
        for (String line : code.split("\n", -1)) {
            indented.add(line.length() > 0 ? indent + line : line);
        }
        return String.join((CharSequence)"\n", indented);
    }

    static String nodeClass(CNode node) {
        if (node.getName().length() == 0) {
            throw new CodegenRuntimeException("Node with empty name, under parent " + node.getParent().getName());
        }
        if (node instanceof InnerCNode && node.getParent() == null) {
            return ConfiggenUtil.createClassName(node.getName());
        }
        if (node instanceof LeafCNode.BooleanLeaf) {
            return "BooleanNode";
        }
        if (node instanceof LeafCNode.DoubleLeaf) {
            return "DoubleNode";
        }
        if (node instanceof LeafCNode.FileLeaf) {
            return "FileNode";
        }
        if (node instanceof LeafCNode.PathLeaf) {
            return "PathNode";
        }
        if (node instanceof LeafCNode.OptionalPathLeaf) {
            return "OptionalPathNode";
        }
        if (node instanceof LeafCNode.UrlLeaf) {
            return "UrlNode";
        }
        if (node instanceof LeafCNode.ModelLeaf) {
            return "ModelNode";
        }
        if (node instanceof LeafCNode.IntegerLeaf) {
            return "IntegerNode";
        }
        if (node instanceof LeafCNode.LongLeaf) {
            return "LongNode";
        }
        if (node instanceof LeafCNode.ReferenceLeaf) {
            return "ReferenceNode";
        }
        if (node instanceof LeafCNode.StringLeaf) {
            return "StringNode";
        }
        return ConfiggenUtil.capitalize(node.getName());
    }

    static String userDataType(CNode node) {
        if (node instanceof InnerCNode) {
            return ConfigGenerator.nodeClass(node);
        }
        if (node instanceof LeafCNode.EnumLeaf) {
            return ConfigGenerator.nodeClass(node) + ".Enum";
        }
        if (node instanceof LeafCNode.BooleanLeaf) {
            return "boolean";
        }
        if (node instanceof LeafCNode.DoubleLeaf) {
            return "double";
        }
        if (node instanceof LeafCNode.FileLeaf) {
            return "FileReference";
        }
        if (node instanceof LeafCNode.PathLeaf) {
            return "Path";
        }
        if (node instanceof LeafCNode.OptionalPathLeaf) {
            return "Optional<Path>";
        }
        if (node instanceof LeafCNode.UrlLeaf) {
            return "File";
        }
        if (node instanceof LeafCNode.ModelLeaf) {
            return "Path";
        }
        if (node instanceof LeafCNode.IntegerLeaf) {
            return "int";
        }
        if (node instanceof LeafCNode.LongLeaf) {
            return "long";
        }
        if (node instanceof LeafCNode.StringLeaf) {
            return "String";
        }
        throw new IllegalStateException("Cannot determine user data type for node '" + String.valueOf(node) + "'");
    }

    static String boxedDataType(CNode node) {
        String rawType = ConfigGenerator.userDataType(node);
        if ("int".equals(rawType)) {
            return "Integer";
        }
        if (rawType.toLowerCase().equals(rawType)) {
            return ConfiggenUtil.capitalize(rawType);
        }
        if (rawType.startsWith("Optional<")) {
            return "Optional";
        }
        return rawType;
    }
}

