/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.evaluator.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.OptionalPathNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public final class OnnxEvaluatorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "938335ae1a1c38e48b4d78f7770f6fc9";
    public static final String CONFIG_DEF_NAME = "onnx-evaluator";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.modelintegration.evaluator.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.modelintegration.evaluator.config", "executionMode enum { parallel, sequential } default=sequential", "interOpThreads int default=1", "intraOpThreads int default=-4", "gpuDevice int default=0", "batching.maxSize int default=1", "batching.maxDelayMillis long default=0", "concurrency.factorType enum { absolute, relative } default=absolute", "concurrency.factor double default=1.0", "modelConfigOverride path optional"};
    private final ExecutionMode executionMode;
    private final IntegerNode interOpThreads;
    private final IntegerNode intraOpThreads;
    private final IntegerNode gpuDevice;
    private final Batching batching;
    private final Concurrency concurrency;
    private final OptionalPathNode modelConfigOverride;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public OnnxEvaluatorConfig(Builder builder) {
        this(builder, true);
    }

    private OnnxEvaluatorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for onnx-evaluator must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.executionMode = builder.executionMode == null ? new ExecutionMode(ExecutionMode.sequential) : new ExecutionMode(builder.executionMode);
        this.interOpThreads = builder.interOpThreads == null ? new IntegerNode(1) : new IntegerNode(builder.interOpThreads.intValue());
        this.intraOpThreads = builder.intraOpThreads == null ? new IntegerNode(-4) : new IntegerNode(builder.intraOpThreads.intValue());
        this.gpuDevice = builder.gpuDevice == null ? new IntegerNode(0) : new IntegerNode(builder.gpuDevice.intValue());
        this.batching = new Batching(builder.batching, throwIfUninitialized);
        this.concurrency = new Concurrency(builder.concurrency, throwIfUninitialized);
        this.modelConfigOverride = builder.modelConfigOverride == null ? new OptionalPathNode() : new OptionalPathNode(builder.modelConfigOverride);
    }

    public ExecutionMode.Enum executionMode() {
        return (ExecutionMode.Enum)((Object)this.executionMode.value());
    }

    public int interOpThreads() {
        return this.interOpThreads.value();
    }

    public int intraOpThreads() {
        return this.intraOpThreads.value();
    }

    public int gpuDevice() {
        return this.gpuDevice.value();
    }

    public Batching batching() {
        return this.batching;
    }

    public Concurrency concurrency() {
        return this.concurrency;
    }

    public Optional<Path> modelConfigOverride() {
        return this.modelConfigOverride.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(OnnxEvaluatorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private ExecutionMode.Enum executionMode = null;
        private Integer interOpThreads = null;
        private Integer intraOpThreads = null;
        private Integer gpuDevice = null;
        public Batching.Builder batching = new Batching.Builder();
        public Concurrency.Builder concurrency = new Concurrency.Builder();
        private Optional<FileReference> modelConfigOverride = Optional.empty();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(OnnxEvaluatorConfig config) {
            this.executionMode(config.executionMode());
            this.interOpThreads(config.interOpThreads());
            this.intraOpThreads(config.intraOpThreads());
            this.gpuDevice(config.gpuDevice());
            this.batching(new Batching.Builder(config.batching()));
            this.concurrency(new Concurrency.Builder(config.concurrency()));
            this.modelConfigOverride(config.modelConfigOverride.getFileReference());
        }

        private Builder override(Builder __superior) {
            if (__superior.executionMode != null) {
                this.executionMode(__superior.executionMode);
            }
            if (__superior.interOpThreads != null) {
                this.interOpThreads(__superior.interOpThreads);
            }
            if (__superior.intraOpThreads != null) {
                this.intraOpThreads(__superior.intraOpThreads);
            }
            if (__superior.gpuDevice != null) {
                this.gpuDevice(__superior.gpuDevice);
            }
            this.batching(this.batching.override(__superior.batching));
            this.concurrency(this.concurrency.override(__superior.concurrency));
            if (__superior.modelConfigOverride != null) {
                this.modelConfigOverride(__superior.modelConfigOverride);
            }
            return this;
        }

        public Builder executionMode(ExecutionMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.executionMode = __value;
            return this;
        }

        private Builder executionMode(String __value) {
            return this.executionMode(ExecutionMode.Enum.valueOf(__value));
        }

        public Builder interOpThreads(int __value) {
            this.interOpThreads = __value;
            return this;
        }

        private Builder interOpThreads(String __value) {
            return this.interOpThreads(Integer.valueOf(__value));
        }

        public Builder intraOpThreads(int __value) {
            this.intraOpThreads = __value;
            return this;
        }

        private Builder intraOpThreads(String __value) {
            return this.intraOpThreads(Integer.valueOf(__value));
        }

        public Builder gpuDevice(int __value) {
            this.gpuDevice = __value;
            return this;
        }

        private Builder gpuDevice(String __value) {
            return this.gpuDevice(Integer.valueOf(__value));
        }

        public Builder batching(Batching.Builder __builder) {
            this.batching = __builder;
            return this;
        }

        public Builder batching(Consumer<Batching.Builder> __func) {
            Batching.Builder __inner = new Batching.Builder();
            __func.accept(__inner);
            this.batching = __inner;
            return this;
        }

        public Builder concurrency(Concurrency.Builder __builder) {
            this.concurrency = __builder;
            return this;
        }

        public Builder concurrency(Consumer<Concurrency.Builder> __func) {
            Concurrency.Builder __inner = new Concurrency.Builder();
            __func.accept(__inner);
            this.concurrency = __inner;
            return this;
        }

        public Builder modelConfigOverride(Optional<FileReference> __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.modelConfigOverride = __value;
            this.__uninitialized.remove("modelConfigOverride");
            return this;
        }

        private Builder modelConfigOverride(FileReference __value) {
            return this.modelConfigOverride(Optional.of(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return OnnxEvaluatorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return OnnxEvaluatorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return OnnxEvaluatorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public OnnxEvaluatorConfig build() {
            return new OnnxEvaluatorConfig(this);
        }
    }

    public static final class ExecutionMode
    extends EnumNode<Enum> {
        public static final Enum parallel = Enum.parallel;
        public static final Enum sequential = Enum.sequential;

        public ExecutionMode() {
            this.value = null;
        }

        public ExecutionMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            parallel,
            sequential;

        }
    }

    public static final class Batching
    extends InnerNode {
        private final IntegerNode maxSize;
        private final LongNode maxDelayMillis;

        public Batching(Builder builder) {
            this(builder, true);
        }

        private Batching(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for onnx-evaluator.batching must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.maxSize = builder.maxSize == null ? new IntegerNode(1) : new IntegerNode(builder.maxSize.intValue());
            this.maxDelayMillis = builder.maxDelayMillis == null ? new LongNode(0L) : new LongNode(builder.maxDelayMillis.longValue());
        }

        public int maxSize() {
            return this.maxSize.value();
        }

        public long maxDelayMillis() {
            return this.maxDelayMillis.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Batching newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("batching");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer maxSize = null;
            private Long maxDelayMillis = null;

            public Builder() {
            }

            public Builder(Batching config) {
                this.maxSize(config.maxSize());
                this.maxDelayMillis(config.maxDelayMillis());
            }

            private Builder override(Builder __superior) {
                if (__superior.maxSize != null) {
                    this.maxSize(__superior.maxSize);
                }
                if (__superior.maxDelayMillis != null) {
                    this.maxDelayMillis(__superior.maxDelayMillis);
                }
                return this;
            }

            public Builder maxSize(int __value) {
                this.maxSize = __value;
                return this;
            }

            private Builder maxSize(String __value) {
                return this.maxSize(Integer.valueOf(__value));
            }

            public Builder maxDelayMillis(long __value) {
                this.maxDelayMillis = __value;
                return this;
            }

            private Builder maxDelayMillis(String __value) {
                return this.maxDelayMillis(Long.valueOf(__value));
            }

            public Batching build() {
                return new Batching(this);
            }
        }
    }

    public static final class Concurrency
    extends InnerNode {
        private final FactorType factorType;
        private final DoubleNode factor;

        public Concurrency(Builder builder) {
            this(builder, true);
        }

        private Concurrency(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for onnx-evaluator.concurrency must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.factorType = builder.factorType == null ? new FactorType(FactorType.absolute) : new FactorType(builder.factorType);
            this.factor = builder.factor == null ? new DoubleNode(1.0) : new DoubleNode(builder.factor.doubleValue());
        }

        public FactorType.Enum factorType() {
            return (FactorType.Enum)((Object)this.factorType.value());
        }

        public double factor() {
            return this.factor.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Concurrency newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("concurrency");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private FactorType.Enum factorType = null;
            private Double factor = null;

            public Builder() {
            }

            public Builder(Concurrency config) {
                this.factorType(config.factorType());
                this.factor(config.factor());
            }

            private Builder override(Builder __superior) {
                if (__superior.factorType != null) {
                    this.factorType(__superior.factorType);
                }
                if (__superior.factor != null) {
                    this.factor(__superior.factor);
                }
                return this;
            }

            public Builder factorType(FactorType.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.factorType = __value;
                return this;
            }

            private Builder factorType(String __value) {
                return this.factorType(FactorType.Enum.valueOf(__value));
            }

            public Builder factor(double __value) {
                this.factor = __value;
                return this;
            }

            private Builder factor(String __value) {
                return this.factor(Double.valueOf(__value));
            }

            public Concurrency build() {
                return new Concurrency(this);
            }
        }

        public static final class FactorType
        extends EnumNode<Enum> {
            public static final Enum absolute = Enum.absolute;
            public static final Enum relative = Enum.relative;

            public FactorType() {
                this.value = null;
            }

            public FactorType(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                absolute,
                relative;

            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

