// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.orchestrator.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of orchestrator
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class OrchestratorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "6e219d782624697a8256471110590f04";
  public final static String CONFIG_DEF_NAME = "orchestrator";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.orchestrator.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.orchestrator.config",
    "serviceMonitorConvergenceLatencySeconds int default=0",
    "numProxies int default=0",
    "numProxiesAllowedDown int default=1",
    "numProxiesAllowedDownRatio double default=0.1"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer serviceMonitorConvergenceLatencySeconds = null;
    private Integer numProxies = null;
    private Integer numProxiesAllowedDown = null;
    private Double numProxiesAllowedDownRatio = null;

    public Builder() { }

    public Builder(OrchestratorConfig config) {
      serviceMonitorConvergenceLatencySeconds(config.serviceMonitorConvergenceLatencySeconds());
      numProxies(config.numProxies());
      numProxiesAllowedDown(config.numProxiesAllowedDown());
      numProxiesAllowedDownRatio(config.numProxiesAllowedDownRatio());
    }

    private Builder override(Builder __superior) {
      if (__superior.serviceMonitorConvergenceLatencySeconds != null)
        serviceMonitorConvergenceLatencySeconds(__superior.serviceMonitorConvergenceLatencySeconds);
      if (__superior.numProxies != null)
        numProxies(__superior.numProxies);
      if (__superior.numProxiesAllowedDown != null)
        numProxiesAllowedDown(__superior.numProxiesAllowedDown);
      if (__superior.numProxiesAllowedDownRatio != null)
        numProxiesAllowedDownRatio(__superior.numProxiesAllowedDownRatio);
      return this;
    }

    public Builder serviceMonitorConvergenceLatencySeconds(int __value) {
      serviceMonitorConvergenceLatencySeconds = __value;
      return this;
    }

    private Builder serviceMonitorConvergenceLatencySeconds(String __value) {
      return serviceMonitorConvergenceLatencySeconds(Integer.valueOf(__value));
    }

    public Builder numProxies(int __value) {
      numProxies = __value;
      return this;
    }

    private Builder numProxies(String __value) {
      return numProxies(Integer.valueOf(__value));
    }

    public Builder numProxiesAllowedDown(int __value) {
      numProxiesAllowedDown = __value;
      return this;
    }

    private Builder numProxiesAllowedDown(String __value) {
      return numProxiesAllowedDown(Integer.valueOf(__value));
    }

    public Builder numProxiesAllowedDownRatio(double __value) {
      numProxiesAllowedDownRatio = __value;
      return this;
    }

    private Builder numProxiesAllowedDownRatio(String __value) {
      return numProxiesAllowedDownRatio(Double.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public OrchestratorConfig build() {
      return new OrchestratorConfig(this);
    }

  }

  // TODO: Change the default to actual latency in real setup.
  private final IntegerNode serviceMonitorConvergenceLatencySeconds;
  // The number of services in the routing/container cluster of hosted-vespa.routing.default.
  private final IntegerNode numProxies;
  // The number of of the services that are allowed to be down for the routing container cluster
  // in the hosted-vespa.routing.default infrastructure application.
  private final IntegerNode numProxiesAllowedDown;
  // See numProxiesAllowedDown for background. Allow up to this ratio of services to be down,
  // unless already allowed by numProxiesAllowedDown.
  private final DoubleNode numProxiesAllowedDownRatio;

  public OrchestratorConfig(Builder builder) {
    this(builder, true);
  }

  private OrchestratorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "orchestrator must be initialized: " + builder.__uninitialized);

    serviceMonitorConvergenceLatencySeconds = (builder.serviceMonitorConvergenceLatencySeconds == null) ?
        new IntegerNode(0) : new IntegerNode(builder.serviceMonitorConvergenceLatencySeconds);
    numProxies = (builder.numProxies == null) ?
        new IntegerNode(0) : new IntegerNode(builder.numProxies);
    numProxiesAllowedDown = (builder.numProxiesAllowedDown == null) ?
        new IntegerNode(1) : new IntegerNode(builder.numProxiesAllowedDown);
    numProxiesAllowedDownRatio = (builder.numProxiesAllowedDownRatio == null) ?
        new DoubleNode(0.1D) : new DoubleNode(builder.numProxiesAllowedDownRatio);
  }

  /**
   * @return orchestrator.serviceMonitorConvergenceLatencySeconds
   */
  public int serviceMonitorConvergenceLatencySeconds() {
    return serviceMonitorConvergenceLatencySeconds.value();
  }

  /**
   * @return orchestrator.numProxies
   */
  public int numProxies() {
    return numProxies.value();
  }

  /**
   * @return orchestrator.numProxiesAllowedDown
   */
  public int numProxiesAllowedDown() {
    return numProxiesAllowedDown.value();
  }

  /**
   * @return orchestrator.numProxiesAllowedDownRatio
   */
  public double numProxiesAllowedDownRatio() {
    return numProxiesAllowedDownRatio.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(OrchestratorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("orchestrator");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
