// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.configdefinition;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of specialtokens
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Named lists of special tokens - string which should be
 * treated as words no matter what characters they consist of.
 * A special token can also optionally be replaced by another
 * token.
 *  
 * Special tokens are case sensitive, since queries and tokens
 * are lowercased they should normally be written in lower case.
 *  
 * The list named default is the only list which is used currently
 *  
 * Order matters in token lists. If one special token is a
 * prefix of another token, Vespa will prefer to return the first
 * matching token in the list when encountering the longest
 * special token.
 */
public final class SpecialtokensConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "385d8b4566e898e31fd9fbde4e9c8b65";
  public final static String CONFIG_DEF_NAME = "specialtokens";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.configdefinition";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.configdefinition",
    "makefsaPath string default=\"bin/vespa-makefsa\"",
    "tokenlist[].name string",
    "tokenlist[].tokens[].token string",
    "tokenlist[].tokens[].replace string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String makefsaPath = null;
    public List<Tokenlist.Builder> tokenlist = new ArrayList<>();

    public Builder() { }

    public Builder(SpecialtokensConfig config) {
      makefsaPath(config.makefsaPath());
      for (Tokenlist t : config.tokenlist()) {
        tokenlist(new Tokenlist.Builder(t));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.makefsaPath != null)
        makefsaPath(__superior.makefsaPath);
      if (!__superior.tokenlist.isEmpty())
        tokenlist.addAll(__superior.tokenlist);
      return this;
    }

    public Builder makefsaPath(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      makefsaPath = __value;
      return this;
    }


    /**
     * Add the given builder to this builder's list of Tokenlist builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder tokenlist(Tokenlist.Builder __builder) {
      tokenlist.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder tokenlist(java.util.function.Consumer<Tokenlist.Builder> __func) {
      Tokenlist.Builder __inner = new Tokenlist.Builder();
      __func.accept(__inner);
      tokenlist.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Tokenlist builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder tokenlist(List<Tokenlist.Builder> __builders) {
      tokenlist = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SpecialtokensConfig build() {
      return new SpecialtokensConfig(this);
    }

  }

  // Path to makefsa binary, needed to create specialtokens-dictionary
  // If the path is relative, vespa home is prepended
  private final StringNode makefsaPath;
  private final InnerNodeVector<Tokenlist> tokenlist;

  public SpecialtokensConfig(Builder builder) {
    this(builder, true);
  }

  private SpecialtokensConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "specialtokens must be initialized: " + builder.__uninitialized);

    makefsaPath = (builder.makefsaPath == null) ?
        new StringNode("bin/vespa-makefsa") : new StringNode(builder.makefsaPath);
    tokenlist = Tokenlist.createVector(builder.tokenlist);
  }

  /**
   * @return specialtokens.makefsaPath
   */
  public String makefsaPath() {
    return makefsaPath.value();
  }

  /**
   * @return specialtokens.tokenlist[]
   */
  public List<Tokenlist> tokenlist() {
    return tokenlist;
  }

  /**
   * @param i the index of the value to return
   * @return specialtokens.tokenlist[]
   */
  public Tokenlist tokenlist(int i) {
    return tokenlist.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SpecialtokensConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("specialtokens");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents specialtokens.tokenlist[]
   */
  public final static class Tokenlist extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public List<Tokens.Builder> tokens = new ArrayList<>();

      public Builder() { }

      public Builder(Tokenlist config) {
        name(config.name());
        for (Tokens t : config.tokens()) {
          tokens(new Tokens.Builder(t));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.tokens.isEmpty())
          tokens.addAll(__superior.tokens);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Tokens builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder tokens(Tokens.Builder __builder) {
        tokens.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder tokens(java.util.function.Consumer<Tokens.Builder> __func) {
        Tokens.Builder __inner = new Tokens.Builder();
        __func.accept(__inner);
        tokens.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Tokens builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder tokens(List<Tokens.Builder> __builders) {
        tokens = __builders;
        return this;
      }

      public Tokenlist build() {
        return new Tokenlist(this);
      }

    }

    // Use 'default' as the name of the list to use in regular
    // indexing and queries
    private final StringNode name;
    private final InnerNodeVector<Tokens> tokens;

    public Tokenlist(Builder builder) {
      this(builder, true);
    }

    private Tokenlist(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "specialtokens.tokenlist[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      tokens = Tokens.createVector(builder.tokens);
    }

    /**
     * @return specialtokens.tokenlist[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return specialtokens.tokenlist[].tokens[]
     */
    public List<Tokens> tokens() {
      return tokens;
    }

    /**
     * @param i the index of the value to return
     * @return specialtokens.tokenlist[].tokens[]
     */
    public Tokens tokens(int i) {
      return tokens.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Tokenlist newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("tokenlist");
      return changes;
    }

    private static InnerNodeVector<Tokenlist> createVector(List<Builder> builders) {
        List<Tokenlist> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Tokenlist(b));
        }
        return new InnerNodeVector<Tokenlist>(elems);
    }

    /**
     * This class represents specialtokens.tokenlist[].tokens[]
     */
    public final static class Tokens extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "token"
          ));

        private String token = null;
        private String replace = null;

        public Builder() { }

        public Builder(Tokens config) {
          token(config.token());
          replace(config.replace());
        }

        private Builder override(Builder __superior) {
          if (__superior.token != null)
            token(__superior.token);
          if (__superior.replace != null)
            replace(__superior.replace);
          return this;
        }

        public Builder token(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          token = __value;
          __uninitialized.remove("token");
          return this;
        }


        public Builder replace(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          replace = __value;
          return this;
        }


        public Tokens build() {
          return new Tokens(this);
        }

      }

      // Special tokens, any string is permitted
      private final StringNode token;
      // The token which should replace the special token
      // If no replace is set for a token, the word token
      // will be the special token string itself
      private final StringNode replace;

      public Tokens(Builder builder) {
        this(builder, true);
      }

      private Tokens(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "specialtokens.tokenlist[].tokens[] must be initialized: " + builder.__uninitialized);

        token = (builder.token == null) ?
            new StringNode() : new StringNode(builder.token);
        replace = (builder.replace == null) ?
            new StringNode("") : new StringNode(builder.replace);
      }

      /**
       * @return specialtokens.tokenlist[].tokens[].token
       */
      public String token() {
        return token.value();
      }

      /**
       * @return specialtokens.tokenlist[].tokens[].replace
       */
      public String replace() {
        return replace.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Tokens newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("tokens");
        return changes;
      }

      private static InnerNodeVector<Tokens> createVector(List<Builder> builders) {
          List<Tokens> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Tokens(b));
          }
          return new InnerNodeVector<Tokens>(elems);
      }
    }
  }

}
